/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.dao;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.entity.RealizationEntity;
import io.meeds.gamification.model.PiechartLeaderboard;
import io.meeds.gamification.model.ProfileReputation;
import io.meeds.gamification.model.StandardLeaderboard;
import io.meeds.gamification.model.filter.RealizationFilter;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class RealizationDAO
extends GenericDAOJPAImpl<RealizationEntity, Long> {
    private static final String DATE_PARAM_NAME = "date";
    private static final String TO_DATE_PARAM_NAME = "toDate";
    private static final String FROM_DATE_PARAM_NAME = "fromDate";
    private static final String SPACE_ID_PARAM_NAME = "spaceId";
    private static final String EARNER_ID_PARAM_NAME = "earnerId";
    private static final String EARNER_IDS_PARAM_NAME = "earnerIds";
    private static final String REVIEWER_IDS_PARAM_NAME = "earnerIds";
    private static final String PROGRAM_IDS_PARAM_NAME = "programIds";
    private static final String RULE_IDS_PARAM_NAME = "ruleIds";
    private static final String EARNER_TYPE_PARAM_NAME = "earnerType";
    public static final String STATUS_PARAM_NAME = "status";
    private static final String RULE_ID_PARAM_NAME = "ruleId";
    private static final String RECEIVER_ID_PARAM_NAME = "receiverId";
    private static final String OBJECT_ID_PARAM_NAME = "objectId";
    private static final String OBJECT_TYPE_PARAM_NAME = "objectType";
    private final Map<String, Boolean> filterNamedQueries = new ConcurrentHashMap<String, Boolean>();

    public int getLeaderboardRank(IdentityType earnerType, String earnerIdentityId) {
        Query query = this.getEntityManager().createNamedQuery("RealizationEntity.getLeaderboardRank");
        query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType).setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerIdentityId)).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        try {
            Object result = query.getSingleResult();
            return result == null ? 0 : Integer.parseInt(result.toString());
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    public int getLeaderboardRankByDatesAndProgramIds(IdentityType earnerType, String earnerIdentityId, Date fromDate, Date toDate, Long ... programIds) {
        Query query = this.getEntityManager().createNamedQuery("RealizationEntity.getLeaderboardRankByDatesAndProgramIds");
        query.setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate).setParameter(TO_DATE_PARAM_NAME, (Object)toDate).setParameter(PROGRAM_IDS_PARAM_NAME, Arrays.asList(programIds)).setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType).setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerIdentityId)).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        try {
            Object result = query.getSingleResult();
            return result == null ? 0 : Integer.parseInt(result.toString());
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    public int getLeaderboardRankByProgramIds(IdentityType earnerType, String earnerIdentityId, Long ... programIds) {
        Query query = this.getEntityManager().createNamedQuery("RealizationEntity.getLeaderboardRankByProgramIds");
        query.setParameter(PROGRAM_IDS_PARAM_NAME, Arrays.asList(programIds)).setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType).setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerIdentityId)).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        try {
            Object result = query.getSingleResult();
            return result == null ? 0 : Integer.parseInt(result.toString());
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    public int getLeaderboardRankByDates(IdentityType earnerType, String earnerIdentityId, Date fromDate, Date toDate) {
        Query query = this.getEntityManager().createNamedQuery("RealizationEntity.getLeaderboardRankByDates");
        query.setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate).setParameter(TO_DATE_PARAM_NAME, (Object)toDate).setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType).setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerIdentityId)).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        try {
            Object result = query.getSingleResult();
            return result == null ? 0 : Integer.parseInt(result.toString());
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    public List<StandardLeaderboard> getLeaderboard(IdentityType earnerType, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.getLeaderboard", StandardLeaderboard.class);
        query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public List<StandardLeaderboard> getLeaderboardByProgramIds(IdentityType earnerType, int offset, int limit, Long ... programIds) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.getLeaderboardByProgramIds", StandardLeaderboard.class);
        query.setParameter(PROGRAM_IDS_PARAM_NAME, Arrays.asList(programIds)).setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public List<StandardLeaderboard> getLeaderboardByDates(Date fromDate, Date toDate, IdentityType earnerType, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.getLeaderboardByDate", StandardLeaderboard.class);
        query.setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate).setParameter(TO_DATE_PARAM_NAME, (Object)toDate).setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public List<StandardLeaderboard> getLeaderboardByDatesAndProgramIds(Date fromDate, Date toDate, IdentityType earnerType, int offset, int limit, Long ... programIds) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.getLeaderboardByDateAndProgramIds", StandardLeaderboard.class);
        query.setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate).setParameter(TO_DATE_PARAM_NAME, (Object)toDate).setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType).setParameter(PROGRAM_IDS_PARAM_NAME, Arrays.asList(programIds)).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public long getScoreByIdentityId(String earnerIdentityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.getScoreByIdentityId", Long.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerIdentityId)).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        try {
            Long result = (Long)query.getSingleResult();
            return result == null ? 0L : result;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public List<PiechartLeaderboard> getLeaderboardStatsByIdentityIdAndDates(String earnerId, Long spaceId, Date fromDate, Date toDate) {
        boolean isSpaceQuery = spaceId != null && spaceId > 0L;
        String queryName = isSpaceQuery ? "RealizationEntity.getLeaderboardStatsByIdentityIdAndDatesAndSpaceId" : "RealizationEntity.getLeaderboardStatsByIdentityIdAndDates";
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, PiechartLeaderboard.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerId)).setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate).setParameter(TO_DATE_PARAM_NAME, (Object)toDate).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        if (isSpaceQuery) {
            query.setParameter(SPACE_ID_PARAM_NAME, (Object)spaceId);
        }
        return query.getResultList();
    }

    public List<PiechartLeaderboard> getLeaderboardStatsByIdentityId(String earnerId, Long spaceId) {
        boolean isSpaceQuery = spaceId != null && spaceId > 0L;
        String queryName = isSpaceQuery ? "RealizationEntity.getLeaderboardStatsByIdentityIdAndSpaceId" : "RealizationEntity.getLeaderboardStatsByIdentityId";
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, PiechartLeaderboard.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerId)).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        if (isSpaceQuery) {
            query.setParameter(SPACE_ID_PARAM_NAME, (Object)spaceId);
        }
        return query.getResultList();
    }

    public List<ProfileReputation> getScorePerProgramByIdentityId(String earnerId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.getScorePerProgramByIdentityId", ProfileReputation.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerId)).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        return query.getResultList();
    }

    public long getScoreByIdentityIdAndBetweenDates(String earnerId, Date fromDate, Date toDate, Long ... programIds) {
        Long count;
        boolean isProgramQuery = programIds != null && programIds.length > 0;
        String queryName = isProgramQuery ? "RealizationEntity.getScoreByIdentityIdAndBetweenDatesAndProgramIds" : "RealizationEntity.getScoreByIdentityIdAndBetweenDates";
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Long.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerId)).setParameter(FROM_DATE_PARAM_NAME, (Object)(fromDate == null ? new Date(0L) : fromDate)).setParameter(TO_DATE_PARAM_NAME, (Object)(toDate == null ? new Date() : toDate)).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        if (isProgramQuery) {
            query.setParameter(PROGRAM_IDS_PARAM_NAME, Arrays.asList(programIds));
        }
        return (count = (Long)query.getSingleResult()) == null ? 0L : count;
    }

    public Map<Long, Long> getScoreByIdentityIdsAndBetweenDates(List<String> earnersId, Date fromDate, Date toDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.getScoreByIdentityIdsAndBetweenDates", Tuple.class);
        query.setParameter("earnersId", earnersId.stream().map(Long::parseLong).toList()).setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate).setParameter(TO_DATE_PARAM_NAME, (Object)toDate).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        return query.getResultList().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get(0, Long.class), tuple -> (Long)tuple.get(1, Long.class)));
    }

    public int countRealizationsByRuleIdAndEarnerId(String earnerIdentityId, long ruleId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.countRealizationsByRuleIdAndEarnerId", Long.class);
        query.setParameter(RULE_ID_PARAM_NAME, (Object)ruleId).setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerIdentityId)).setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        try {
            Long count = (Long)query.getSingleResult();
            return count == null ? 0 : count.intValue();
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    public List<Long> getParticipantsBetweenDates(Date fromDate, Date toDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.getParticipantsBetweenDates", Long.class);
        query.setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate);
        query.setParameter(TO_DATE_PARAM_NAME, (Object)toDate);
        query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)IdentityType.USER);
        query.setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public long countParticipantsBetweenDates(Date fromDate, Date toDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.countParticipantsBetweenDates", Long.class);
        query.setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate);
        query.setParameter(TO_DATE_PARAM_NAME, (Object)toDate);
        query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)IdentityType.USER);
        query.setParameter(STATUS_PARAM_NAME, (Object)RealizationStatus.ACCEPTED);
        try {
            Long count = (Long)query.getSingleResult();
            return count == null ? 0L : (long)count.intValue();
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public int countRealizationsInPeriod(String earnerIdentityId, long ruleId, Date sinceDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.countRealizationsInPeriod", Long.class);
        query.setParameter(DATE_PARAM_NAME, (Object)sinceDate).setParameter(RULE_ID_PARAM_NAME, (Object)ruleId).setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerIdentityId)).setParameter(STATUS_PARAM_NAME, List.of(RealizationStatus.ACCEPTED, RealizationStatus.PENDING));
        try {
            Long count = (Long)query.getSingleResult();
            return count == null ? 0 : count.intValue();
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    public Long findLastRealizationByRuleIdAndEarnerIdAndReceiverAndObjectId(long ruleId, String earnerId, String receiverId, String objectId, String objectType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.findRealizationsByRuleIdAndEarnerIdAndReceiverAndObjectId", Long.class);
        query.setParameter(RULE_ID_PARAM_NAME, (Object)ruleId).setParameter(EARNER_ID_PARAM_NAME, (Object)Long.parseLong(earnerId)).setParameter(RECEIVER_ID_PARAM_NAME, (Object)receiverId).setParameter(OBJECT_ID_PARAM_NAME, (Object)objectId).setParameter(OBJECT_TYPE_PARAM_NAME, (Object)objectType).setParameter(STATUS_PARAM_NAME, List.of(RealizationStatus.ACCEPTED, RealizationStatus.PENDING));
        query.setMaxResults(1);
        List resultList = query.getResultList();
        return CollectionUtils.isEmpty((Collection)resultList) ? null : (Long)resultList.getFirst();
    }

    public List<Long> getRealizationsByObjectIdAndObjectType(String objectId, String objectType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RealizationEntity.getRealizationsByObjectIdAndObjectType", Tuple.class);
        query.setParameter(OBJECT_ID_PARAM_NAME, (Object)objectId);
        query.setParameter(OBJECT_TYPE_PARAM_NAME, (Object)objectType);
        try {
            return query.getResultList().stream().map(t -> (Long)t.get(0, Long.class)).toList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<Long> findRealizationsByFilter(RealizationFilter realizationFilter, int offset, int limit) {
        TypedQuery<Tuple> query = this.buildQueryFromFilter(realizationFilter, Tuple.class, false);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query.getResultList().stream().map(t -> (Long)t.get(0, Long.class)).toList();
    }

    public int countRealizationsByFilter(RealizationFilter filter) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, true);
        return ((Long)query.getSingleResult()).intValue();
    }

    private <T> TypedQuery<T> buildQueryFromFilter(RealizationFilter filter, Class<T> clazz, boolean count) {
        TypedQuery query;
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> predicates = new ArrayList<String>();
        this.buildPredicates(filter, suffixes, predicates);
        String queryName = this.getQueryFilterName(suffixes, count);
        if (this.filterNamedQueries.containsKey(queryName)) {
            query = this.getEntityManager().createNamedQuery(queryName, clazz);
        } else {
            String queryContent = this.getQueryFilterContent(filter, predicates, count);
            query = this.getEntityManager().createQuery(queryContent, clazz);
            this.getEntityManager().getEntityManagerFactory().addNamedQuery(queryName, (Query)query);
            this.filterNamedQueries.put(queryName, true);
        }
        this.addQueryFilterParameters(filter, query);
        return query;
    }

    private void buildPredicates(RealizationFilter filter, List<String> suffixes, List<String> predicates) {
        if (filter.getEarnerType() != null) {
            suffixes.add("EarnerType");
            predicates.add("g.earnerType = :earnerType");
        }
        if (filter.getFromDate() != null && filter.getToDate() != null) {
            suffixes.add("Interval");
            predicates.add("g.createdDate >= :fromDate AND g.createdDate < :toDate");
        }
        if (CollectionUtils.isNotEmpty(filter.getEarnerIds())) {
            suffixes.add("EarnerIds");
            predicates.add("g.earnerId IN (:earnerIds)");
        }
        if (CollectionUtils.isNotEmpty(filter.getProgramIds())) {
            suffixes.add("ProgramIds");
            predicates.add("g.domainEntity.id IN (:programIds)");
        }
        if (CollectionUtils.isNotEmpty(filter.getRuleIds())) {
            suffixes.add("RuleIds");
            predicates.add("g.ruleEntity.id IN (:ruleIds)");
        }
        if (CollectionUtils.isNotEmpty(filter.getReviewerIds())) {
            suffixes.add("ReviewerIds");
            predicates.add("g.reviewerId IN (:earnerIds)");
        }
        if (filter.getStatus() != null) {
            suffixes.add("Status");
            predicates.add("g.status = :status");
        }
        suffixes.add(this.getSortField(filter));
        suffixes.add(filter.isSortDescending() ? "Descending" : "Ascending");
    }

    private String getQueryFilterName(List<String> suffixes, boolean count) {
        Object queryName = suffixes.isEmpty() ? (count ? "RealizationEntity.countRealizations" : "RealizationEntity.findRealizations") : (count ? "RealizationEntity.countRealizations" : "RealizationEntity.findRealizations") + "By" + StringUtils.join(suffixes, (String)"And");
        return queryName;
    }

    private String getQueryFilterContent(RealizationFilter filter, List<String> predicates, boolean count) {
        String querySelect = count ? "SELECT COUNT(g) FROM RealizationEntity g " : "SELECT DISTINCT g.id, g." + this.getSortRealizationField(filter) + " FROM RealizationEntity g ";
        Object queryContent = predicates.isEmpty() ? querySelect : querySelect + " WHERE " + StringUtils.join(predicates, (String)" AND ");
        if (!count) {
            String sortDirection = filter.isSortDescending() ? "DESC" : "ASC";
            String sortField = this.getSortField(filter);
            queryContent = StringUtils.equals((CharSequence)sortField, (CharSequence)DATE_PARAM_NAME) ? (String)queryContent + " ORDER BY g.id " + sortDirection : (String)queryContent + " ORDER BY g." + sortField + " " + sortDirection + " ,g.id DESC ";
        }
        return queryContent;
    }

    private <T> void addQueryFilterParameters(RealizationFilter filter, TypedQuery<T> query) {
        if (filter.getEarnerType() != null) {
            query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)filter.getEarnerType());
        }
        if (filter.getFromDate() != null && filter.getToDate() != null) {
            query.setParameter(FROM_DATE_PARAM_NAME, (Object)filter.getFromDate());
            query.setParameter(TO_DATE_PARAM_NAME, (Object)filter.getToDate());
        }
        if (CollectionUtils.isNotEmpty(filter.getEarnerIds())) {
            query.setParameter("earnerIds", filter.getEarnerIds().stream().map(Long::parseLong).toList());
        }
        if (CollectionUtils.isNotEmpty(filter.getProgramIds())) {
            query.setParameter(PROGRAM_IDS_PARAM_NAME, filter.getProgramIds());
        }
        if (CollectionUtils.isNotEmpty(filter.getRuleIds())) {
            query.setParameter(RULE_IDS_PARAM_NAME, filter.getRuleIds());
        }
        if (CollectionUtils.isNotEmpty(filter.getReviewerIds())) {
            query.setParameter("earnerIds", filter.getReviewerIds());
        }
        if (filter.getStatus() != null) {
            query.setParameter(STATUS_PARAM_NAME, (Object)filter.getStatus());
        }
    }

    private String getSortRealizationField(RealizationFilter filter) {
        if (StringUtils.isBlank((CharSequence)filter.getSortField()) || StringUtils.equals((CharSequence)DATE_PARAM_NAME, (CharSequence)filter.getSortField())) {
            return "createdDate";
        }
        switch (filter.getSortField()) {
            case "status": 
            case "type": 
            case "earnerId": 
            case "receiver": 
            case "objectId": 
            case "objectType": 
            case "earnerType": 
            case "actionScore": 
            case "globalScore": 
            case "date": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected Sort Field value: " + filter.getSortField());
            }
        }
        return filter.getSortField();
    }

    private String getSortField(RealizationFilter filter) {
        if (StringUtils.isBlank((CharSequence)filter.getSortField())) {
            return DATE_PARAM_NAME;
        }
        switch (filter.getSortField()) {
            case "status": 
            case "type": 
            case "earnerId": 
            case "receiver": 
            case "objectId": 
            case "objectType": 
            case "earnerType": 
            case "actionScore": 
            case "globalScore": 
            case "date": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected Sort Field value: " + filter.getSortField());
            }
        }
        return filter.getSortField();
    }
}

