/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.exoplatform.commons.utils.IOUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class EntityResolverImpl
implements EntityResolver {
    private final Map<String, String> systemIdToResourcePath;
    private final ConcurrentMap<String, byte[]> systemIdToSource;
    private final ClassLoader loader;

    public EntityResolverImpl(ClassLoader loader, Map<String, String> systemIdToResourcePath) {
        this.systemIdToResourcePath = new HashMap<String, String>(systemIdToResourcePath);
        this.systemIdToSource = new ConcurrentHashMap<String, byte[]>();
        this.loader = loader;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId != null) {
            byte[] data = (byte[])this.systemIdToSource.get(systemId);
            if (data == null) {
                InputStream in;
                String path = this.systemIdToResourcePath.get(systemId);
                if (path != null && (in = this.loader.getResourceAsStream(path)) != null) {
                    data = IOUtil.getStreamContentAsBytes((InputStream)in);
                }
                if (data == null) {
                    data = new byte[]{};
                }
                this.systemIdToSource.put(systemId, data);
                if (this.systemIdToSource.size() > 1000) {
                    this.systemIdToSource.clear();
                }
            }
            if (data != null && data.length > 0) {
                return new InputSource(new ByteArrayInputStream(data));
            }
        }
        return null;
    }
}

