/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.service;

import io.meeds.wallet.lock.Lock;
import io.meeds.wallet.lock.LockAspect;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.model.settings.GlobalSettings;
import org.exoplatform.wallet.model.settings.InitialFundsSettings;
import org.exoplatform.wallet.model.settings.NetworkSettings;
import org.exoplatform.wallet.model.settings.UserSettings;
import org.exoplatform.wallet.model.settings.WalletSettings;
import org.exoplatform.wallet.model.transaction.FundsRequest;
import org.exoplatform.wallet.service.BlockchainTransactionService;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletContractService;
import org.exoplatform.wallet.service.WalletService;
import org.exoplatform.wallet.service.WalletServiceImpl$AjcClosure1;
import org.exoplatform.wallet.service.WalletWebSocketService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.picocontainer.Startable;

public class WalletServiceImpl
implements WalletService,
Startable {
    private static final String METAMASK_FEATURE_NAME = "walletMetamask";
    private static final Log LOG;
    private ExoContainer container;
    private WalletContractService contractService;
    private WalletAccountService accountService;
    private SettingService settingService;
    private BlockchainTransactionService blockchainTransactionService;
    private WebNotificationStorage webNotificationStorage;
    private WalletWebSocketService webSocketService;
    private ExoFeatureService featureService;
    private GlobalSettings configuredGlobalSettings = new GlobalSettings();
    private double dynamicGasPrice;
    private long dynamicGasPriceLastUpdateTime = System.currentTimeMillis();
    private long dynamicGasPriceUpdateInterval = 120000L;
    private Double initialUserFunds;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public WalletServiceImpl(WalletContractService contractService, WalletAccountService accountService, WalletWebSocketService webSocketService, WebNotificationStorage webNotificationStorage, ExoFeatureService featureService, PortalContainer container, InitParams params) {
        String value;
        this.container = container;
        this.accountService = accountService;
        this.contractService = contractService;
        this.webSocketService = webSocketService;
        this.webNotificationStorage = webNotificationStorage;
        this.featureService = featureService;
        NetworkSettings network = this.configuredGlobalSettings.getNetwork();
        if (params.containsKey((Object)"networkId")) {
            value = params.getValueParam("networkId").getValue();
            long defaultNetworkId = Long.parseLong(value);
            network.setId(defaultNetworkId);
        }
        if (params.containsKey((Object)"networkURL")) {
            String defaultNetworkURL = params.getValueParam("networkURL").getValue();
            network.setProviderURL(defaultNetworkURL);
        }
        if (params.containsKey((Object)"networkWSURL")) {
            String defaultNetworkWsURL = params.getValueParam("networkWSURL").getValue();
            network.setWebsocketProviderURL(defaultNetworkWsURL);
        }
        if (params.containsKey((Object)"defaultInitialFunds")) {
            value = params.getValueParam("defaultInitialFunds").getValue();
            try {
                this.initialUserFunds = Double.parseDouble(value);
            }
            catch (NumberFormatException defaultNetworkId) {
                // empty catch block
            }
        }
        if (params.containsKey((Object)"gasLimit")) {
            value = params.getValueParam("gasLimit").getValue();
            long gasLimit = Long.parseLong(value);
            network.setGasLimit(Long.valueOf(gasLimit));
        }
        long minGasPrice = 4000000000L;
        if (params.containsKey((Object)"cheapGasPrice")) {
            String value2 = params.getValueParam("cheapGasPrice").getValue();
            minGasPrice = Long.parseLong(value2);
        }
        network.setMinGasPrice(Long.valueOf(minGasPrice));
        long normalGasPrice = 4000000000L;
        if (params.containsKey((Object)"normalGasPrice")) {
            String value3 = params.getValueParam("normalGasPrice").getValue();
            normalGasPrice = Long.parseLong(value3);
        }
        network.setNormalGasPrice(Long.valueOf(normalGasPrice));
        long maxGasPrice = 4000000000L;
        if (params.containsKey((Object)"fastGasPrice")) {
            String value4 = params.getValueParam("fastGasPrice").getValue();
            maxGasPrice = Long.parseLong(value4);
        }
        network.setMaxGasPrice(Long.valueOf(maxGasPrice));
        if (params.containsKey((Object)"tokenAddress")) {
            String contractAddress = params.getValueParam("tokenAddress").getValue();
            this.configuredGlobalSettings.setContractAddress(contractAddress);
        }
        if (params.containsKey((Object)"gasPriceUpdateInterval")) {
            String gasPriceUpdateIntervalValue = params.getValueParam("gasPriceUpdateInterval").getValue();
            this.dynamicGasPriceUpdateInterval = Long.parseLong(gasPriceUpdateIntervalValue);
        }
    }

    public void start() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.computeInitialFundsSettings();
            this.configuredGlobalSettings.setContractAbi(this.contractService.getContractAbi().toString());
            this.configuredGlobalSettings.setContractBin(this.contractService.getContractBinary());
            String contractAddress = this.configuredGlobalSettings.getContractAddress();
            if (StringUtils.isBlank((CharSequence)contractAddress)) {
                LOG.warn((Object)"Contract address configuration is empty");
            } else {
                ContractDetail contractDetail = this.contractService.getContractDetail(contractAddress);
                this.configuredGlobalSettings.setContractDetail(contractDetail);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    public void setConfiguredContractDetail(ContractDetail contractDetail) {
        this.configuredGlobalSettings.setContractDetail(contractDetail);
    }

    public InitialFundsSettings getInitialFundsSettings() {
        SettingValue initialFundsSettingsValue = this.getSettingService().get(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "INITIAL_FUNDS");
        InitialFundsSettings initialFundsSettings = null;
        if (initialFundsSettingsValue != null && initialFundsSettingsValue.getValue() != null) {
            initialFundsSettings = (InitialFundsSettings)WalletUtils.fromJsonString((String)initialFundsSettingsValue.getValue().toString(), InitialFundsSettings.class);
        }
        return initialFundsSettings;
    }

    public void saveInitialFundsSettings(InitialFundsSettings initialFundsSettings) {
        if (initialFundsSettings == null) {
            throw new IllegalArgumentException("initialFundsSettings parameter is mandatory");
        }
        LOG.debug("Saving initial funds settings: {}", new Object[]{initialFundsSettings});
        this.getSettingService().set(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "INITIAL_FUNDS", SettingValue.create((String)WalletUtils.toJsonString((Object)initialFundsSettings)));
    }

    public GlobalSettings getSettings() {
        return this.configuredGlobalSettings.clone();
    }

    public UserSettings getUserSettings(String spaceId, String currentUser, boolean isAdministration) {
        GlobalSettings globalSettings = this.getSettings();
        UserSettings userSettings = new UserSettings(globalSettings);
        userSettings.setEnabled(this.isEnabled());
        userSettings.setWalletEnabled(true);
        Wallet wallet = null;
        if (StringUtils.isNotBlank((CharSequence)spaceId)) {
            wallet = this.accountService.getWalletByTypeAndId(WalletType.SPACE.getId(), spaceId, currentUser);
            if (wallet != null && !WalletUtils.canAccessWallet((Wallet)wallet, (String)currentUser)) {
                LOG.warn("User {} is not allowed to display space wallet {}", new Object[]{currentUser, spaceId});
                userSettings.setWalletEnabled(false);
            }
        } else {
            wallet = this.accountService.getWalletByTypeAndId(WalletType.USER.getId(), currentUser, currentUser);
        }
        if (wallet != null) {
            userSettings.setWalletEnabled(userSettings.isWalletEnabled() && wallet.isEnabled());
        }
        if (userSettings.isWalletEnabled()) {
            userSettings.setCometdToken(this.webSocketService.getUserToken(currentUser));
            userSettings.setCometdContext(this.webSocketService.getCometdContextName());
            SettingValue userSettingsValue = this.getSettingService().get(Context.USER.id(currentUser), WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_SETTINGS");
            WalletSettings walletSettings = null;
            walletSettings = userSettingsValue != null && userSettingsValue.getValue() != null ? (WalletSettings)WalletUtils.fromJsonString((String)userSettingsValue.getValue().toString(), WalletSettings.class) : new WalletSettings();
            userSettings.setUserPreferences(walletSettings);
            if (wallet != null) {
                walletSettings.setWalletAddress(wallet.getAddress());
                if (this.accountService.isWalletOwner(wallet, currentUser)) {
                    walletSettings.setPhrase(wallet.getPassPhrase());
                    walletSettings.setHasKeyOnServerSide(wallet.isHasPrivateKey());
                } else {
                    WalletUtils.hideWalletOwnerPrivateInformation((Wallet)wallet);
                }
                this.accountService.retrieveWalletBlockchainState(wallet);
                userSettings.setWallet(wallet);
            }
            walletSettings.setAddresesLabels(this.accountService.getAddressesLabelsVisibleBy(currentUser));
            if (isAdministration && WalletUtils.isUserMemberOfGroupOrUser((String)currentUser, (String)"/platform/rewarding")) {
                userSettings.setInitialFunds(this.getInitialFundsSettings());
            }
            userSettings.setMetamaskEnabled(this.featureService.isFeatureActiveForUser(METAMASK_FEATURE_NAME, currentUser));
        }
        return userSettings;
    }

    public void saveUserPreferences(String currentUser, WalletSettings userPreferences) {
        if (userPreferences == null) {
            throw new IllegalArgumentException("userPreferences parameter is mandatory");
        }
        this.getSettingService().set(Context.USER.id(currentUser), WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_SETTINGS", SettingValue.create((String)WalletUtils.toJsonString((Object)userPreferences)));
    }

    public void requestFunds(FundsRequest fundsRequest, String currentUser) throws IllegalAccessException {
        Wallet requestSender = this.accountService.getWalletByAddress(fundsRequest.getAddress());
        if (StringUtils.isNotBlank((CharSequence)currentUser)) {
            if (requestSender == null) {
                throw new IllegalStateException("Bad request sent to server with unknown sender address");
            }
            String requestSenderId = requestSender.getId();
            String requestSenderType = requestSender.getType();
            if (WalletType.isUser((String)requestSenderType) && !StringUtils.equals((CharSequence)currentUser, (CharSequence)requestSenderId)) {
                LOG.warn("Bad request sent to server with invalid sender type or id {} / {}", new Object[]{requestSenderType, requestSenderId});
                throw new IllegalAccessException("Bad request sent to server with invalid sender");
            }
            if (WalletType.isSpace((String)requestSenderType) && !WalletUtils.isUserSpaceMember((String)requestSenderId, (String)currentUser)) {
                throw new IllegalAccessException("User '" + currentUser + "' is not allowed to request funds on behalf of space " + requestSenderId);
            }
        }
        String requestReceipientId = fundsRequest.getReceipient();
        String requestReceipientType = fundsRequest.getReceipientType();
        Wallet requestReceipient = this.accountService.getWalletByTypeAndId(WalletType.getType((String)requestReceipientType).getId(), requestReceipientId);
        if (requestReceipient == null || requestReceipient.getTechnicalId() == 0L) {
            LOG.warn("Can't find fund request recipient with id {} and type {}", new Object[]{requestReceipientId, requestReceipientType});
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(WalletUtils.FUNDS_REQUEST_SENDER_DETAIL_PARAMETER, (Object)this.accountService.getWalletByTypeAndId(WalletType.USER.getId(), currentUser));
        ctx.append(WalletUtils.SENDER_ACCOUNT_DETAIL_PARAMETER, (Object)requestSender);
        ctx.append(WalletUtils.RECEIVER_ACCOUNT_DETAIL_PARAMETER, (Object)requestReceipient);
        ctx.append(WalletUtils.FUNDS_REQUEST_PARAMETER, (Object)fundsRequest);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"FundsRequestNotificationPlugin"))).execute(ctx);
    }

    public void markFundRequestAsSent(String notificationId, String currentUser) throws IllegalAccessException {
        NotificationInfo notificationInfo = this.webNotificationStorage.get(notificationId);
        if (notificationInfo == null) {
            throw new IllegalStateException("Notification with id " + notificationId + " wasn't found");
        }
        if (notificationInfo.getTo() == null || !currentUser.equals(notificationInfo.getTo())) {
            throw new IllegalAccessException("Target user of notification '" + notificationId + "' is different from current user");
        }
        notificationInfo.getOwnerParameter().put("sent", "true");
        this.webNotificationStorage.update(notificationInfo, false);
    }

    public boolean isFundRequestSent(String notificationId, String currentUser) throws IllegalAccessException {
        NotificationInfo notificationInfo = this.webNotificationStorage.get(notificationId);
        if (notificationInfo == null) {
            throw new IllegalStateException("Notification with id " + notificationId + " wasn't found");
        }
        if (notificationInfo.getTo() == null || !currentUser.equals(notificationInfo.getTo())) {
            throw new IllegalAccessException("Target user of notification '" + notificationId + "' is different from current user");
        }
        String fundRequestSentString = (String)notificationInfo.getOwnerParameter().get("sent");
        return Boolean.parseBoolean(fundRequestSentString);
    }

    public boolean isEnabled() {
        return this.accountService.isAdminAccountEnabled();
    }

    public double getGasPrice() {
        if (this.dynamicGasPrice == 0.0 || System.currentTimeMillis() - this.dynamicGasPriceLastUpdateTime > this.dynamicGasPriceUpdateInterval) {
            try {
                return this.getGasPriceBlocking();
            }
            catch (Exception e) {
                LOG.debug((Object)"Error retrieving gas price from blockchain. Return normal gas price setting", (Throwable)e);
                return this.getSettings().getNetwork().getNormalGasPrice().longValue();
            }
        }
        return this.dynamicGasPrice;
    }

    public void setGasPrice(double blockchainGasPrice) {
        NetworkSettings network = this.getSettings().getNetwork();
        Long maxGasPriceInWei = network.getMaxGasPrice();
        if (blockchainGasPrice > (double)maxGasPriceInWei.longValue()) {
            LOG.info("GAS Price detected on blockchain '{}' GWEI exceeds maximum allowed gas price '{}' GWEI, thus the maximum gas price will be used instead.", new Object[]{WalletUtils.convertFromDecimals((BigInteger)BigDecimal.valueOf(blockchainGasPrice).toBigInteger(), (int)9), WalletUtils.convertFromDecimals((BigInteger)BigInteger.valueOf(maxGasPriceInWei), (int)9)});
            blockchainGasPrice = maxGasPriceInWei.longValue();
        }
        this.dynamicGasPrice = blockchainGasPrice;
    }

    private void computeInitialFundsSettings() {
        InitialFundsSettings initialFundsSettings = this.getInitialFundsSettings();
        if (initialFundsSettings == null) {
            initialFundsSettings = new InitialFundsSettings();
        }
        double etherAmount = this.computeInitialEtherFund();
        initialFundsSettings.setEtherAmount(etherAmount);
        this.saveInitialFundsSettings(initialFundsSettings);
    }

    private double computeInitialEtherFund() {
        if (this.initialUserFunds != null) {
            return this.initialUserFunds;
        }
        NetworkSettings network = this.configuredGlobalSettings.getNetwork();
        long gasLimit = 200000L;
        long gasPrice = 20000000000L;
        if (network != null) {
            if (network.getGasLimit() != null && network.getGasLimit() > 0L) {
                gasLimit = network.getGasLimit();
            }
            if (network.getMaxGasPrice() != null && network.getMaxGasPrice() > 0L) {
                gasPrice = network.getMaxGasPrice();
            }
        }
        BigInteger etherAmountInWEI = new BigInteger(String.valueOf(gasLimit)).multiply(new BigInteger(String.valueOf(gasPrice)));
        double etherInitialFund = WalletUtils.convertFromDecimals((BigInteger)etherAmountInWEI, (int)18);
        double etherAmountMaxDecimals = 3.0;
        double etherAmountDecimals = Math.pow(10.0, etherAmountMaxDecimals);
        return Math.ceil(etherInitialFund * etherAmountDecimals) / etherAmountDecimals;
    }

    @Lock(duration=30, timeUnit=TimeUnit.SECONDS)
    private double getGasPriceBlocking() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        WalletServiceImpl$AjcClosure1 walletServiceImpl$AjcClosure1 = new WalletServiceImpl$AjcClosure1(objectArray);
        return Conversions.doubleValue((Object)LockAspect.aspectOf().around(walletServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        }
        return this.settingService;
    }

    private BlockchainTransactionService getBlockchainTransactionService() {
        if (this.blockchainTransactionService == null) {
            this.blockchainTransactionService = (BlockchainTransactionService)CommonsUtils.getService(BlockchainTransactionService.class);
        }
        return this.blockchainTransactionService;
    }

    static {
        WalletServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(WalletServiceImpl.class);
    }

    static final /* synthetic */ double getGasPriceBlocking_aroundBody0(WalletServiceImpl ajc$this, JoinPoint joinPoint) {
        if (ajc$this.dynamicGasPrice == 0.0 || System.currentTimeMillis() - ajc$this.dynamicGasPriceLastUpdateTime > ajc$this.dynamicGasPriceUpdateInterval) {
            double gasPrice = ajc$this.getBlockchainTransactionService().getGasPrice();
            ajc$this.setGasPrice(gasPrice);
            ajc$this.dynamicGasPriceLastUpdateTime = System.currentTimeMillis();
        }
        return ajc$this.dynamicGasPrice;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WalletServiceImpl.java", WalletServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGasPriceBlocking", "org.exoplatform.wallet.service.WalletServiceImpl", "", "", "java.io.IOException", "double"), 468);
    }
}

