/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;

@ComponentConfig(template="system:/groovy/portal/webui/page/UIPageBody.gtmpl")
public class UIPageBody
extends UIComponentDecorator {
    private String storageId;
    private final Log log = ExoLogger.getLogger(UIPageBody.class);

    public UIPageBody() {
        this.setId("UIPageBody");
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public String getPageName() {
        UIPage uiPage = this.getUIPage();
        return uiPage == null ? null : uiPage.getName();
    }

    public void setPageBody(UserNode pageNode, UIPortal uiPortal) throws Exception {
        PortalRequestContext context = Util.getPortalRequestContext();
        uiPortal.setMaximizedUIComponent(null);
        UIPage uiPage = this.getUIPage();
        if (uiPage == null) {
            uiPage = context.getUIPage(pageNode, uiPortal);
            if (uiPage == null) {
                this.setUIComponent(null);
                return;
            }
            this.setUIComponent(uiPage);
        }
        if (uiPage.isShowMaxWindow()) {
            context.setShowMaxWindow(true);
        }
        if (uiPage.isHideSharedLayout()) {
            context.setHideSharedLayout(true);
        }
        if (context.isShowMaxWindow()) {
            uiPortal.setMaximizedUIComponent(uiPage);
        } else {
            UIComponent maximizedComponent = uiPortal.getMaximizedUIComponent();
            if (maximizedComponent instanceof UIPage) {
                uiPortal.setMaximizedUIComponent(null);
            }
        }
    }

    @Override
    public UIComponent getUIComponent() {
        return PortalRequestContext.getCurrentInstance().getUiPage();
    }

    @Override
    protected void setChildComponent(UIComponent uicomponent) {
        PortalRequestContext.getCurrentInstance().setUiPage((UIPage)uicomponent);
    }

    public UIPage getUIPage() {
        return (UIPage)this.getUIComponent();
    }

    private PortalRequestContext getRequestContext() {
        return PortalRequestContext.getCurrentInstance();
    }
}

