/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.plugin;

import io.meeds.gamification.plugin.EventPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TaskEventPlugin
extends EventPlugin {
    public static final String EVENT_TYPE = "task";

    public String getEventType() {
        return EVENT_TYPE;
    }

    public List<String> getTriggers() {
        return List.of("createNewTask", "completeTaskAssigned", "completeTaskCoworker", "completeTask", "updateTask", "commentTask");
    }

    public boolean isValidEvent(Map<String, String> eventProperties, String triggerDetails) {
        List desiredProjectIds = eventProperties.get("projectIds") != null ? Arrays.asList(eventProperties.get("projectIds").split(",")) : Collections.emptyList();
        return CollectionUtils.isNotEmpty(desiredProjectIds) && desiredProjectIds.contains(TaskEventPlugin.getProjectId(triggerDetails));
    }

    private static String getProjectId(String mapAsString) {
        if (StringUtils.isNotBlank((CharSequence)mapAsString)) {
            String[] pairs;
            HashMap<String, String> map = new HashMap<String, String>();
            mapAsString = mapAsString.substring(1, mapAsString.length() - 1);
            for (String pair : pairs = mapAsString.split(", ")) {
                String[] keyValue = pair.split(": ");
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                map.put(key, value);
            }
            return (String)map.get("projectId");
        }
        return null;
    }
}

