/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.utils;

import io.meeds.tenant.hub.constant.HubReportStatusType;
import io.meeds.tenant.hub.model.HubReportLocalStatus;
import io.meeds.wom.api.model.HubReport;
import io.meeds.wom.api.model.HubReportPayload;
import java.time.Instant;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.model.reward.WalletReward;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.utils.WalletUtils;

public class EntityMapper {
    private EntityMapper() {
    }

    public static HubReportPayload toHubReport(RewardReport rewardReport, String hubAddress, long deedId, long usersCount, long participantsCount, long achievementsCount, long actionsCount, Instant sentDate) {
        RewardPeriod rewardPeriod = rewardReport.getPeriod();
        long recipientsCount = rewardReport.getValidRewardCount();
        double hubRewardAmount = rewardReport.getTokensSent();
        double hubTopReceiverAmount = rewardReport.getValidRewards().stream().filter(Objects::nonNull).mapToDouble(WalletReward::getTokensSent).max().orElse(0.0);
        SortedSet transactions = rewardReport.getValidRewards().stream().filter(Objects::nonNull).map(WalletReward::getTransaction).filter(Objects::nonNull).filter(TransactionDetail::isSucceeded).map(TransactionDetail::getHash).filter(Objects::nonNull).collect(Collectors.toCollection(TreeSet::new));
        String periodType = rewardPeriod.getRewardPeriodType().name();
        Instant toDate = Instant.ofEpochSecond(rewardPeriod.getEndDateInSeconds());
        Instant fromDate = Instant.ofEpochSecond(rewardPeriod.getStartDateInSeconds());
        String rewardTokenAddress = WalletUtils.getContractAddress();
        long rewardTokenNetworkId = WalletUtils.getNetworkId();
        return new HubReportPayload(0L, StringUtils.lowerCase((String)hubAddress), deedId, fromDate, toDate, sentDate, periodType, usersCount, participantsCount, recipientsCount, achievementsCount, actionsCount, StringUtils.lowerCase((String)rewardTokenAddress), rewardTokenNetworkId, hubRewardAmount, hubTopReceiverAmount, EntityMapper.lowerCase(transactions));
    }

    public static HubReportLocalStatus toHubLocalReport(HubReportPayload reportData, long periodId, long reportId, boolean canRefresh, boolean canSend, HubReportStatusType statusType, String errorMessageKey) {
        return new HubReportLocalStatus(reportId, reportData.getHubAddress(), reportData.getDeedId(), reportData.getFromDate(), reportData.getToDate(), reportData.getSentDate(), reportData.getPeriodType(), reportData.getUsersCount(), reportData.getParticipantsCount(), reportData.getRecipientsCount(), reportData.getAchievementsCount(), reportData.getActionsCount(), reportData.getRewardTokenAddress(), reportData.getRewardTokenNetworkId(), reportData.getHubRewardAmount(), reportData.getHubTopRewardedAmount(), reportData.getTransactions(), periodId, canRefresh, canSend, statusType, errorMessageKey);
    }

    public static HubReportLocalStatus toHubLocalReport(HubReport report, long id, boolean canRefresh, boolean canSend, HubReportStatusType status, String error) {
        return new HubReportLocalStatus(report.getReportId(), report.getHubAddress(), report.getDeedId(), report.getFromDate(), report.getToDate(), report.getSentDate(), report.getPeriodType(), report.getUsersCount(), report.getParticipantsCount(), report.getRecipientsCount(), report.getAchievementsCount(), report.getActionsCount(), report.getRewardTokenAddress(), report.getRewardTokenNetworkId(), report.getHubRewardAmount(), report.getHubTopRewardedAmount(), report.getTransactions(), id, canRefresh, canSend, status, error);
    }

    public static SortedSet<String> lowerCase(SortedSet<String> hashes) {
        if (CollectionUtils.isEmpty(hashes)) {
            return new TreeSet<String>();
        }
        return hashes.stream().map(StringUtils::lowerCase).collect(Collectors.toCollection(TreeSet::new));
    }
}

