/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.model.reward.WalletPluginReward;
import org.exoplatform.wallet.model.reward.WalletReward;
import org.exoplatform.wallet.reward.listener.RewardSucceedAnalyticsListener$AjcClosure1;

@Asynchronous
public class RewardSucceedAnalyticsListener
extends Listener<RewardReport, Object> {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @ExoTransactional
    public void onEvent(Event<RewardReport, Object> event) throws Exception {
        Event<RewardReport, Object> event2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), event2);
        Object[] objectArray = new Object[]{this, event2, joinPoint};
        RewardSucceedAnalyticsListener$AjcClosure1 rewardSucceedAnalyticsListener$AjcClosure1 = new RewardSucceedAnalyticsListener$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(rewardSucceedAnalyticsListener$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        RewardSucceedAnalyticsListener.ajc$preClinit();
    }

    static final /* synthetic */ void onEvent_aroundBody0(RewardSucceedAnalyticsListener ajc$this, Event event, JoinPoint joinPoint) {
        RewardReport rewardReport = (RewardReport)event.getSource();
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("wallet");
        statisticData.setSubModule("reward");
        statisticData.setOperation("sendPeriodRewards");
        statisticData.addParameter("rewardPeriodStartDate", (Object)Date.from(Instant.ofEpochSecond(rewardReport.getPeriod().getStartDateInSeconds())));
        statisticData.addParameter("rewardPeriodEndDate", (Object)Date.from(Instant.ofEpochSecond(rewardReport.getPeriod().getEndDateInSeconds())));
        statisticData.addParameter("rewardPeriodTimeZone", (Object)rewardReport.getPeriod().getTimeZone());
        statisticData.addParameter("rewardPeriodType", (Object)rewardReport.getPeriod().getRewardPeriodType().name().toLowerCase());
        statisticData.addParameter("rewardTransactionsCount", (Object)rewardReport.getSuccessTransactionCount());
        statisticData.addParameter("rewardTokensSent", (Object)rewardReport.getTokensSent());
        statisticData.addParameter("rewardTokensToSend", (Object)rewardReport.getTokensToSend());
        statisticData.addParameter("rewardRecipientWalletCount", (Object)rewardReport.getValidRewardCount());
        statisticData.addParameter("rewardParticipantWalletCount", (Object)rewardReport.getRewards().size());
        Map<String, Double> rewardPluginPoints = rewardReport.getValidRewards().stream().map(WalletReward::getRewards).flatMap(Collection::stream).collect(Collectors.toMap(WalletPluginReward::getPluginId, WalletPluginReward::getPoints, Double::sum));
        rewardPluginPoints.forEach((pId, points) -> statisticData.addParameter("rewardPlugin" + StringUtils.capitalize((String)pId) + "Points", points));
        Map<String, Double> rewardPluginAmounts = rewardReport.getValidRewards().stream().map(WalletReward::getRewards).flatMap(Collection::stream).collect(Collectors.toMap(WalletPluginReward::getPluginId, WalletPluginReward::getAmount, Double::sum));
        rewardPluginAmounts.forEach((pId, amount) -> statisticData.addParameter("rewardPlugin" + StringUtils.capitalize((String)pId) + "Amount", amount));
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RewardSucceedAnalyticsListener.java", RewardSucceedAnalyticsListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onEvent", "org.exoplatform.wallet.reward.listener.RewardSucceedAnalyticsListener", "org.exoplatform.services.listener.Event", "event", "java.lang.Exception", "void"), 49);
    }
}

