/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.NavigationCreateModel;
import io.meeds.layout.model.NavigationUpdateModel;
import io.meeds.layout.model.NodeLabel;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.NavigationLayoutService$AjcClosure1;
import io.meeds.layout.service.PageLayoutService;
import io.meeds.portal.web.handler.PortalTemplateRequestHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.DescriptionService;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NavigationLayoutService {
    private static final String NODE_DATA_WITH_NODE_ID_IS_NOT_FOUND = "Node with id %s doesn't exist";
    private static final Map<Long, String> QUEUE;
    @Autowired
    private NavigationService navigationService;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private PageLayoutService pageLayoutService;
    @Autowired
    private ResourceBundleManager resourceBundleManager;
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private DescriptionService descriptionService;
    @Autowired
    private LayoutAclService aclService;
    @Autowired
    private WebAppController webController;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public NodeData createNode(NavigationCreateModel nodeModel, String username) throws ObjectNotFoundException, IllegalAccessException, IllegalArgumentException {
        NodeData parentNodeData = this.navigationService.getNodeById(nodeModel.getParentNodeId());
        if (parentNodeData == null) {
            throw new ObjectNotFoundException(String.format("Parent node with id %s doesn't exist", nodeModel.getParentNodeId()));
        }
        if (!this.aclService.canEditNavigation(parentNodeData.getSiteKey(), username)) {
            throw new IllegalAccessException();
        }
        NodeState nodeState = this.buildNodeState(nodeModel.getNodeLabel(), nodeModel.getIcon(), this.getPageKey(nodeModel.getPageRef()), nodeModel.getTarget(), nodeModel.isVisible(), nodeModel.isDraft(), nodeModel.isScheduled(), nodeModel.getStartScheduleDate(), nodeModel.getEndScheduleDate(), nodeModel.isPasteMode());
        NodeData[] nodeDatas = this.navigationService.createNode(nodeModel.getParentNodeId(), nodeModel.getPreviousNodeId(), nodeModel.getNodeId(), nodeState);
        if (nodeDatas == null || nodeDatas.length < 2) {
            throw new IllegalStateException("Missing created node");
        }
        NodeData nodeData = nodeDatas[1];
        this.saveNodeLabels(nodeData.getId(), nodeModel.getLabels());
        return this.navigationService.getNodeById(Long.valueOf(Long.parseLong(nodeData.getId())));
    }

    public NodeData createDraftNode(Long nodeId, String username) throws ObjectNotFoundException, IllegalAccessException {
        NodeData node = this.getNode(nodeId, username);
        PageKey clonedPageKey = this.pageLayoutService.clonePage(node.getState().getPageRef(), username);
        String clonedNodeName = node.getName() + "_draft_" + username;
        NodeContext parentNode = this.navigationService.loadNode(node.getSiteKey());
        NodeContext<NodeContext<Object>> clonedNode = this.findNode((NodeContext<NodeContext<Object>>)parentNode, clonedNodeName);
        if (clonedNode == null) {
            return this.createNode(new NavigationCreateModel(Long.parseLong(node.getParentId()), null, clonedNodeName, clonedNodeName, false, false, true, null, null, clonedPageKey.format(), null, false, null, this.getNodeLabels(nodeId, username).getLabels()), username);
        }
        NodeState state = clonedNode.getState().builder().pageRef(clonedPageKey).build();
        this.navigationService.updateNode(Long.valueOf(Long.parseLong(clonedNode.getId())), state);
        return this.navigationService.getNodeById(Long.valueOf(Long.parseLong(clonedNode.getId())));
    }

    public void updateNode(long nodeId, NavigationUpdateModel nodeModel, String username) throws ObjectNotFoundException, IllegalAccessException, IllegalArgumentException {
        NodeData nodeData = this.navigationService.getNodeById(Long.valueOf(nodeId));
        if (nodeData == null) {
            throw new ObjectNotFoundException(String.format(NODE_DATA_WITH_NODE_ID_IS_NOT_FOUND, nodeId));
        }
        if (!this.aclService.canEditNavigation(nodeData.getSiteKey(), username)) {
            throw new IllegalAccessException();
        }
        NodeState nodeState = this.buildNodeState(nodeModel.getNodeLabel(), nodeModel.getIcon(), this.getPageKey(nodeModel.getPageRef()), nodeModel.getTarget(), nodeModel.isVisible(), false, nodeModel.isScheduled(), nodeModel.getStartScheduleDate(), nodeModel.getEndScheduleDate(), false);
        this.saveNodeLabels(nodeData.getId(), nodeModel.getLabels());
        this.navigationService.updateNode(Long.valueOf(nodeId), nodeState);
    }

    public void deleteNode(long nodeId, long delay, String username) throws ObjectNotFoundException, IllegalAccessException {
        NodeData nodeData = this.navigationService.getNodeById(Long.valueOf(nodeId));
        if (nodeData == null) {
            throw new ObjectNotFoundException(String.format(NODE_DATA_WITH_NODE_ID_IS_NOT_FOUND, nodeId));
        }
        if (!this.aclService.canEditNavigation(nodeData.getSiteKey(), username)) {
            throw new IllegalAccessException();
        }
        if (delay > 0L) {
            QUEUE.put(nodeId, username);
            CompletableFuture.delayedExecutor(delay, TimeUnit.SECONDS).execute(() -> {
                if (QUEUE.containsKey(nodeId)) {
                    try {
                        this.deleteNode(nodeId);
                    }
                    finally {
                        QUEUE.remove(nodeId);
                    }
                }
            });
        } else {
            this.deleteNode(nodeId);
        }
    }

    public void undoDeleteNode(long nodeId, String username) throws ObjectNotFoundException {
        if (!StringUtils.equals((CharSequence)username, (CharSequence)QUEUE.get(nodeId))) {
            throw new ObjectNotFoundException(String.format("Node with id %s doesn't exist in queue", nodeId));
        }
        QUEUE.remove(nodeId);
    }

    public void moveNode(long nodeId, Long destinationParentId, Long previousNodeId, String username) throws ObjectNotFoundException, IllegalAccessException {
        NodeData destinationNodeData;
        NodeData nodeData = this.navigationService.getNodeById(Long.valueOf(nodeId));
        if (nodeData == null) {
            throw new ObjectNotFoundException(String.format(NODE_DATA_WITH_NODE_ID_IS_NOT_FOUND, nodeId));
        }
        if (destinationParentId == null) {
            destinationParentId = Long.parseLong(nodeData.getParentId());
        }
        if ((destinationNodeData = this.navigationService.getNodeById(destinationParentId)) == null) {
            throw new ObjectNotFoundException(String.format(NODE_DATA_WITH_NODE_ID_IS_NOT_FOUND, destinationParentId));
        }
        if (!this.aclService.canEditNavigation(destinationNodeData.getSiteKey(), username)) {
            throw new IllegalAccessException();
        }
        this.navigationService.moveNode(Long.valueOf(nodeId), Long.valueOf(Long.parseLong(nodeData.getParentId())), destinationParentId, previousNodeId);
    }

    public NodeData getNode(long nodeId, String username) throws ObjectNotFoundException, IllegalAccessException {
        NodeData nodeData = this.navigationService.getNodeById(Long.valueOf(nodeId));
        if (nodeData == null) {
            throw new ObjectNotFoundException(String.format(NODE_DATA_WITH_NODE_ID_IS_NOT_FOUND, nodeId));
        }
        if (!this.aclService.canViewNavigation(nodeData.getSiteKey(), nodeData.getState().getPageRef(), username)) {
            throw new IllegalAccessException();
        }
        return nodeData;
    }

    public NodeLabel getNodeLabels(long nodeId, String username) throws ObjectNotFoundException, IllegalAccessException {
        NodeData nodeData = this.navigationService.getNodeById(Long.valueOf(nodeId));
        if (nodeData == null) {
            throw new ObjectNotFoundException(String.format(NODE_DATA_WITH_NODE_ID_IS_NOT_FOUND, nodeId));
        }
        SiteKey siteKey = nodeData.getSiteKey();
        if (!this.aclService.canViewNavigation(siteKey, nodeData.getState().getPageRef(), username)) {
            throw new IllegalAccessException();
        }
        Map nodeLabels = this.descriptionService.getDescriptions(String.valueOf(nodeId));
        if (MapUtils.isEmpty((Map)nodeLabels)) {
            HashMap<Locale, State> nodeLocalizedLabels = new HashMap<Locale, State>();
            this.localeConfigService.getLocalConfigs().forEach(localeConfig -> {
                Locale locale = localeConfig.getLocale();
                String label = nodeData.getState().getLabel();
                if (ExpressionUtil.isResourceBindingExpression((String)label)) {
                    SiteKey siteKey = nodeData.getSiteKey();
                    ResourceBundle nodeLabelResourceBundle = this.resourceBundleManager.getNavigationResourceBundle(this.getLocaleName(locale), siteKey.getTypeName(), siteKey.getName());
                    if (nodeLabelResourceBundle != null) {
                        label = ExpressionUtil.getExpressionValue((ResourceBundle)nodeLabelResourceBundle, (String)label);
                    }
                }
                nodeLocalizedLabels.put(locale, new State(label, null));
            });
            return this.toNodeLabel(nodeLocalizedLabels);
        }
        return this.toNodeLabel(nodeLabels);
    }

    public String getNodeUri(long nodeId, String username) throws IllegalAccessException, ObjectNotFoundException {
        NodeData node = this.getNode(nodeId, username);
        return this.getNodeUri(node);
    }

    public String getNodeUri(NodeData node) {
        SiteKey siteKey = node.getSiteKey();
        StringBuilder uriBuilder = new StringBuilder();
        this.buildUri(node, uriBuilder);
        Router router = this.webController.getRouter();
        HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
        if (siteKey.getType() == SiteType.GROUP_TEMPLATE) {
            PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
            params.put(WebAppController.HANDLER_PARAM, "portal-template");
            params.put(PortalTemplateRequestHandler.REQUEST_SITE_ID, portalConfig.getStorageId().split("_")[1]);
            params.put(PortalTemplateRequestHandler.REQUEST_PATH, uriBuilder.toString().replaceFirst("/", ""));
            params.put(PortalTemplateRequestHandler.LANG, Locale.ENGLISH.toLanguageTag());
        } else {
            params.put(WebAppController.HANDLER_PARAM, "portal");
            params.put(PortalRequestHandler.REQUEST_SITE_NAME, siteKey.getName());
            params.put(PortalRequestHandler.REQUEST_SITE_TYPE, siteKey.getTypeName());
            params.put(PortalRequestHandler.REQUEST_PATH, uriBuilder.toString().replaceFirst("/", ""));
            params.put(PortalRequestHandler.LANG, Locale.ENGLISH.toLanguageTag());
        }
        return router.render(params).replace("/en", "").replace("?lang=en", "").replace("&lang=en", "");
    }

    @ContainerTransactional
    public void deleteNode(long nodeId) {
        long l = nodeId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        NavigationLayoutService$AjcClosure1 navigationLayoutService$AjcClosure1 = new NavigationLayoutService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(navigationLayoutService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private NodeState buildNodeState(String label, String icon, PageKey pageKey, String target, boolean visible, boolean draft, boolean scheduled, Long startScheduleDate, Long endScheduleDate, boolean pasteMode) {
        if (visible && scheduled && startScheduleDate != null && endScheduleDate != null) {
            if (startScheduleDate > endScheduleDate) {
                throw new IllegalArgumentException("end schedule date must be after start schedule date");
            }
            if (System.currentTimeMillis() > startScheduleDate && !pasteMode) {
                throw new IllegalArgumentException("start schedule date must be after current date");
            }
            return new NodeState(label, icon, startScheduleDate.longValue(), endScheduleDate.longValue(), Visibility.TEMPORAL, pageKey, null, target, System.currentTimeMillis());
        }
        Visibility visibility = draft ? Visibility.DRAFT : (visible ? Visibility.DISPLAYED : Visibility.HIDDEN);
        return new NodeState(label, icon, -1L, -1L, visibility, pageKey, null, target, System.currentTimeMillis());
    }

    private void saveNodeLabels(String nodeId, Map<String, String> labels) {
        if (labels != null) {
            HashMap nodeLabels = new HashMap();
            labels.entrySet().forEach(label -> nodeLabels.put(Locale.forLanguageTag((String)label.getKey()), new State((String)label.getValue(), null)));
            this.descriptionService.setDescriptions(nodeId, nodeLabels);
        } else {
            this.descriptionService.setDescriptions(nodeId, Collections.emptyMap());
        }
    }

    private PageKey getPageKey(String pageRef) throws ObjectNotFoundException, IllegalArgumentException {
        if (StringUtils.isNotBlank((CharSequence)pageRef)) {
            PageContext pageContext = this.layoutService.getPageContext(PageKey.parse((String)pageRef));
            if (pageContext == null) {
                throw new ObjectNotFoundException(String.format("Page with key %s doesn't exist", pageRef));
            }
            return pageContext.getKey();
        }
        return null;
    }

    private NodeContext<NodeContext<Object>> findNode(NodeContext<NodeContext<Object>> node, String name) {
        if (node == null || StringUtils.equals((CharSequence)node.getName(), (CharSequence)name)) {
            return node;
        }
        if (node.getNodeCount() > 0) {
            int count = node.getNodeCount();
            while (--count >= 0) {
                NodeContext next = (NodeContext)node.get(count);
                NodeContext<NodeContext<Object>> result = this.findNode((NodeContext<NodeContext<Object>>)next, name);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private void buildUri(NodeData node, StringBuilder uriBuilder) {
        if (StringUtils.isNotBlank((CharSequence)node.getName()) && !StringUtils.equals((CharSequence)node.getName(), (CharSequence)"default")) {
            uriBuilder.insert(0, node.getName());
            if (!uriBuilder.isEmpty()) {
                uriBuilder.insert(0, "/");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)node.getParentId())) {
            NodeData parentNode = this.navigationService.getNodeById(Long.valueOf(Long.parseLong(node.getParentId())));
            this.buildUri(parentNode, uriBuilder);
        }
    }

    public NodeLabel toNodeLabel(Map<Locale, State> nodeLabels) {
        Locale defaultLocale = this.localeConfigService.getDefaultLocaleConfig() == null ? Locale.ENGLISH : this.localeConfigService.getDefaultLocaleConfig().getLocale();
        String defaultLanguage = defaultLocale.getLanguage();
        Map<String, String> supportedLanguages = CollectionUtils.isEmpty((Collection)this.localeConfigService.getLocalConfigs()) ? Collections.singletonMap(defaultLocale.toLanguageTag(), defaultLocale.getDisplayName()) : this.localeConfigService.getLocalConfigs().stream().filter(localeConfig -> !StringUtils.equals((CharSequence)localeConfig.getLocale().toLanguageTag(), (CharSequence)"ma")).map(LocaleConfig::getLocale).collect(Collectors.toMap(Locale::toLanguageTag, Locale::getDisplayName));
        HashMap<String, String> localized = new HashMap<String, String>();
        NodeLabel nodeLabel = new NodeLabel();
        if (MapUtils.isNotEmpty(nodeLabels)) {
            for (Map.Entry<Locale, State> entry : nodeLabels.entrySet()) {
                Locale locale = entry.getKey();
                State state = entry.getValue();
                localized.put(locale.toLanguageTag(), state.getName());
            }
            if (!nodeLabels.containsKey(defaultLocale) && !localized.isEmpty()) {
                localized.put(defaultLocale.toLanguageTag(), (String)localized.values().iterator().next());
            }
            nodeLabel.setLabels(localized);
        }
        nodeLabel.setDefaultLanguage(defaultLanguage);
        nodeLabel.setSupportedLanguages(supportedLanguages);
        return nodeLabel;
    }

    private String getLocaleName(Locale locale) {
        return locale.toLanguageTag().replace("-", "_");
    }

    static {
        NavigationLayoutService.ajc$preClinit();
        QUEUE = new ConcurrentHashMap<Long, String>();
    }

    static final /* synthetic */ void deleteNode_aroundBody0(NavigationLayoutService ajc$this, long nodeId, JoinPoint joinPoint) {
        ajc$this.navigationService.deleteNode(Long.valueOf(nodeId));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NavigationLayoutService.java", NavigationLayoutService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteNode", "io.meeds.layout.service.NavigationLayoutService", "long", "nodeId", "", "void"), 321);
    }
}

