/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.social.navigation.constant.SidebarItemType;
import io.meeds.social.navigation.model.SidebarItem;
import io.meeds.social.navigation.plugin.AbstractSpaceSidebarPlugin;
import io.meeds.social.navigation.plugin.SidebarPluginUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.core.space.SpaceFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=40)
public class SpaceListSidebarPlugin
extends AbstractSpaceSidebarPlugin {
    public static final String SPACES_NAMES = "names";
    public static final PageKey SPACES_PAGE_KEY = new PageKey(SiteKey.portal((String)"global"), "all-spaces");
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private UserPortalConfigService portalConfigService;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private UserACL userAcl;

    public SidebarItemType getType() {
        return SidebarItemType.SPACES;
    }

    public boolean itemExists(SidebarItem item, String username) {
        if (item == null || item.getProperties() == null) {
            return false;
        }
        return item.getProperties().containsKey(SPACES_NAMES);
    }

    public SidebarItem resolveProperties(SidebarItem item, String username, Locale locale) {
        item.setName(SidebarPluginUtils.getNameFromProperties(this.localeConfigService, item, SPACES_NAMES, locale));
        item.setItems(this.getSpaces(item, username));
        if (this.hasAccessToSpacesPage(username)) {
            item.setUrl(String.format("/portal/%s/spaces", this.portalConfigService.getMetaPortal()));
        } else {
            item.setUrl(null);
        }
        return item;
    }

    public List<SidebarItem> getDefaultItems() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(SPACES_NAMES, "{\"en\": \"sidebar.viewAllSpaces\"}");
        properties.put("limit", "0");
        properties.put("sortBy", "TITLE");
        return Collections.singletonList(new SidebarItem(null, null, null, null, "fa-layer-group", SidebarItemType.SPACES, null, properties));
    }

    @Override
    protected void buildSpaceFilter(String username, SidebarItem item, SpaceFilter spaceFilter) {
    }

    private boolean hasAccessToSpacesPage(String username) {
        Page spacesPage = this.layoutService.getPage(SPACES_PAGE_KEY);
        return spacesPage != null && this.userAcl.hasAccessPermission(spacesPage, this.userAcl.getUserIdentity(username));
    }
}

