/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.rest;

import io.meeds.github.gamification.services.GithubTriggerService;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"webhooks"})
@Tag(name="webhooks", description="Manage triggered github webhook events")
public class GithubWebHookRest {
    @Autowired
    private GithubTriggerService githubTriggerService;

    @PostMapping
    public Response githubEvent(@RequestHeader(value="x-github-event") String event, @RequestHeader(value="x-hub-signature") String signature, @RequestBody String payload) {
        try {
            this.githubTriggerService.handleTriggerAsync(event, signature, payload);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

