/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.site;

import java.io.Serializable;
import java.util.Formattable;
import java.util.Formatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gatein.api.internal.Parameters;
import org.gatein.api.page.PageId;
import org.gatein.api.security.Group;
import org.gatein.api.security.User;
import org.gatein.api.site.SiteType;

public class SiteId
implements Formattable,
Serializable {
    private final SiteType type;
    private final String name;
    private static final String NAME_REGEX = "[A-Za-z0-9-_/~]";
    private static final String TYPE_REGEX = "\\w{4,9}";
    private static final Pattern PATTERN1 = Pattern.compile("type=(\\w{4,9}), name=([A-Za-z0-9-_/~]*)");
    private static final Pattern PATTERN2 = Pattern.compile("(\\w{4,9})\\.([A-Za-z0-9-_/~]*)");

    public SiteId(String name) {
        this(SiteType.SITE, name);
    }

    public SiteId(Group group) {
        this(SiteType.SPACE, group.getId());
    }

    public SiteId(User user) {
        this(SiteType.DASHBOARD, user.getId());
    }

    public SiteId(SiteType type, String name) {
        this.type = Parameters.requireNonNull(type, "type");
        this.name = Parameters.requireNonNull(name, "name");
    }

    public SiteType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public PageId page(String pageName) {
        return new PageId(this, pageName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SiteId id = (SiteId)o;
        return this.name.equals(id.name) && this.type == id.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return String.format("Site.Id[%s]", this);
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if ((flags & 4) == 4) {
            formatter.format("%s.%s", this.type.getName(), this.name.replaceAll("/", "~"));
        } else {
            formatter.format("type=%s, name=%s", this.type.getName(), this.name);
        }
    }

    public static SiteId fromString(String idAsString) {
        Parameters.requireNonNull(idAsString, "idAsString");
        int len = idAsString.length();
        if (idAsString.startsWith("Site.Id[type=")) {
            int begin = idAsString.indexOf("type=") + 5;
            int end = idAsString.indexOf(",", begin);
            String type = idAsString.substring(begin, end);
            begin = idAsString.indexOf("name=") + 5;
            end = len - 1;
            String name = idAsString.substring(begin, end);
            return new SiteId(SiteType.forName(type), name);
        }
        Matcher matcher = PATTERN1.matcher(idAsString);
        boolean matches = matcher.matches();
        if (!matches) {
            matcher = PATTERN2.matcher(idAsString);
            matches = matcher.matches();
        }
        if (matches) {
            String type = matcher.group(1);
            String name = matcher.group(2);
            if (name.contains("~")) {
                name = name.replaceAll("~", "/");
            }
            return new SiteId(SiteType.forName(type), name);
        }
        throw new IllegalArgumentException("Unknown syntax for id string " + idAsString);
    }
}

