/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.service;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.portal.navigation.constant.SidebarMode;
import io.meeds.portal.navigation.model.NavigationConfiguration;
import io.meeds.portal.navigation.model.SidebarConfiguration;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.portal.navigation.model.TopbarConfiguration;
import io.meeds.portal.navigation.service.NavigationConfigurationService;
import io.meeds.social.common.ContainerStartableService;
import io.meeds.social.navigation.plugin.SidebarPlugin;
import io.meeds.social.navigation.service.NavigationConfigurationImportService$AjcClosure1;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NavigationConfigurationImportService
implements ContainerStartableService {
    private static final Log LOG;
    @Autowired
    private NavigationConfigurationService navigationConfigurationService;
    @Autowired
    private List<SidebarPlugin> menuPlugins;
    @Value(value="${navigation.configuration.forceUpdate:false}")
    private boolean forceUpdate;
    @Value(value="${navigation.configuration.displayCompanyName:true}")
    private boolean displayCompanyName;
    @Value(value="${navigation.configuration.displayMobileCompanyLogo:true}")
    private boolean displayMobileCompanyLogo;
    @Value(value="${navigation.configuration.displaySiteName:true}")
    private boolean displaySiteName;
    @Value(value="${navigation.configuration.allowUserCustomHome:true}")
    private boolean allowUserCustomHome;
    @Value(value="${navigation.configuration.defaultMode:ICON}")
    private SidebarMode defaultMode;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public int getOrder() {
        return 20;
    }

    @ContainerTransactional
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        NavigationConfigurationImportService$AjcClosure1 navigationConfigurationImportService$AjcClosure1 = new NavigationConfigurationImportService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(navigationConfigurationImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private NavigationConfiguration buildDefaultNavigationConfiguration() {
        TopbarConfiguration topbarConfiguration = new TopbarConfiguration(this.displayCompanyName, this.displaySiteName, this.displayMobileCompanyLogo, this.navigationConfigurationService.getDefaultTopbarApplications());
        SidebarConfiguration sidebarConfiguration = new SidebarConfiguration(this.allowUserCustomHome, this.defaultMode, null, Arrays.asList(SidebarMode.values()), this.getDefaultNavigations());
        return new NavigationConfiguration(topbarConfiguration, sidebarConfiguration);
    }

    private List<SidebarItem> getDefaultNavigations() {
        if (this.menuPlugins != null) {
            return this.menuPlugins.stream().map(SidebarPlugin::getDefaultItems).flatMap(items -> {
                if (CollectionUtils.isEmpty((Collection)items)) {
                    return Stream.empty();
                }
                return items.stream();
            }).toList();
        }
        return Collections.emptyList();
    }

    static {
        NavigationConfigurationImportService.ajc$preClinit();
        LOG = ExoLogger.getLogger(NavigationConfigurationImportService.class);
    }

    static final /* synthetic */ void start_aroundBody0(NavigationConfigurationImportService ajc$this, JoinPoint joinPoint) {
        if (ajc$this.forceUpdate || ajc$this.navigationConfigurationService.getConfiguration() == null) {
            long start = System.currentTimeMillis();
            LOG.info((Object)"Importing Default Navigation Configuration");
            ajc$this.navigationConfigurationService.updateConfiguration(ajc$this.buildDefaultNavigationConfiguration());
            LOG.info("Navigation Configuration imported successfully in {}ms", new Object[]{System.currentTimeMillis() - start});
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NavigationConfigurationImportService.java", NavigationConfigurationImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "io.meeds.social.navigation.service.NavigationConfigurationImportService", "", "", "", "void"), 85);
    }
}

