/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.listener;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.tenant.hub.listener.HubConnectedAutoSendReportListener$AjcClosure1;
import io.meeds.tenant.hub.service.HubReportService;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.reward.service.RewardReportService;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.Hub;
import jakarta.annotation.PostConstruct;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Asynchronous
public class HubConnectedAutoSendReportListener
extends Listener<Hub, Object> {
    private static final Log LOG;
    @Autowired
    private RewardReportService rewardReportService;
    @Autowired
    private HubReportService hubReportService;
    @Autowired
    private ListenerService listenerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @ContainerTransactional
    public void onEvent(Event<Hub, Object> event) {
        Event<Hub, Object> event2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), event2);
        Object[] objectArray = new Object[]{this, event2, joinPoint};
        HubConnectedAutoSendReportListener$AjcClosure1 hubConnectedAutoSendReportListener$AjcClosure1 = new HubConnectedAutoSendReportListener$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(hubConnectedAutoSendReportListener$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @PostConstruct
    public void init() {
        this.listenerService.addListener("deed.tenant.hub.connected", (ListenerBase)this);
    }

    static {
        HubConnectedAutoSendReportListener.ajc$preClinit();
        LOG = ExoLogger.getLogger(HubConnectedAutoSendReportListener.class);
    }

    static final /* synthetic */ void onEvent_aroundBody0(HubConnectedAutoSendReportListener ajc$this, Event event, JoinPoint joinPoint) {
        long periodId;
        RewardReport rewardReport;
        Hub hub = (Hub)event.getSource();
        if (hub.isConnected() && hub.getJoinDate() != null && Instant.now().minusSeconds(hub.getJoinDate().getEpochSecond()).getEpochSecond() < 3600L && (rewardReport = ajc$this.rewardReportService.getRewardReport(LocalDate.ofInstant(hub.getJoinDate(), ZoneOffset.UTC).minusWeeks(1L))) != null && rewardReport.isCompletelyProcessed() && ajc$this.hubReportService.getReportId(periodId = rewardReport.getPeriod().getId()) == 0L) {
            int retries = 3;
            while (retries-- > 0) {
                try {
                    ajc$this.hubReportService.sendReport(periodId);
                    retries = 0;
                }
                catch (WomException e) {
                    if (retries == 0) {
                        LOG.error((Object)"Error sending automatically the previous period Hub report", (Throwable)e);
                        continue;
                    }
                    LOG.warn((Object)"Error sending automatically the previous period Hub report. Automatically retry.");
                }
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HubConnectedAutoSendReportListener.java", HubConnectedAutoSendReportListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onEvent", "io.meeds.tenant.hub.listener.HubConnectedAutoSendReportListener", "org.exoplatform.services.listener.Event", "event", "", "void"), 67);
    }
}

