/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.web.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.controller.QualifiedName;

public class PortalDraftRequestHandler
extends PortalRequestHandler {
    public static final String HANDLER_NAME = "portal-draft";
    protected static final Log LOG = ExoLogger.getLogger(PortalDraftRequestHandler.class);
    public static final QualifiedName REQUEST_PATH = QualifiedName.create((String)"gtn", (String)"path");
    public static final QualifiedName REQUEST_SITE_ID = QualifiedName.create((String)"gtn", (String)"siteId");
    public static final QualifiedName LANG = QualifiedName.create((String)"gtn", (String)"lang");
    private LayoutService layoutService;
    private UserACL userAcl;

    @Override
    public String getHandlerName() {
        return HANDLER_NAME;
    }

    @Override
    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpServletRequest request = controllerContext.getRequest();
        HttpServletResponse response = controllerContext.getResponse();
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
        Locale requestLocale = this.getRequestLocale(controllerContext);
        String requestSiteId = controllerContext.getParameter(REQUEST_SITE_ID);
        String requestPath = controllerContext.getParameter(REQUEST_PATH);
        if (requestSiteId == null) {
            response.sendRedirect(request.getContextPath());
            return true;
        }
        PortalConfig portalConfig = this.getLayoutService().getPortalConfig(Long.parseLong(requestSiteId));
        if (portalConfig == null || !PortalConfig.DRAFT.equals(portalConfig.getType()) || !this.getUserAcl().hasEditPermission(portalConfig, ConversationState.getCurrent().getIdentity())) {
            response.sendRedirect(request.getContextPath());
            return true;
        }
        return this.processRequest(controllerContext, portalConfig.getType(), portalConfig.getName(), requestPath, requestLocale);
    }

    public LayoutService getLayoutService() {
        if (this.layoutService == null) {
            this.layoutService = (LayoutService)ExoContainerContext.getService(LayoutService.class);
        }
        return this.layoutService;
    }

    public UserACL getUserAcl() {
        if (this.userAcl == null) {
            this.userAcl = (UserACL)ExoContainerContext.getService(UserACL.class);
        }
        return this.userAcl;
    }
}

