/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.handler;

import io.meeds.notes.service.TermsAndConditionsService;
import jakarta.servlet.ServletConfig;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;

public class TermsAndConditionsHandler
extends WebRequestHandler {
    public static final String PAGE_URI = "terms-and-conditions";
    private UserPortalConfigService userPortalConfigService;
    private TermsAndConditionsService termsAndConditionsService;

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        super.onInit(controller, sConfig);
        PortalContainer container = PortalContainer.getInstance();
        this.userPortalConfigService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        this.termsAndConditionsService = (TermsAndConditionsService)container.getComponentInstanceOfType(TermsAndConditionsService.class);
    }

    public String getHandlerName() {
        return PAGE_URI;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        String username = controllerContext.getRequest().getRemoteUser();
        Object requestURI = controllerContext.getRequest().getRequestURI();
        if (username == null || this.termsAndConditionsService == null || this.userPortalConfigService == null) {
            return false;
        }
        String language = controllerContext.getRequest().getLocale().getLanguage();
        boolean hasAcceptedTerms = this.termsAndConditionsService.isTermsAcceptedForUser(username, language);
        if (hasAcceptedTerms && ((String)requestURI).contains(PAGE_URI) && controllerContext.getRequest().getQueryString() == null) {
            controllerContext.getResponse().sendRedirect(String.format("%s/%s/settings#terms-and-conditions", controllerContext.getRequest().getContextPath(), this.userPortalConfigService.getMetaPortal()));
            return true;
        }
        if (!hasAcceptedTerms && !this.isTermsPage((String)requestURI)) {
            String initURI;
            String queryString = controllerContext.getRequest().getQueryString();
            if (queryString != null) {
                requestURI = (String)requestURI + "?" + queryString;
            }
            if ((initURI = "/" + PortalContainer.getCurrentPortalContainerName() + "/").equals(requestURI)) {
                controllerContext.getResponse().sendRedirect(String.format("%s/%s/settings#terms-and-conditions?redirect=%s", controllerContext.getRequest().getContextPath(), this.userPortalConfigService.getMetaPortal(), this.userPortalConfigService.getDefaultPath(username)));
            } else {
                String encodedPreviousPage = URLEncoder.encode((String)requestURI, StandardCharsets.UTF_8);
                controllerContext.getResponse().sendRedirect(String.format("%s/%s/terms-and-conditions?redirect=%s", controllerContext.getRequest().getContextPath(), this.userPortalConfigService.getMetaPortal(), encodedPreviousPage));
            }
            return true;
        }
        return false;
    }

    private boolean isTermsPage(String requestURI) {
        return requestURI.contains(PAGE_URI);
    }
}

