/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class TextEmbeddingResult
implements JsonpSerializable {
    private final List<Float> embedding;
    public static final JsonpDeserializer<TextEmbeddingResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextEmbeddingResult::setupTextEmbeddingResultDeserializer);

    private TextEmbeddingResult(Builder builder) {
        this.embedding = ApiTypeHelper.unmodifiableRequired(builder.embedding, (Object)this, "embedding");
    }

    public static TextEmbeddingResult of(Function<Builder, ObjectBuilder<TextEmbeddingResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Float> embedding() {
        return this.embedding;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.embedding)) {
            generator.writeKey("embedding");
            generator.writeStartArray();
            for (Float item0 : this.embedding) {
                generator.write((double)item0.floatValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTextEmbeddingResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::embedding, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.floatDeserializer()), "embedding");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TextEmbeddingResult> {
        private List<Float> embedding;

        public final Builder embedding(List<Float> list) {
            this.embedding = Builder._listAddAll(this.embedding, list);
            return this;
        }

        public final Builder embedding(Float value, Float ... values) {
            this.embedding = Builder._listAdd(this.embedding, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextEmbeddingResult build() {
            this._checkSingleUse();
            return new TextEmbeddingResult(this);
        }
    }
}

