/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortalLifecycle;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.login.LogoutControl;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIPortalLifecycle.class, template="system:/groovy/portal/webui/page/UIPortal.gtmpl", events={@EventConfig(listeners={LogoutActionListener.class}, csrfCheck=false)})
public class UIPortal
extends UIContainer {
    private SiteKey siteKey;
    private String locale;
    private String label;
    private String editPermission;
    private String skin;
    private Properties properties;
    private Map<String, UIPage> allUiPages = new HashMap<String, UIPage>();
    private Map<String, String[]> publicParameters = new HashMap<String, String[]>();
    private boolean useDynamicLayout;

    public UIPortal() {
        ListenerService listenerService = (ListenerService)ExoContainerContext.getService(ListenerService.class);
        listenerService.addListener(LayoutService.PAGE_UPDATED, (ListenerBase)new RefreshUIPageListener());
    }

    @Override
    public boolean hasAccessPermission() {
        return ((UserACL)ExoContainerContext.getService(UserACL.class)).hasAccessPermission(PortalRequestContext.getCurrentInstance().getPortalConfig(), ConversationState.getCurrent().getIdentity());
    }

    public SiteType getSiteType() {
        return this.siteKey.getType();
    }

    public UserNode getNavPath() {
        PortalRequestContext prc = PortalRequestContext.getCurrentInstance();
        return prc.getNavigationNode();
    }

    public UIPage getUIPage(String pageReference) {
        if (this.isDraftPage() || this.isNoCache()) {
            return null;
        }
        return this.allUiPages.get(pageReference);
    }

    public UIComponent getMaximizedUIComponent() {
        PortalRequestContext portalRequestContext = PortalRequestContext.getCurrentInstance();
        return portalRequestContext.isShowMaxWindow() ? portalRequestContext.getUiPage() : null;
    }

    public void setUIPage(String pageReference, UIPage uiPage) {
        if (!this.isDraftPage()) {
            this.allUiPages.put(pageReference, uiPage);
        }
    }

    public boolean isDraftPage() {
        return PortalRequestContext.getCurrentInstance().isDraftPage();
    }

    public boolean isNoCache() {
        return PortalRequestContext.getCurrentInstance().isNoCache();
    }

    public void clearUIPage(String pageReference) {
        if (this.allUiPages != null) {
            this.allUiPages.remove(pageReference);
        }
    }

    public UserNavigation getUserNavigation() {
        PortalRequestContext prc = Util.getPortalRequestContext();
        return prc.getUserPortalConfig().getUserPortal().getNavigation(this.siteKey);
    }

    public UserNode getSelectedUserNode() {
        return PortalRequestContext.getCurrentInstance().getNavigationNode();
    }

    public String getProperty(String name, String defaultValue) {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getProperty(name), defaultValue});
    }

    public String getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get((Object)name);
    }

    public void setHeaderAndFooterRendered(boolean headerAndFooterRendered) {
        List<UIComponent> list = this.getChildren();
        for (UIComponent child : list) {
            if (child instanceof UIPageBody || child.isRendered() == headerAndFooterRendered) continue;
            child.setRendered(headerAndFooterRendered);
        }
    }

    @Generated
    public SiteKey getSiteKey() {
        return this.siteKey;
    }

    @Generated
    public void setSiteKey(SiteKey siteKey) {
        this.siteKey = siteKey;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public String getEditPermission() {
        return this.editPermission;
    }

    @Generated
    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    @Generated
    public String getSkin() {
        return this.skin;
    }

    @Generated
    public void setSkin(String skin) {
        this.skin = skin;
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Generated
    public Map<String, UIPage> getAllUiPages() {
        return this.allUiPages;
    }

    @Generated
    public Map<String, String[]> getPublicParameters() {
        return this.publicParameters;
    }

    @Generated
    public void setPublicParameters(Map<String, String[]> publicParameters) {
        this.publicParameters = publicParameters;
    }

    @Generated
    public boolean isUseDynamicLayout() {
        return this.useDynamicLayout;
    }

    @Generated
    public void setUseDynamicLayout(boolean useDynamicLayout) {
        this.useDynamicLayout = useDynamicLayout;
    }

    @Asynchronous
    public class RefreshUIPageListener
    extends Listener<LayoutService, Page> {
        public void onEvent(Event<LayoutService, Page> event) throws Exception {
            Page page = (Page)event.getData();
            if (page == null) {
                return;
            }
            PageKey pageKey = page.getPageKey();
            if (pageKey == null) {
                return;
            }
            String pageReference = pageKey.format();
            if (UIPortal.this.allUiPages != null && UIPortal.this.allUiPages.containsKey(pageReference)) {
                UIPortal.this.allUiPages.remove(pageReference);
            }
        }
    }

    public static class LogoutActionListener
    extends EventListener<UIComponent> {
        @Override
        public void execute(org.exoplatform.webui.event.Event<UIComponent> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            HttpServletRequest req = prContext.getRequest();
            String token = this.getTokenCookie(req);
            if (token != null) {
                AbstractTokenService tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken((Object)token);
            }
            LogoutControl.wantLogout();
            Cookie cookie = new Cookie("rememberme", "");
            cookie.setPath(req.getContextPath());
            cookie.setMaxAge(0);
            prContext.getResponse().addCookie(cookie);
            prContext.sendRedirect("/");
        }

        private String getTokenCookie(HttpServletRequest req) {
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!"rememberme".equals(cookie.getName())) continue;
                    return cookie.getValue();
                }
            }
            return null;
        }
    }
}

