/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.GeoHashPrecision;
import co.elastic.clients.elasticsearch.core.search.Context;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompletionContext
implements JsonpSerializable {
    @Nullable
    private final Double boost;
    private final Context context;
    private final List<GeoHashPrecision> neighbours;
    @Nullable
    private final GeoHashPrecision precision;
    @Nullable
    private final Boolean prefix;
    public static final JsonpDeserializer<CompletionContext> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompletionContext::setupCompletionContextDeserializer);

    private CompletionContext(Builder builder) {
        this.boost = builder.boost;
        this.context = ApiTypeHelper.requireNonNull(builder.context, this, "context");
        this.neighbours = ApiTypeHelper.unmodifiable(builder.neighbours);
        this.precision = builder.precision;
        this.prefix = builder.prefix;
    }

    public static CompletionContext of(Function<Builder, ObjectBuilder<CompletionContext>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    public final Context context() {
        return this.context;
    }

    public final List<GeoHashPrecision> neighbours() {
        return this.neighbours;
    }

    @Nullable
    public final GeoHashPrecision precision() {
        return this.precision;
    }

    @Nullable
    public final Boolean prefix() {
        return this.prefix;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        generator.writeKey("context");
        this.context.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.neighbours)) {
            generator.writeKey("neighbours");
            generator.writeStartArray();
            for (GeoHashPrecision item0 : this.neighbours) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            this.precision.serialize(generator, mapper);
        }
        if (this.prefix != null) {
            generator.writeKey("prefix");
            generator.write(this.prefix.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCompletionContextDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::context, Context._DESERIALIZER, "context");
        op.add(Builder::neighbours, JsonpDeserializer.arrayDeserializer(GeoHashPrecision._DESERIALIZER), "neighbours");
        op.add(Builder::precision, GeoHashPrecision._DESERIALIZER, "precision");
        op.add(Builder::prefix, JsonpDeserializer.booleanDeserializer(), "prefix");
        op.shortcutProperty("context");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CompletionContext> {
        @Nullable
        private Double boost;
        private Context context;
        @Nullable
        private List<GeoHashPrecision> neighbours;
        @Nullable
        private GeoHashPrecision precision;
        @Nullable
        private Boolean prefix;

        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public final Builder context(Context value) {
            this.context = value;
            return this;
        }

        public final Builder context(Function<Context.Builder, ObjectBuilder<Context>> fn) {
            return this.context(fn.apply(new Context.Builder()).build());
        }

        public final Builder neighbours(List<GeoHashPrecision> list) {
            this.neighbours = Builder._listAddAll(this.neighbours, list);
            return this;
        }

        public final Builder neighbours(GeoHashPrecision value, GeoHashPrecision ... values) {
            this.neighbours = Builder._listAdd(this.neighbours, value, values);
            return this;
        }

        public final Builder neighbours(Function<GeoHashPrecision.Builder, ObjectBuilder<GeoHashPrecision>> fn) {
            return this.neighbours(fn.apply(new GeoHashPrecision.Builder()).build(), new GeoHashPrecision[0]);
        }

        public final Builder precision(@Nullable GeoHashPrecision value) {
            this.precision = value;
            return this;
        }

        public final Builder precision(Function<GeoHashPrecision.Builder, ObjectBuilder<GeoHashPrecision>> fn) {
            return this.precision(fn.apply(new GeoHashPrecision.Builder()).build());
        }

        public final Builder prefix(@Nullable Boolean value) {
            this.prefix = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompletionContext build() {
            this._checkSingleUse();
            return new CompletionContext(this);
        }
    }
}

