/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.TransportHistogram;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Transport
implements JsonpSerializable {
    private final List<TransportHistogram> inboundHandlingTimeHistogram;
    private final List<TransportHistogram> outboundHandlingTimeHistogram;
    @Nullable
    private final Long rxCount;
    @Nullable
    private final String rxSize;
    @Nullable
    private final Long rxSizeInBytes;
    @Nullable
    private final Integer serverOpen;
    @Nullable
    private final Long txCount;
    @Nullable
    private final String txSize;
    @Nullable
    private final Long txSizeInBytes;
    @Nullable
    private final Long totalOutboundConnections;
    public static final JsonpDeserializer<Transport> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Transport::setupTransportDeserializer);

    private Transport(Builder builder) {
        this.inboundHandlingTimeHistogram = ApiTypeHelper.unmodifiable(builder.inboundHandlingTimeHistogram);
        this.outboundHandlingTimeHistogram = ApiTypeHelper.unmodifiable(builder.outboundHandlingTimeHistogram);
        this.rxCount = builder.rxCount;
        this.rxSize = builder.rxSize;
        this.rxSizeInBytes = builder.rxSizeInBytes;
        this.serverOpen = builder.serverOpen;
        this.txCount = builder.txCount;
        this.txSize = builder.txSize;
        this.txSizeInBytes = builder.txSizeInBytes;
        this.totalOutboundConnections = builder.totalOutboundConnections;
    }

    public static Transport of(Function<Builder, ObjectBuilder<Transport>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<TransportHistogram> inboundHandlingTimeHistogram() {
        return this.inboundHandlingTimeHistogram;
    }

    public final List<TransportHistogram> outboundHandlingTimeHistogram() {
        return this.outboundHandlingTimeHistogram;
    }

    @Nullable
    public final Long rxCount() {
        return this.rxCount;
    }

    @Nullable
    public final String rxSize() {
        return this.rxSize;
    }

    @Nullable
    public final Long rxSizeInBytes() {
        return this.rxSizeInBytes;
    }

    @Nullable
    public final Integer serverOpen() {
        return this.serverOpen;
    }

    @Nullable
    public final Long txCount() {
        return this.txCount;
    }

    @Nullable
    public final String txSize() {
        return this.txSize;
    }

    @Nullable
    public final Long txSizeInBytes() {
        return this.txSizeInBytes;
    }

    @Nullable
    public final Long totalOutboundConnections() {
        return this.totalOutboundConnections;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.inboundHandlingTimeHistogram)) {
            generator.writeKey("inbound_handling_time_histogram");
            generator.writeStartArray();
            for (TransportHistogram item0 : this.inboundHandlingTimeHistogram) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.outboundHandlingTimeHistogram)) {
            generator.writeKey("outbound_handling_time_histogram");
            generator.writeStartArray();
            for (TransportHistogram item0 : this.outboundHandlingTimeHistogram) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.rxCount != null) {
            generator.writeKey("rx_count");
            generator.write(this.rxCount.longValue());
        }
        if (this.rxSize != null) {
            generator.writeKey("rx_size");
            generator.write(this.rxSize);
        }
        if (this.rxSizeInBytes != null) {
            generator.writeKey("rx_size_in_bytes");
            generator.write(this.rxSizeInBytes.longValue());
        }
        if (this.serverOpen != null) {
            generator.writeKey("server_open");
            generator.write(this.serverOpen.intValue());
        }
        if (this.txCount != null) {
            generator.writeKey("tx_count");
            generator.write(this.txCount.longValue());
        }
        if (this.txSize != null) {
            generator.writeKey("tx_size");
            generator.write(this.txSize);
        }
        if (this.txSizeInBytes != null) {
            generator.writeKey("tx_size_in_bytes");
            generator.write(this.txSizeInBytes.longValue());
        }
        if (this.totalOutboundConnections != null) {
            generator.writeKey("total_outbound_connections");
            generator.write(this.totalOutboundConnections.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTransportDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::inboundHandlingTimeHistogram, JsonpDeserializer.arrayDeserializer(TransportHistogram._DESERIALIZER), "inbound_handling_time_histogram");
        op.add(Builder::outboundHandlingTimeHistogram, JsonpDeserializer.arrayDeserializer(TransportHistogram._DESERIALIZER), "outbound_handling_time_histogram");
        op.add(Builder::rxCount, JsonpDeserializer.longDeserializer(), "rx_count");
        op.add(Builder::rxSize, JsonpDeserializer.stringDeserializer(), "rx_size");
        op.add(Builder::rxSizeInBytes, JsonpDeserializer.longDeserializer(), "rx_size_in_bytes");
        op.add(Builder::serverOpen, JsonpDeserializer.integerDeserializer(), "server_open");
        op.add(Builder::txCount, JsonpDeserializer.longDeserializer(), "tx_count");
        op.add(Builder::txSize, JsonpDeserializer.stringDeserializer(), "tx_size");
        op.add(Builder::txSizeInBytes, JsonpDeserializer.longDeserializer(), "tx_size_in_bytes");
        op.add(Builder::totalOutboundConnections, JsonpDeserializer.longDeserializer(), "total_outbound_connections");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Transport> {
        @Nullable
        private List<TransportHistogram> inboundHandlingTimeHistogram;
        @Nullable
        private List<TransportHistogram> outboundHandlingTimeHistogram;
        @Nullable
        private Long rxCount;
        @Nullable
        private String rxSize;
        @Nullable
        private Long rxSizeInBytes;
        @Nullable
        private Integer serverOpen;
        @Nullable
        private Long txCount;
        @Nullable
        private String txSize;
        @Nullable
        private Long txSizeInBytes;
        @Nullable
        private Long totalOutboundConnections;

        public final Builder inboundHandlingTimeHistogram(List<TransportHistogram> list) {
            this.inboundHandlingTimeHistogram = Builder._listAddAll(this.inboundHandlingTimeHistogram, list);
            return this;
        }

        public final Builder inboundHandlingTimeHistogram(TransportHistogram value, TransportHistogram ... values) {
            this.inboundHandlingTimeHistogram = Builder._listAdd(this.inboundHandlingTimeHistogram, value, values);
            return this;
        }

        public final Builder inboundHandlingTimeHistogram(Function<TransportHistogram.Builder, ObjectBuilder<TransportHistogram>> fn) {
            return this.inboundHandlingTimeHistogram(fn.apply(new TransportHistogram.Builder()).build(), new TransportHistogram[0]);
        }

        public final Builder outboundHandlingTimeHistogram(List<TransportHistogram> list) {
            this.outboundHandlingTimeHistogram = Builder._listAddAll(this.outboundHandlingTimeHistogram, list);
            return this;
        }

        public final Builder outboundHandlingTimeHistogram(TransportHistogram value, TransportHistogram ... values) {
            this.outboundHandlingTimeHistogram = Builder._listAdd(this.outboundHandlingTimeHistogram, value, values);
            return this;
        }

        public final Builder outboundHandlingTimeHistogram(Function<TransportHistogram.Builder, ObjectBuilder<TransportHistogram>> fn) {
            return this.outboundHandlingTimeHistogram(fn.apply(new TransportHistogram.Builder()).build(), new TransportHistogram[0]);
        }

        public final Builder rxCount(@Nullable Long value) {
            this.rxCount = value;
            return this;
        }

        public final Builder rxSize(@Nullable String value) {
            this.rxSize = value;
            return this;
        }

        public final Builder rxSizeInBytes(@Nullable Long value) {
            this.rxSizeInBytes = value;
            return this;
        }

        public final Builder serverOpen(@Nullable Integer value) {
            this.serverOpen = value;
            return this;
        }

        public final Builder txCount(@Nullable Long value) {
            this.txCount = value;
            return this;
        }

        public final Builder txSize(@Nullable String value) {
            this.txSize = value;
            return this;
        }

        public final Builder txSizeInBytes(@Nullable Long value) {
            this.txSizeInBytes = value;
            return this;
        }

        public final Builder totalOutboundConnections(@Nullable Long value) {
            this.totalOutboundConnections = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Transport build() {
            this._checkSingleUse();
            return new Transport(this);
        }
    }
}

