/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.perkstore.dao.PerkStoreOrderDAO;
import org.exoplatform.perkstore.dao.PerkStoreProductDAO;
import org.exoplatform.perkstore.entity.ProductEntity;
import org.exoplatform.perkstore.entity.ProductOrderEntity;
import org.exoplatform.perkstore.exception.PerkStoreException;
import org.exoplatform.perkstore.model.FileDetail;
import org.exoplatform.perkstore.model.OrderFilter;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.model.ProductOrder;
import org.exoplatform.perkstore.model.constant.PerkStoreError;
import org.exoplatform.perkstore.model.constant.ProductOrderStatus;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.perkstore.storage.PerkStoreStorage$AjcClosure1;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class PerkStoreStorage {
    private static final String FILE_API_NAME_SPACE = "PerkStore";
    private static final int DEFAULT_QUERY_LIMIT = 100;
    private static final Log LOG;
    private FileService fileService;
    private UploadService uploadService;
    private PerkStoreProductDAO productDAO;
    private PerkStoreOrderDAO orderDAO;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public PerkStoreStorage(PerkStoreProductDAO perkStoreProductDAO, PerkStoreOrderDAO perkStoreOrderDAO) {
        this.productDAO = perkStoreProductDAO;
        this.orderDAO = perkStoreOrderDAO;
    }

    public Product getProductById(long productId) {
        ProductEntity entity = (ProductEntity)this.productDAO.find(Long.valueOf(productId));
        if (entity == null || entity.isDeleted()) {
            return null;
        }
        return this.parseProductFromEntity(entity);
    }

    public Product saveProduct(Product product, String username) throws PerkStoreException {
        if (product == null) {
            throw new IllegalArgumentException("product argument is null");
        }
        this.saveProductImages(product.getId() == 0L ? null : this.getProductById(product.getId()), product, username);
        ProductEntity entity = Utils.toEntity(product);
        if (product.getId() == 0L) {
            Identity identity = Utils.getIdentityByTypeAndId("user", username);
            if (identity == null) {
                throw new PerkStoreException(PerkStoreError.PRODUCT_CREATION_DENIED, new Serializable[]{username});
            }
            entity.setCreator(Long.parseLong(identity.getId()));
            entity.setCreatedDate(System.currentTimeMillis());
            entity.setId(null);
            entity = (ProductEntity)this.productDAO.create(entity);
        } else {
            Identity identity = Utils.getIdentityByTypeAndId("user", username);
            if (identity == null) {
                throw new PerkStoreException(PerkStoreError.PRODUCT_MODIFICATION_DENIED, new Serializable[]{username, product.getTitle()});
            }
            entity.setLastModifier(Long.parseLong(identity.getId()));
            entity.setLastModifiedDate(System.currentTimeMillis());
            entity = (ProductEntity)this.productDAO.update(entity);
        }
        return this.parseProductFromEntity(entity);
    }

    public List<Product> getAllProducts() {
        List<ProductEntity> productEntities = this.productDAO.getAllProducts();
        return productEntities.stream().map(productEntity -> this.getProductById(productEntity.getId())).collect(Collectors.toList());
    }

    public double countOrderedQuantity(long productId) {
        double countOrderedQuantities = this.orderDAO.countOrderedQuantityByProductId(productId);
        if (countOrderedQuantities > 0.0) {
            return countOrderedQuantities - this.orderDAO.countRefundedQuantityByProductId(productId) - this.orderDAO.countOrderedQuantityByProductIdAndStatus(productId, ProductOrderStatus.CANCELED) - this.orderDAO.countOrderedQuantityByProductIdAndStatus(productId, ProductOrderStatus.ERROR);
        }
        return 0.0;
    }

    public long countRemainingOrdersToProcess(long id) {
        return this.orderDAO.countRemainingOrdersToProcessByProductId(id);
    }

    public long countRemainingOrdersToProcess(long identityId, long productId) {
        if (identityId == 0L || productId == 0L) {
            return 0L;
        }
        return this.orderDAO.countRemainingOrdersByIdentityIdAndProductId(identityId, productId);
    }

    public double countUserTotalPurchasedQuantity(long productId, long identityId) {
        double userTotalPurchasedQuantity = this.orderDAO.countUserTotalPurchasedQuantity(productId, identityId);
        if (userTotalPurchasedQuantity > 0.0) {
            return userTotalPurchasedQuantity - this.orderDAO.countUserTotalRefundedQuantity(productId, identityId) - this.orderDAO.countUserTotalOrderedQuantityByStatus(productId, identityId, ProductOrderStatus.CANCELED);
        }
        return 0.0;
    }

    public double countUserPurchasedQuantityInPeriod(long productId, long identityId, long startDate, long endDate) {
        double userTotalPurchasedQuantity = this.orderDAO.countUserPurchasedQuantityInPeriod(productId, identityId, startDate, endDate);
        if (userTotalPurchasedQuantity > 0.0) {
            return userTotalPurchasedQuantity - this.orderDAO.countUserRefundedQuantityInPeriod(productId, identityId, startDate, endDate) - this.orderDAO.countUserOrderedQuantityByStatusInPeriod(productId, identityId, startDate, endDate, ProductOrderStatus.CANCELED);
        }
        return 0.0;
    }

    public List<ProductOrder> getOrders(String username, OrderFilter filter, boolean isPerkStoreManager, boolean isProductOwner) {
        if (filter.getLimit() == 0) {
            filter.setLimit(100);
        }
        List<ProductOrderEntity> entities = this.orderDAO.getOrders(username, filter, isPerkStoreManager, isProductOwner);
        return entities.stream().map(orderEntity -> this.getOrderById(orderEntity.getId())).collect(Collectors.toList());
    }

    public Long countOrders(String username, OrderFilter filter, boolean isPerkStoreManager, boolean isProductOwner) {
        return this.orderDAO.countOrders(username, filter, isPerkStoreManager, isProductOwner);
    }

    public ProductOrder getOrderById(long orderId) {
        ProductOrderEntity orderEntity = (ProductOrderEntity)this.orderDAO.find(Long.valueOf(orderId));
        return orderEntity == null ? null : Utils.fromEntity(orderEntity);
    }

    public ProductOrder saveOrder(ProductOrder order) throws PerkStoreException {
        if (order == null) {
            throw new IllegalArgumentException("order argument is null");
        }
        long productId = order.getProductId();
        ProductEntity productEntity = null;
        if (productId != 0L) {
            productEntity = (ProductEntity)this.productDAO.find(Long.valueOf(productId));
        }
        if (productEntity == null) {
            throw new PerkStoreException(PerkStoreError.PRODUCT_NOT_EXISTS, Long.valueOf(productId));
        }
        ProductOrderEntity entity = Utils.toEntity(productEntity, order);
        if (order.getId() == 0L) {
            entity.setCreatedDate(System.currentTimeMillis());
            entity.setId(null);
            entity = (ProductOrderEntity)this.orderDAO.create(entity);
        } else {
            entity = (ProductOrderEntity)this.orderDAO.update(entity);
        }
        return Utils.fromEntity(entity);
    }

    public ProductOrder findOrderByTransactionHash(String hash) {
        ProductOrderEntity orderEntity = this.orderDAO.findOrderByTransactionHash(hash = Utils.formatTransactionHash(hash));
        return orderEntity == null ? null : Utils.fromEntity(orderEntity);
    }

    public ProductOrder findOrderByRefundTransactionHash(String hash) {
        ProductOrderEntity orderEntity = this.orderDAO.findOrderByRefundTransactionHash(hash = Utils.formatTransactionHash(hash));
        return orderEntity == null ? null : Utils.fromEntity(orderEntity);
    }

    public FileDetail getFileDetail(long productId, Long imageAttachementId, boolean parseBinaryData) {
        FileItem fileItem;
        try {
            fileItem = this.getFileService().getFile(imageAttachementId.longValue());
        }
        catch (FileStorageException e) {
            LOG.warn("Error parsing image with id: {} on product with id {}", new Object[]{imageAttachementId, productId, e});
            return null;
        }
        if (fileItem == null || fileItem.getFileInfo() == null) {
            return null;
        }
        FileInfo fileInfo = fileItem.getFileInfo();
        FileDetail fileDetail = new FileDetail();
        fileDetail.setId(fileInfo.getId());
        fileDetail.setName(fileInfo.getName());
        fileDetail.setSize(fileInfo.getSize());
        fileDetail.setLastUpdated(fileInfo.getUpdatedDate() == null ? 0L : fileInfo.getUpdatedDate().getTime());
        if (parseBinaryData) {
            fileDetail.setData(fileItem.getAsByte());
        }
        fileDetail.setSrc(this.getImageSrc(productId, imageAttachementId));
        return fileDetail;
    }

    @ExoTransactional
    public ProductOrder replaceTransactions(String oldHash, String newHash) {
        String string = oldHash;
        String string2 = newHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        PerkStoreStorage$AjcClosure1 perkStoreStorage$AjcClosure1 = new PerkStoreStorage$AjcClosure1(objectArray);
        return (ProductOrder)ExoTransactionalAspect.aspectOf().around(perkStoreStorage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private Product parseProductFromEntity(ProductEntity entity) {
        Product product = Utils.fromEntity(entity);
        if (product != null && entity != null && entity.getImages() != null && !entity.getImages().isEmpty()) {
            long productId = product.getId();
            HashSet<FileDetail> imageFiles = new HashSet<FileDetail>();
            Set<Long> imageAttachementIds = entity.getImages();
            for (Long imageAttachementId : imageAttachementIds) {
                try {
                    FileDetail fileDetail = this.getFileDetail(productId, imageAttachementId, false);
                    if (fileDetail == null) continue;
                    imageFiles.add(fileDetail);
                }
                catch (Exception e) {
                    LOG.warn("Error parsing image with id: {}", new Object[]{imageAttachementId, e});
                }
            }
            product.setImageFiles(imageFiles);
        }
        return product;
    }

    private String getImageSrc(long productId, long imageAttachementId) {
        return "/" + PortalContainer.getInstance().getName() + "/" + CommonsUtils.getRestContextName() + "/perkstore/api/product/" + productId + "/image/" + imageAttachementId;
    }

    private void saveProductImages(Product storedProduct, Product product, String username) {
        long fileItemId;
        Set<FileDetail> storedImageFiles = storedProduct == null ? null : storedProduct.getImageFiles();
        Set<FileDetail> imageFilesToStore = product.getImageFiles();
        if (storedImageFiles != null && !storedImageFiles.isEmpty()) {
            HashSet<FileDetail> imagesToDelete = new HashSet<FileDetail>(storedImageFiles);
            if (imageFilesToStore != null && !imageFilesToStore.isEmpty()) {
                imagesToDelete.removeAll(imageFilesToStore);
            }
            for (FileDetail fileDetail : imagesToDelete) {
                fileItemId = fileDetail.getId();
                if (fileItemId <= 0L) continue;
                try {
                    FileItem fileItem = this.getFileService().getFile(fileItemId);
                    if (fileItem == null) continue;
                    this.getFileService().deleteFile(fileItemId);
                }
                catch (Exception e) {
                    LOG.warn("Error deleting image {}", new Object[]{fileDetail.getName(), e});
                }
            }
        }
        if (imageFilesToStore != null && !imageFilesToStore.isEmpty()) {
            HashSet<FileDetail> imagesToStore = new HashSet<FileDetail>(imageFilesToStore);
            if (storedImageFiles != null && !storedImageFiles.isEmpty()) {
                imagesToStore.removeAll(storedImageFiles);
            }
            for (FileDetail fileDetail : imagesToStore) {
                if (fileDetail == null || (fileItemId = fileDetail.getId()) > 0L || fileDetail == null || fileDetail.getUploadId() == null) continue;
                UploadResource uploadResource = this.getUploadService().getUploadResource(fileDetail.getUploadId());
                if (uploadResource == null) {
                    LOG.warn("Can't find uploaded resource with id {} for file with name {}", new Object[]{fileDetail.getUploadId(), fileDetail.getName()});
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)fileDetail.getName())) {
                    fileDetail.setName(uploadResource.getFileName());
                }
                if (fileDetail.getSize() == 0L) {
                    fileDetail.setSize((long)uploadResource.getEstimatedSize());
                }
                try (InputStream inputStream = this.getUploadDataAsStream(uploadResource);){
                    if (inputStream == null) continue;
                    FileItem fileItem = new FileItem(null, fileDetail.getName(), "image/png", FILE_API_NAME_SPACE, fileDetail.getSize(), new Date(), username, false, inputStream);
                    fileItem = this.getFileService().writeFile(fileItem);
                    fileDetail.setId(fileItem.getFileInfo().getId());
                }
                catch (Exception e) {
                    LOG.warn("Error uploading image {}", new Object[]{fileDetail.getName(), e});
                }
            }
        }
    }

    private FileService getFileService() {
        if (this.fileService == null) {
            this.fileService = (FileService)CommonsUtils.getService(FileService.class);
        }
        return this.fileService;
    }

    private UploadService getUploadService() {
        if (this.uploadService == null) {
            this.uploadService = (UploadService)CommonsUtils.getService(UploadService.class);
        }
        return this.uploadService;
    }

    private InputStream getUploadDataAsStream(UploadResource uploadResource) throws FileNotFoundException {
        if (uploadResource == null) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(uploadResource.getStoreLocation()));
            return fileInputStream;
        }
        finally {
            this.getUploadService().removeUploadResource(uploadResource.getUploadId());
        }
    }

    static {
        PerkStoreStorage.ajc$preClinit();
        LOG = ExoLogger.getLogger(PerkStoreStorage.class);
    }

    static final /* synthetic */ ProductOrder replaceTransactions_aroundBody0(PerkStoreStorage ajc$this, String oldHash, String newHash, JoinPoint joinPoint) {
        ProductOrderEntity order = ajc$this.orderDAO.findOrderByTransactionHash(oldHash);
        if (order == null) {
            order = ajc$this.orderDAO.findOrderByRefundTransactionHash(oldHash);
            if (order != null) {
                order.setRefundTransactionHash(newHash);
                order = (ProductOrderEntity)ajc$this.orderDAO.update(order);
            }
        } else {
            order.setTransactionHash(newHash);
            order = (ProductOrderEntity)ajc$this.orderDAO.update(order);
        }
        return order == null ? null : Utils.fromEntity(order);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PerkStoreStorage.java", PerkStoreStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "replaceTransactions", "org.exoplatform.perkstore.storage.PerkStoreStorage", "java.lang.String:java.lang.String", "oldHash:newHash", "", "org.exoplatform.perkstore.model.ProductOrder"), 242);
    }
}

