/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.groovyscript.Position;
import org.exoplatform.groovyscript.SectionType;
import org.exoplatform.groovyscript.TemplateSection;
import org.gatein.common.io.UndeclaredIOException;

public class TemplateParser {
    public List<TemplateSection> parse(String s) {
        try {
            return this.parse(new StringReader(s));
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public List<TemplateSection> parse(Reader tmp) throws IOException {
        int i;
        PushbackReader reader = new PushbackReader(tmp);
        ArrayList<TemplateSection> sections = new ArrayList<TemplateSection>();
        StringBuilder accumulator = new StringBuilder();
        int lineNumber = 1;
        int colNumber = 1;
        Position pos = new Position(1, 1);
        Status status = Status.TEXT;
        block17: while ((i = reader.read()) != -1) {
            int j;
            char c = (char)i;
            if (c == '\r' && (j = reader.read()) != -1) {
                char c2 = (char)j;
                if (c2 == '\n') {
                    c = '\n';
                } else {
                    reader.unread(j);
                }
            }
            if (c == '\n') {
                colNumber = 1;
                ++lineNumber;
            } else {
                ++colNumber;
            }
            switch (status.ordinal()) {
                case 0: {
                    if (c == '<') {
                        status = Status.START_ANGLE;
                        continue block17;
                    }
                    if (c == '\\') {
                        status = Status.BACKSLASH;
                        continue block17;
                    }
                    if (c == '$') {
                        status = Status.MAYBE_GSTRING_EXPR;
                        continue block17;
                    }
                    accumulator.append(c);
                    continue block17;
                }
                case 1: {
                    if (c == '%') {
                        status = Status.MAYBE_EXPR_END;
                        continue block17;
                    }
                    accumulator.append(c);
                    continue block17;
                }
                case 2: {
                    if (c == '%') {
                        status = Status.MAYBE_SCRIPLET_END;
                        continue block17;
                    }
                    accumulator.append(c);
                    continue block17;
                }
                case 3: {
                    if (c == '%') {
                        status = Status.SCRIPLET_OR_EXPR;
                        continue block17;
                    }
                    status = Status.TEXT;
                    accumulator.append('<').append(c);
                    continue block17;
                }
                case 4: {
                    if (accumulator.length() > 0) {
                        sections.add(new TemplateSection(SectionType.STRING, accumulator.toString(), pos));
                        accumulator.setLength(0);
                        pos = new Position(colNumber, lineNumber);
                    }
                    if (c == '=') {
                        status = Status.EXPR;
                        continue block17;
                    }
                    if (c == '%') {
                        status = Status.MAYBE_SCRIPLET_END;
                        continue block17;
                    }
                    status = Status.SCRIPTLET;
                    accumulator.append(c);
                    continue block17;
                }
                case 5: {
                    if (c == '>') {
                        sections.add(new TemplateSection(SectionType.SCRIPTLET, accumulator.toString(), pos));
                        accumulator.setLength(0);
                        pos = new Position(colNumber, lineNumber);
                        status = Status.TEXT;
                        continue block17;
                    }
                    if (c == '%') {
                        accumulator.append('%');
                        continue block17;
                    }
                    status = Status.SCRIPTLET;
                    accumulator.append('%').append(c);
                    continue block17;
                }
                case 6: {
                    if (c == '>') {
                        sections.add(new TemplateSection(SectionType.EXPR, accumulator.toString(), pos));
                        accumulator.setLength(0);
                        pos = new Position(colNumber, lineNumber);
                        status = Status.TEXT;
                        continue block17;
                    }
                    if (c == '%') {
                        accumulator.append('%');
                        continue block17;
                    }
                    status = Status.EXPR;
                    accumulator.append('%').append(c);
                    continue block17;
                }
                case 7: {
                    if (c == '{') {
                        if (accumulator.length() > 0) {
                            sections.add(new TemplateSection(SectionType.STRING, accumulator.toString(), pos));
                            accumulator.setLength(0);
                            pos = new Position(colNumber, lineNumber);
                        }
                        status = Status.GSTRING_CURLY_EXPR;
                        continue block17;
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        if (accumulator.length() > 0) {
                            sections.add(new TemplateSection(SectionType.STRING, accumulator.toString(), pos));
                            accumulator.setLength(0);
                            pos = new Position(colNumber, lineNumber);
                        }
                        status = Status.GSTRING_EXPR;
                        accumulator.append(c);
                        continue block17;
                    }
                    accumulator.append('$').append(c);
                    continue block17;
                }
                case 8: {
                    if (c == '}') {
                        sections.add(new TemplateSection(SectionType.EXPR, accumulator.toString(), pos));
                        accumulator.setLength(0);
                        pos = new Position(colNumber, lineNumber);
                        status = Status.TEXT;
                        continue block17;
                    }
                    accumulator.append(c);
                    continue block17;
                }
                case 9: {
                    if (c == '.' || Character.isJavaIdentifierPart(c)) {
                        accumulator.append(c);
                        continue block17;
                    }
                    sections.add(new TemplateSection(SectionType.EXPR, accumulator.toString(), pos));
                    accumulator.setLength(0);
                    pos = new Position(colNumber, lineNumber);
                    status = Status.TEXT;
                    accumulator.append(c);
                    continue block17;
                }
                case 10: {
                    accumulator.append('\\');
                    accumulator.append(c);
                    status = Status.TEXT;
                    continue block17;
                }
            }
            throw new AssertionError();
        }
        if (accumulator.length() > 0) {
            switch (status.ordinal()) {
                case 0: {
                    sections.add(new TemplateSection(SectionType.STRING, accumulator.toString(), pos));
                    accumulator.setLength(0);
                    pos = new Position(colNumber, lineNumber);
                    break;
                }
                case 9: {
                    sections.add(new TemplateSection(SectionType.EXPR, accumulator.toString(), pos));
                    accumulator.setLength(0);
                    pos = new Position(colNumber, lineNumber);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return Collections.unmodifiableList(sections);
    }

    private static enum Status {
        TEXT,
        EXPR,
        SCRIPTLET,
        START_ANGLE,
        SCRIPLET_OR_EXPR,
        MAYBE_SCRIPLET_END,
        MAYBE_EXPR_END,
        MAYBE_GSTRING_EXPR,
        GSTRING_CURLY_EXPR,
        GSTRING_EXPR,
        BACKSLASH;

    }
}

