/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.blockchain.listener;

import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.service.BlockchainTransactionService;
import io.meeds.wallet.service.WalletTransactionService;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

@Asynchronous
public class TransactionMinedAndUpdatedListener
extends Listener<Object, TransactionDetail> {
    private PortalContainer container;
    private WalletTransactionService walletTransactionService;
    private BlockchainTransactionService blockchainTransactionService;
    private int waitBeforeStopWatchingTimeout = 1;

    public TransactionMinedAndUpdatedListener(PortalContainer container, WalletTransactionService walletTransactionService, BlockchainTransactionService blockchainTransactionService) {
        this.container = container;
        this.walletTransactionService = walletTransactionService;
        this.blockchainTransactionService = blockchainTransactionService;
    }

    public void onEvent(Event<Object, TransactionDetail> event) throws Exception {
        CompletableFuture.runAsync(() -> {
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            RequestLifeCycle.begin((ExoContainer)this.container);
            try {
                if (this.walletTransactionService.countContractPendingTransactionsSent() == 0L && this.walletTransactionService.countContractPendingTransactionsToSend() == 0L) {
                    this.blockchainTransactionService.stopWatchingBlockchain();
                }
            }
            finally {
                RequestLifeCycle.end();
                ExoContainerContext.setCurrentContainer(null);
            }
        }, CompletableFuture.delayedExecutor(this.waitBeforeStopWatchingTimeout, TimeUnit.SECONDS));
    }

    public void setWaitBeforeStoppingWatchingTimeout(int waitBeforeStopWatchingTimeout) {
        this.waitBeforeStopWatchingTimeout = waitBeforeStopWatchingTimeout;
    }
}

