/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.addons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.addons.AddOnPlugin;
import org.exoplatform.commons.addons.AddOnService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.pom.data.ApplicationData;

public class AddOnServiceImpl
implements AddOnService {
    private List<ApplicationDecorator> apps = new ArrayList<ApplicationDecorator>();

    public List<Application> getApplications(String containerName) {
        return this.apps.stream().filter(app -> app.getContainerName().equals(containerName)).map(ApplicationDecorator::getApp).toList();
    }

    public void addPlugin(AddOnPlugin plugin) {
        for (Application app : plugin.getApplications()) {
            if (StringUtils.isBlank((CharSequence)app.getId())) {
                app.setId(UUID.randomUUID().toString());
            }
            this.apps.add(new ApplicationDecorator(this, app, plugin.getPriority(), plugin.getContainerName()));
        }
        Collections.sort(this.apps, new Comparator<ApplicationDecorator>(this){

            @Override
            public int compare(ApplicationDecorator o1, ApplicationDecorator o2) {
                if (o1.getAppPriority() != o2.getAppPriority()) {
                    return o1.getAppPriority() - o2.getAppPriority();
                }
                TransientApplicationState s1 = (TransientApplicationState)o1.getApp().getState();
                TransientApplicationState s2 = (TransientApplicationState)o2.getApp().getState();
                return s1.getContentId().compareTo(s2.getContentId());
            }
        });
    }

    class ApplicationDecorator
    extends Application {
        private Application app;
        private int appPriority;
        private String containerName;

        public ApplicationDecorator(AddOnServiceImpl this$0, ApplicationData appData) {
            super(appData);
        }

        public ApplicationDecorator(AddOnServiceImpl this$0, Application app, int priority, String containerName) {
            this.app = app;
            this.appPriority = priority;
            this.containerName = containerName;
        }

        public Application getApp() {
            return this.app;
        }

        public void setApp(Application app) {
            this.app = app;
        }

        public int getAppPriority() {
            return this.appPriority;
        }

        public void setAppPriority(int appPriority) {
            this.appPriority = appPriority;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }
    }
}

