/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.service;

import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationImage;
import io.meeds.appcenter.model.ApplicationList;
import io.meeds.appcenter.model.ApplicationOrder;
import io.meeds.appcenter.model.GeneralSettings;
import io.meeds.appcenter.model.UserApplication;
import io.meeds.appcenter.model.exception.ApplicationAlreadyExistsException;
import io.meeds.appcenter.model.exception.ApplicationNotFoundException;
import io.meeds.appcenter.storage.ApplicationCenterStorage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApplicationCenterService {
    private static final String APPLICATION_IS_MANDATORY_MESSAGE = "application is mandatory";
    public static final String DEFAULT_ADMINISTRATORS_GROUP = "/platform/administrators";
    public static final String DEFAULT_ADMINISTRATORS_PERMISSION = "*:/platform/administrators";
    public static final String ANY_PERMISSION = "any";
    public static final String DEFAULT_USERS_GROUP = "/platform/users";
    public static final String DEFAULT_USERS_PERMISSION = "*:/platform/users";
    public static final String MAX_FAVORITE_APPS = "maxFavoriteApps";
    public static final String DEFAULT_APP_IMAGE_ID = "defaultAppImageId";
    public static final String DEFAULT_APP_IMAGE_NAME = "defaultAppImageName";
    public static final String DEFAULT_APP_IMAGE_BODY = "defaultAppImageBody";
    public static final int DEFAULT_LIMIT = 10;
    public static final Context APP_CENTER_CONTEXT = Context.GLOBAL.id("APP_CENTER");
    public static final Scope APP_CENTER_SCOPE = Scope.APPLICATION.id("APP_CENTER");
    private static final String USERNAME_IS_MANDATORY_MESSAGE = "username is mandatory";
    private static final String APPLICATION_ID_IS_MANDATORY_MESSAGE = "applicationId is mandatory";
    private static final String USER_NOT_ALLOWED_MESSAGE = "User %s is not allowed to save application : %s";
    private static final String APPLICATION_NOT_FOUND_MESSAGE = "Application with id %s doesn't exist";
    @Autowired
    private SettingService settingService;
    @Autowired
    private Authenticator authenticator;
    @Autowired(required=false)
    private IdentityRegistry identityRegistry;
    @Autowired
    private ApplicationCenterStorage appCenterStorage;
    @Value(value="${appcenter.administrators.expression:*:/platform/administrators}")
    private String defaultAdministratorPermission = null;
    @Value(value="${appcenter.favorites.count:12}")
    private long defaultMaxFavoriteApps;
    @Value(value="${appcenter.favorites.max:-1}")
    private long maxFavoriteApps;

    public Application createApplication(Application application, String username) throws ApplicationAlreadyExistsException, IllegalAccessException {
        if (StringUtils.isBlank((CharSequence)username) || !this.isAdministrator(username)) {
            throw new IllegalAccessException(String.format(USER_NOT_ALLOWED_MESSAGE, username, application.getTitle()));
        }
        return this.createApplication(application);
    }

    public Application createApplication(Application application) throws ApplicationAlreadyExistsException {
        if (application == null) {
            throw new IllegalArgumentException(APPLICATION_IS_MANDATORY_MESSAGE);
        }
        Application existingApplication = this.appCenterStorage.getApplicationByTitle(application.getTitle());
        if (existingApplication != null) {
            throw new ApplicationAlreadyExistsException("appcenter.sameTitleAlreadyExists");
        }
        if (!this.isUrlValid(application.getUrl())) {
            throw new IllegalArgumentException("appcenter.malformedUrl");
        }
        if (StringUtils.isNotBlank((CharSequence)application.getHelpPageURL()) && !this.isUrlValid(application.getHelpPageURL())) {
            throw new IllegalArgumentException("appcenter.malformedHelpUrl");
        }
        if (application.getPermissions() == null || application.getPermissions().isEmpty()) {
            application.setPermissions(Collections.singletonList(DEFAULT_USERS_PERMISSION));
        }
        return this.appCenterStorage.createApplication(application);
    }

    public Application findApplication(long applicationId) throws ApplicationNotFoundException {
        Application application = this.appCenterStorage.getApplicationById(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        return application;
    }

    public Application updateApplication(Application application, String username) throws IllegalAccessException, ApplicationNotFoundException {
        if (application == null) {
            throw new IllegalArgumentException(APPLICATION_IS_MANDATORY_MESSAGE);
        }
        Long applicationId = application.getId();
        if (applicationId == null) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        if (!this.isUrlValid(application.getUrl())) {
            throw new IllegalArgumentException("appcenter.malformedUrl");
        }
        Application storedApplication = this.appCenterStorage.getApplicationById(applicationId);
        if (storedApplication == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        if (StringUtils.isBlank((CharSequence)username) || !this.isAdministrator(username)) {
            throw new IllegalAccessException(String.format(USER_NOT_ALLOWED_MESSAGE, username, application.getTitle()));
        }
        if (application.getPermissions() == null || application.getPermissions().isEmpty()) {
            application.setPermissions(Collections.singletonList(DEFAULT_USERS_PERMISSION));
        }
        return this.updateApplication(application);
    }

    public Application updateApplication(Application application) throws ApplicationNotFoundException {
        return this.appCenterStorage.updateApplication(application);
    }

    public void deleteApplication(Long applicationId, String username) throws ApplicationNotFoundException, IllegalAccessException {
        if (applicationId == null || applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        Application storedApplication = this.appCenterStorage.getApplicationById(applicationId);
        if (storedApplication == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        if (!this.isAdministrator(username)) {
            throw new IllegalAccessException(String.format(USER_NOT_ALLOWED_MESSAGE, username, storedApplication.getTitle()));
        }
        if (storedApplication.isSystem()) {
            throw new IllegalAccessException(String.format("Application with id %s is a system application, thus it can't be deleted", applicationId));
        }
        this.deleteApplication(applicationId);
    }

    public void deleteApplication(Long applicationId) throws ApplicationNotFoundException {
        this.appCenterStorage.deleteApplication(applicationId);
    }

    public void addFavoriteApplication(long applicationId, String username) throws ApplicationNotFoundException, IllegalAccessException {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        if (applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        Application application = this.appCenterStorage.getApplicationById(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        if (!this.hasPermission(username, application)) {
            throw new IllegalAccessException(String.format("User %s doesn't have enough permissions to delete application '%s'", username, application.getTitle()));
        }
        boolean isFavoriteApplication = this.appCenterStorage.isFavoriteApplication(applicationId, username);
        if (!isFavoriteApplication) {
            this.appCenterStorage.addApplicationToUserFavorite(applicationId, username);
        }
    }

    public void deleteFavoriteApplication(Long applicationId, String username) {
        if (applicationId == null || applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        this.appCenterStorage.deleteApplicationFavorite(applicationId, username);
    }

    public void setMaxFavoriteApps(long maxFavoriteApplications) {
        if (maxFavoriteApplications >= 0L) {
            this.settingService.set(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, MAX_FAVORITE_APPS, SettingValue.create((Long)maxFavoriteApplications));
            this.maxFavoriteApps = maxFavoriteApplications;
        } else {
            this.settingService.remove(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, MAX_FAVORITE_APPS);
            this.maxFavoriteApps = -1L;
        }
    }

    public long getMaxFavoriteApps() {
        if (this.maxFavoriteApps < 0L) {
            SettingValue maxFavoriteAppsValue = this.settingService.get(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, MAX_FAVORITE_APPS);
            this.maxFavoriteApps = maxFavoriteAppsValue != null && maxFavoriteAppsValue.getValue() != null ? Long.parseLong(maxFavoriteAppsValue.getValue().toString()) : this.defaultMaxFavoriteApps;
        }
        return this.maxFavoriteApps;
    }

    public ApplicationImage setDefaultAppImage(ApplicationImage defaultAppImage) {
        if (defaultAppImage == null || StringUtils.isBlank((CharSequence)defaultAppImage.getFileName()) && StringUtils.isBlank((CharSequence)defaultAppImage.getFileBody())) {
            this.settingService.remove(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, DEFAULT_APP_IMAGE_ID);
        } else {
            ApplicationImage applicationImage = this.appCenterStorage.saveAppImageFileItem(defaultAppImage);
            if (applicationImage != null && applicationImage.getId() != null && applicationImage.getId() > 0L) {
                this.settingService.set(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, DEFAULT_APP_IMAGE_ID, SettingValue.create((String)String.valueOf(applicationImage.getId())));
                return applicationImage;
            }
        }
        return null;
    }

    public GeneralSettings getSettings() {
        GeneralSettings generalsettings = new GeneralSettings();
        generalsettings.setMaxFavoriteApps(this.getMaxFavoriteApps());
        Long defaultAppImageId = this.getDefaultImageId();
        if (defaultAppImageId != null) {
            ApplicationImage defaultImage = this.appCenterStorage.getAppImageFile(defaultAppImageId);
            generalsettings.setDefaultApplicationImage(defaultImage);
        }
        return generalsettings;
    }

    public ApplicationList getApplications(int offset, int limit, String keyword) {
        ApplicationList applicationList = new ApplicationList();
        List<Application> applications = this.appCenterStorage.getApplications(keyword);
        int totalApplictions = applications.size();
        if (limit <= 0) {
            limit = applications.size();
        }
        applications = applications.stream().skip(offset).limit(limit).toList();
        applicationList.setApplications(applications);
        applicationList.setSize(totalApplictions);
        applicationList.setOffset(offset);
        applicationList.setLimit(limit);
        return applicationList;
    }

    public Application getApplicationByTitle(String title) {
        return this.appCenterStorage.getApplicationByTitle(title);
    }

    public ApplicationList getActiveApplications(int offset, int limit, String keyword, String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        ApplicationList resultApplicationsList = new ApplicationList();
        List<Object> applications = this.getActiveApplications(keyword, username).stream().toList();
        int totalApplication = applications.size();
        if (limit > 0) {
            if (offset < 0) {
                offset = 0;
            }
            applications = applications.stream().skip(offset).limit(limit).toList();
        }
        applications = applications.stream().map(app -> {
            UserApplication applicationFavorite = new UserApplication((Application)app);
            applicationFavorite.setFavorite(this.appCenterStorage.isFavoriteApplication(applicationFavorite.getId(), username));
            return applicationFavorite;
        }).toList();
        resultApplicationsList.setApplications(applications);
        long countFavorites = this.appCenterStorage.countFavorites(username);
        resultApplicationsList.setCanAddFavorite(countFavorites < this.getMaxFavoriteApps());
        resultApplicationsList.setOffset(offset);
        resultApplicationsList.setLimit(limit);
        resultApplicationsList.setSize(totalApplication);
        return resultApplicationsList;
    }

    public ApplicationList getMandatoryAndFavoriteApplicationsList(String username) {
        ArrayList<UserApplication> mandatoryAndFavoriteApplications = new ArrayList<UserApplication>(this.appCenterStorage.getFavoriteApplicationsByUser(username));
        List<Long> mandatoryAndFavoriteApplicationsId = mandatoryAndFavoriteApplications.stream().map(Application::getId).toList();
        this.appCenterStorage.getMandatoryApplications().forEach(userApplication -> {
            if (!mandatoryAndFavoriteApplicationsId.contains(userApplication.getId())) {
                mandatoryAndFavoriteApplications.add((UserApplication)userApplication);
            }
        });
        List<Application> applications = mandatoryAndFavoriteApplications.stream().filter(app -> this.hasPermission(username, (Application)app)).collect(Collectors.toList());
        ApplicationList applicationList = new ApplicationList();
        applicationList.setApplications(applications);
        long countFavorites = this.appCenterStorage.countFavorites(username);
        applicationList.setCanAddFavorite(countFavorites < this.getMaxFavoriteApps());
        applicationList.setLimit(applications.size());
        applicationList.setSize(applications.size());
        applicationList.setOffset(0L);
        return applicationList;
    }

    public void updateFavoriteApplicationOrder(ApplicationOrder applicationOrder, String userName) throws ApplicationNotFoundException {
        if (StringUtils.isBlank((CharSequence)userName)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        if (applicationOrder.getId() <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        Application application = this.appCenterStorage.getApplicationById(applicationOrder.getId());
        if (application == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationOrder.getId()));
        }
        this.appCenterStorage.updateFavoriteApplicationOrder(applicationOrder.getId(), userName, applicationOrder.getOrder());
    }

    public Long getApplicationImageLastUpdated(long applicationId, String username) throws ApplicationNotFoundException, IllegalAccessException {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        Application application = this.appCenterStorage.getApplicationById(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        if (!this.isAdministrator(username) && !this.hasPermission(username, application)) {
            throw new IllegalAccessException(String.format(USER_NOT_ALLOWED_MESSAGE, username, application.getTitle()));
        }
        if (application.getImageFileId() != null && application.getImageFileId() > 0L) {
            return this.appCenterStorage.getApplicationImageLastUpdated(application.getImageFileId());
        }
        Long defaultImageId = this.getDefaultImageId();
        if (defaultImageId != null && defaultImageId > 0L) {
            return this.appCenterStorage.getApplicationImageLastUpdated(defaultImageId);
        }
        return null;
    }

    public InputStream getApplicationImageInputStream(long applicationId, String username) throws ApplicationNotFoundException, IllegalAccessException {
        Long defaultImageId;
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        Application application = this.appCenterStorage.getApplicationById(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        if (!this.isAdministrator(username) && !this.hasPermission(username, application)) {
            throw new IllegalAccessException(String.format(USER_NOT_ALLOWED_MESSAGE, username, application.getTitle()));
        }
        InputStream applicationImageInputStream = null;
        if (application.getImageFileId() != null && application.getImageFileId() > 0L) {
            applicationImageInputStream = this.appCenterStorage.getApplicationImageInputStream(application.getImageFileId());
        }
        if (applicationImageInputStream == null && (defaultImageId = this.getDefaultImageId()) != null && defaultImageId > 0L) {
            applicationImageInputStream = this.appCenterStorage.getApplicationImageInputStream(defaultImageId);
        }
        return applicationImageInputStream;
    }

    public List<Application> getSystemApplications() {
        return this.appCenterStorage.getSystemApplications();
    }

    private boolean isAdministrator(String username) {
        return this.hasPermission(username, DEFAULT_ADMINISTRATORS_GROUP);
    }

    private boolean hasPermission(String username, Application application) {
        return this.hasPermission(username, application.getPermissions());
    }

    private boolean hasPermission(String username, List<String> storedPermissions) {
        if (storedPermissions == null) {
            return true;
        }
        for (String storedPermission : storedPermissions) {
            if (!this.hasPermission(username, storedPermission)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPermission(String username, String permissionExpression) {
        if (StringUtils.isBlank((CharSequence)permissionExpression)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            return false;
        }
        MembershipEntry membership = null;
        if (permissionExpression.contains(":")) {
            String[] permissionExpressionParts = permissionExpression.split(":");
            membership = new MembershipEntry(permissionExpressionParts[1], permissionExpressionParts[0]);
        } else if (permissionExpression.contains("/")) {
            membership = new MembershipEntry(permissionExpression, "*");
        } else {
            return StringUtils.equals((CharSequence)username, (CharSequence)permissionExpression);
        }
        return this.getUserIdentity(username).isMemberOf(membership);
    }

    private Identity getUserIdentity(String username) {
        Identity identity = this.getIdentityRegistry().getIdentity(username);
        if (identity == null) {
            return this.authenticator.createIdentity(username);
        }
        return identity;
    }

    private Long getDefaultImageId() {
        SettingValue defaultAppImageIdSetting = this.settingService.get(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, DEFAULT_APP_IMAGE_ID);
        Long defaultAppImageId = null;
        if (defaultAppImageIdSetting != null && defaultAppImageIdSetting.getValue() != null) {
            defaultAppImageId = Long.parseLong(defaultAppImageIdSetting.getValue().toString());
        }
        return defaultAppImageId;
    }

    private List<Application> getActiveApplications(String keyword, String username) {
        return this.appCenterStorage.getApplications(keyword).stream().filter(app -> this.hasPermission(username, (Application)app)).filter(Application::isActive).toList();
    }

    private boolean isUrlValid(String url) {
        String regex = "([a-zA-Z0-9-@:._\\/?&]+:\\/\\/)?http(s)?:\\/\\/[-a-zA-Z0-9@:%._\\\\/+~#=?&]{2,256}";
        Pattern pattern = Pattern.compile(regex);
        return url != null && !url.isBlank() && (url.startsWith("/portal/") || url.startsWith("./") || pattern.matcher(url).matches());
    }

    public IdentityRegistry getIdentityRegistry() {
        if (this.identityRegistry == null) {
            this.identityRegistry = (IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class);
        }
        return this.identityRegistry;
    }
}

