/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.observe.service;

import io.meeds.social.observe.model.Observer;
import io.meeds.social.observe.model.ObserverObject;
import io.meeds.social.observe.plugin.ObserverPlugin;
import io.meeds.social.observe.service.ObserverService;
import io.meeds.social.observe.storage.ObserverStorage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ObserverServiceImpl
implements ObserverService {
    private static final Log LOG = ExoLogger.getLogger(ObserverServiceImpl.class);
    private ObserverStorage observerStorage;
    private ListenerService listenerService;
    private Map<String, ObserverPlugin> observerPlugins = new HashMap<String, ObserverPlugin>();

    public ObserverServiceImpl(ObserverStorage observerStorage, ListenerService listenerService) {
        this.observerStorage = observerStorage;
        this.listenerService = listenerService;
    }

    public void addPlugin(ObserverPlugin observerPlugin) {
        this.observerPlugins.put(observerPlugin.getObjectType(), observerPlugin);
    }

    public void removePlugin(String objectType) {
        this.observerPlugins.remove(objectType);
    }

    public List<ObserverObject> getObservedObjects(long identityId, long offset, long limit) {
        return this.observerStorage.getObservedObjects(identityId, offset, limit);
    }

    public List<Long> getObserverIdentityIds(String objectType, String objectId) {
        return this.observerStorage.getObserverIdentityIds(objectType, objectId);
    }

    public void createObserver(long identityId, String objectType, String objectId, String parentObjectId) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        ObserverPlugin observerPlugin = this.observerPlugins.get(objectType);
        if (!observerPlugin.canObserve(identityId, objectId)) {
            throw new IllegalAccessException(String.format("User %s is not allowed to observe object %s/%s", identityId, objectType, objectId));
        }
        if (this.isObserved(identityId, objectType, objectId)) {
            throw new ObjectAlreadyExistsException((Object)String.format("User %s is already observing object %s/%s", identityId, objectType, objectId));
        }
        ObserverObject observerObject = this.getObserverObject(objectType, objectId, parentObjectId, observerPlugin.getSpaceId(objectId));
        Observer observer = new Observer(identityId, observerObject);
        this.observerStorage.createObserver(observer);
        ObserverObject extendedObserverObject = observerPlugin.getExtendedObserverObject(objectId);
        if (extendedObserverObject != null) {
            this.observerStorage.createObserver(new Observer(identityId, extendedObserverObject));
        }
        this.broadcastEvent("observe.added", observer);
    }

    public void deleteObserver(long identityId, String objectType, String objectId) throws ObjectNotFoundException {
        if (!this.isObserved(identityId, objectType, objectId)) {
            throw new ObjectNotFoundException(String.format("User %s isn't observing object %s/%s", identityId, objectType, objectId));
        }
        ObserverObject observerObject = this.getObserverObject(objectType, objectId);
        Observer observer = new Observer(identityId, observerObject);
        this.observerStorage.deleteObserver(observer);
        this.broadcastEvent("observe.deleted", observer);
    }

    public boolean isObserved(long identityId, String objectType, String objectId) {
        try {
            ObserverObject observerObject = this.getObserverObject(objectType, objectId);
            return this.observerStorage.isObserved(identityId, observerObject.getType(), observerObject.getId());
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
    }

    public boolean isObservable(long identityId, String objectType, String objectId) {
        ObserverPlugin observerPlugin = this.observerPlugins.get(objectType);
        try {
            return observerPlugin != null && observerPlugin.canObserve(identityId, objectId);
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
    }

    private void broadcastEvent(String eventName, Observer observer) {
        try {
            this.listenerService.broadcast(eventName, (Object)observer, null);
        }
        catch (Exception e) {
            LOG.warn("An error occurred while broadcasting event {} for observer {}", new Object[]{observer, e});
        }
    }

    private ObserverObject getObserverObject(String objectType, String objectId, String parentObjectId, long spaceId) throws ObjectNotFoundException {
        ObserverObject observerObject = this.getObserverObject(objectType, objectId);
        if (StringUtils.isBlank((CharSequence)observerObject.getParentId())) {
            observerObject.setParentId(parentObjectId);
        }
        if (observerObject.getSpaceId() == 0L) {
            observerObject.setSpaceId(spaceId);
        }
        return observerObject;
    }

    private ObserverObject getObserverObject(String objectType, String objectId) throws ObjectNotFoundException {
        ObserverPlugin observerPlugin = this.observerPlugins.get(objectType);
        ObserverObject observerObject = observerPlugin.getExtendedObserverObject(objectId);
        if (observerObject == null) {
            return new ObserverObject(objectType, objectId, null, observerPlugin.getSpaceId(objectId));
        }
        return observerObject;
    }
}

