/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.Calendar;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

@Asynchronous
public class UpdateLoginTimeListenerImpl
extends Listener<ConversationRegistry, ConversationState> {
    public void onEvent(Event<ConversationRegistry, ConversationState> event) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        ConversationState state = (ConversationState)event.getData();
        User user = (User)state.getAttribute("UserProfile");
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", ((ConversationState)event.getData()).getIdentity().getUserId());
        Profile profile = userIdentity.getProfile();
        if (profile != null) {
            profile.setProperty("lastLoginTime", (Object)(user != null ? user.getLastLoginTime() : Long.valueOf(Calendar.getInstance().getTimeInMillis())));
            identityManager.updateProfile(profile, false);
            IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
            indexingService.reindex("profile", userIdentity.getId());
        }
    }
}

