/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.resources.ResourceBundleService;

public class DateUtils {
    private static volatile Map<String, TimeZone> TIME_ZONES = new ConcurrentHashMap<String, TimeZone>();
    public static final String COMMONS_RESOUCE_BUNDLE_NAME = "locale.commons.Commons";

    public static TimeZone getTimeZone(String ID) {
        if (ID == null) {
            throw new IllegalArgumentException("ID of the timezone cannot be null");
        }
        TimeZone tz = TIME_ZONES.get(ID);
        if (tz == null) {
            tz = TimeZone.getTimeZone(ID);
            TIME_ZONES.put(ID, tz);
        }
        return tz;
    }

    public static String getRelativeTimeLabel(Locale locale, long postedTime) {
        ResourceBundleService rs = CommonsUtils.getService(ResourceBundleService.class);
        ResourceBundle resourceBundle = rs.getResourceBundle(COMMONS_RESOUCE_BUNDLE_NAME, locale);
        long time = (System.currentTimeMillis() - postedTime) / 1000L;
        if (time < 60L) {
            return resourceBundle.getString("TimeConvert.label.Less_Than_A_Minute");
        }
        if (time < 120L) {
            return resourceBundle.getString("TimeConvert.label.About_A_Minute");
        }
        if (time < 3600L) {
            long value = Math.round(time / 60L);
            return resourceBundle.getString("TimeConvert.label.About_?_Minutes").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 7200L) {
            return resourceBundle.getString("TimeConvert.label.About_An_Hour");
        }
        if (time < 86400L) {
            long value = Math.round(time / 3600L);
            return resourceBundle.getString("TimeConvert.label.About_?_Hours").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 172800L) {
            return resourceBundle.getString("TimeConvert.label.About_A_Day");
        }
        if (time < 2592000L) {
            long value = Math.round(time / 86400L);
            return resourceBundle.getString("TimeConvert.label.About_?_Days").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 5184000L) {
            return resourceBundle.getString("TimeConvert.label.About_A_Month");
        }
        long value = Math.round(time / 2592000L);
        return resourceBundle.getString("TimeConvert.label.About_?_Months").replaceFirst("\\{0\\}", String.valueOf(value));
    }
}

