/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.lang.Nullable;

public class AliasData {
    private final String alias;
    @Nullable
    private final Query filterQuery;
    @Nullable
    private final String indexRouting;
    @Nullable
    private final String searchRouting;
    @Nullable
    private final Boolean isWriteIndex;
    @Nullable
    private final Boolean isHidden;

    private AliasData(String alias, @Nullable Query filterQuery, @Nullable String indexRouting, @Nullable String searchRouting, @Nullable Boolean isWriteIndex, @Nullable Boolean isHidden) {
        this.alias = alias;
        this.filterQuery = filterQuery;
        this.indexRouting = indexRouting;
        this.searchRouting = searchRouting;
        this.isWriteIndex = isWriteIndex;
        this.isHidden = isHidden;
    }

    public static AliasData of(String alias, @Nullable Query filterQuery, @Nullable String indexRouting, @Nullable String searchRouting, @Nullable Boolean isWriteIndex, @Nullable Boolean isHidden) {
        return new AliasData(alias, filterQuery, indexRouting, searchRouting, isWriteIndex, isHidden);
    }

    public String getAlias() {
        return this.alias;
    }

    @Nullable
    public Query getFilterQuery() {
        return this.filterQuery;
    }

    @Nullable
    public String getIndexRouting() {
        return this.indexRouting;
    }

    @Nullable
    public String getSearchRouting() {
        return this.searchRouting;
    }

    @Nullable
    public Boolean isWriteIndex() {
        return this.isWriteIndex;
    }

    @Nullable
    public Boolean isHidden() {
        return Boolean.TRUE.equals(this.isHidden);
    }
}

