/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.storage;

import io.meeds.social.space.model.SpaceDirectorySettings;
import io.meeds.social.util.JsonUtils;
import lombok.Generated;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class SpaceDirectoryStorage {
    public static final Context CONTEXT = Context.GLOBAL.id("SpaceDirectory");
    public static final Scope SCOPE = Scope.APPLICATION.id("SpaceDirectory");
    @Autowired
    private SettingService settingService;

    @Cacheable(value={"social.spaceDirectorySetting"})
    public SpaceDirectorySettings get(String settingName) {
        SettingValue settingValue = this.settingService.get(CONTEXT, SCOPE, settingName);
        return settingValue == null || settingValue.getValue() == null ? null : (SpaceDirectorySettings)JsonUtils.fromJsonString((String)settingValue.getValue().toString(), SpaceDirectorySettings.class);
    }

    @CacheEvict(cacheNames={"social.spaceDirectorySetting"}, key="#p0")
    public void save(String settingName, SpaceDirectorySettings spaceDirectorySettings) {
        this.settingService.set(CONTEXT, SCOPE, settingName, SettingValue.create((String)JsonUtils.toJsonString((Object)spaceDirectorySettings)));
    }

    @CacheEvict(cacheNames={"social.spaceDirectorySetting"}, key="#p0")
    public void remove(String settingName) {
        this.settingService.remove(CONTEXT, SCOPE, settingName);
    }

    @Generated
    public void setSettingService(SettingService settingService) {
        this.settingService = settingService;
    }
}

