/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.RescoreQuery;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Rescore
implements JsonpSerializable {
    private final RescoreQuery query;
    @Nullable
    private final Integer windowSize;
    public static final JsonpDeserializer<Rescore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Rescore::setupRescoreDeserializer);

    private Rescore(Builder builder) {
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.windowSize = builder.windowSize;
    }

    public static Rescore of(Function<Builder, ObjectBuilder<Rescore>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final RescoreQuery query() {
        return this.query;
    }

    @Nullable
    public final Integer windowSize() {
        return this.windowSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.windowSize != null) {
            generator.writeKey("window_size");
            generator.write(this.windowSize.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRescoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::query, RescoreQuery._DESERIALIZER, "query");
        op.add(Builder::windowSize, JsonpDeserializer.integerDeserializer(), "window_size");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Rescore> {
        private RescoreQuery query;
        @Nullable
        private Integer windowSize;

        public final Builder query(RescoreQuery value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<RescoreQuery.Builder, ObjectBuilder<RescoreQuery>> fn) {
            return this.query(fn.apply(new RescoreQuery.Builder()).build());
        }

        public final Builder windowSize(@Nullable Integer value) {
            this.windowSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Rescore build() {
            this._checkSingleUse();
            return new Rescore(this);
        }
    }
}

