/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.storage.cached;

import io.meeds.wallet.dao.WalletAccountBackupDAO;
import io.meeds.wallet.dao.WalletAccountDAO;
import io.meeds.wallet.dao.WalletBlockchainStateDAO;
import io.meeds.wallet.dao.WalletPrivateKeyDAO;
import io.meeds.wallet.model.AddressAlreadyInUseException;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletCacheKey;
import io.meeds.wallet.model.WalletProvider;
import io.meeds.wallet.storage.WalletStorage;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.web.security.codec.CodecInitializer;

public class CachedAccountStorage
extends WalletStorage {
    private FutureExoCache<WalletCacheKey, Wallet, String> walletFutureCache = null;

    public CachedAccountStorage(CacheService cacheService, WalletAccountDAO walletAccountDAO, WalletAccountBackupDAO walletAccountBackupDAO, WalletPrivateKeyDAO privateKeyDAO, WalletBlockchainStateDAO blockchainStateDAO, CodecInitializer codecInitializer) {
        super(walletAccountDAO, walletAccountBackupDAO, privateKeyDAO, blockchainStateDAO, codecInitializer);
        ExoCache walletCache = cacheService.getCacheInstance("wallet.account");
        this.walletFutureCache = new FutureExoCache((Loader)new Loader<WalletCacheKey, Wallet, String>(){

            public Wallet retrieve(String contractAddress, WalletCacheKey cacheKey) throws Exception {
                if (StringUtils.isBlank((CharSequence)cacheKey.getAddress())) {
                    return CachedAccountStorage.super.getWalletByIdentityId(cacheKey.getIdentityId(), contractAddress);
                }
                return CachedAccountStorage.super.getWalletByAddress(cacheKey.getAddress(), contractAddress);
            }
        }, walletCache);
    }

    @Override
    public Wallet getWalletByAddress(String address, String contractAddress) {
        Wallet wallet = (Wallet)this.walletFutureCache.get((Object)contractAddress, (Object)new WalletCacheKey(address));
        return wallet == null ? null : wallet.clone();
    }

    @Override
    public Wallet getWalletByIdentityId(long identityId, String contractAddress) {
        Wallet wallet = (Wallet)this.walletFutureCache.get((Object)contractAddress, (Object)new WalletCacheKey(identityId));
        return wallet == null ? null : wallet.clone();
    }

    @Override
    public Wallet saveWalletBackupState(long identityId, boolean backupState) {
        Wallet wallet = super.saveWalletBackupState(identityId, backupState);
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getTechnicalId()));
        return wallet;
    }

    @Override
    public Wallet saveWallet(Wallet wallet, boolean isNew) throws AddressAlreadyInUseException {
        String oldAddress = null;
        if (!isNew) {
            Wallet oldWallet = this.getWalletByIdentityId(wallet.getTechnicalId(), null);
            oldAddress = oldWallet == null ? null : oldWallet.getAddress();
        }
        Wallet newWallet = super.saveWallet(wallet, isNew);
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getTechnicalId()));
        if (StringUtils.isNotBlank((CharSequence)oldAddress) && !StringUtils.equalsIgnoreCase((CharSequence)oldAddress, (CharSequence)wallet.getAddress())) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(oldAddress));
        }
        return newWallet;
    }

    @Override
    public void switchToInternalWallet(long walletId) {
        super.switchToInternalWallet(walletId);
        Wallet wallet = super.getWalletByIdentityId(walletId, null);
        if (wallet != null) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(walletId));
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        }
    }

    @Override
    public void switchToWalletProvider(long walletId, WalletProvider provider, String newAddress) {
        super.switchToWalletProvider(walletId, provider, newAddress);
        Wallet wallet = super.getWalletByIdentityId(walletId, null);
        if (wallet != null) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(walletId));
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        }
    }

    @Override
    public void saveWalletBlockchainState(Wallet wallet, String contractAddress) {
        super.saveWalletBlockchainState(wallet, contractAddress);
        long walletId = wallet.getTechnicalId();
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(walletId));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
    }

    @Override
    public Wallet removeWallet(long identityId) {
        Wallet wallet = super.removeWallet(identityId);
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getTechnicalId()));
        return wallet;
    }

    @Override
    public void removeWalletPrivateKey(long walletId) {
        super.removeWalletPrivateKey(walletId);
        Wallet wallet = super.getWalletByIdentityId(walletId, null);
        if (wallet != null) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(walletId));
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        }
    }

    @Override
    public void saveWalletPrivateKey(long walletId, String content) {
        super.saveWalletPrivateKey(walletId, content);
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(walletId));
        Wallet wallet = super.getWalletByIdentityId(walletId, null);
        if (wallet != null) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        }
    }

    public void clearCache() {
        this.walletFutureCache.clear();
    }
}

