/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PathElement {
    private static final String TEMPLATE_NAME_REGEX = "\\w[\\w\\.-]*";
    private static final String TEMPLATE_PARAM_REGEX_REGEX = "[^{}][^{}]*";
    private static final String TEMPLATE_PARAM_REGEX = "\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))?\\}";
    private static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))?\\}");
    private static final String TEMPLATE_PARAM_DEFAULT_REGEX = "[^/]+";
    private final String value;
    private final List<Group> groups;
    private final String regex;
    private final Pattern pattern;
    private static final Pattern GROUP = Pattern.compile("[^\\\\]\\(");
    private static final char openCurlyReplacement = '\u0006';
    private static final char closeCurlyReplacement = '\u0007';

    public static PathElement pathElement(String path) throws PatternSyntaxException {
        String replacedCurlySegment = PathElement.replaceEnclosedCurlyBraces(path);
        String[] split = TEMPLATE_PARAM_PATTERN.split(replacedCurlySegment);
        Matcher withPathParam = TEMPLATE_PARAM_PATTERN.matcher(replacedCurlySegment);
        int i = 0;
        StringBuilder buffer = new StringBuilder();
        if (i < split.length) {
            buffer.append(split[i++]);
        }
        int groupNumber = 1;
        ArrayList<Group> groups = new ArrayList<Group>();
        while (withPathParam.find()) {
            String name = withPathParam.group(1);
            buffer.append("(");
            if (withPathParam.group(3) == null) {
                buffer.append(TEMPLATE_PARAM_DEFAULT_REGEX);
                groups.add(new Group(name, groupNumber++));
            } else {
                String expr = withPathParam.group(3);
                expr = PathElement.recoverEnclosedCurlyBraces(expr);
                buffer.append(expr);
                groups.add(new Group(name, groupNumber++));
                groupNumber += PathElement.groupCount(expr);
            }
            buffer.append(")");
            if (i >= split.length) continue;
            buffer.append(split[i++]);
        }
        return new PathElement(path, groups, buffer.toString());
    }

    public PathElement(String value, List<Group> groups, String regex) {
        this.value = value;
        this.groups = groups;
        this.regex = regex;
        this.pattern = Pattern.compile(regex);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isTemplate() {
        return !this.value.equals(this.regex);
    }

    public boolean matches(String path) {
        int start = 0;
        if (path.charAt(0) == '/') {
            ++start;
        }
        Matcher matcher = this.pattern.matcher(path);
        matcher.region(start, path.length());
        return matcher.matches();
    }

    public String resolve(String name, String path) {
        Matcher matcher = this.pattern.matcher(path);
        int start = 0;
        if (path.charAt(0) == '/') {
            ++start;
        }
        for (Group group : this.groups) {
            if (!matcher.find(start) || !group.name.equals(name)) continue;
            String s = matcher.group(group.group);
            if ("".equals(s)) {
                return null;
            }
            return s;
        }
        return null;
    }

    private static int groupCount(String regex) {
        Matcher matcher = GROUP.matcher(regex);
        int count = 0;
        if (regex.startsWith("(")) {
            ++count;
        }
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    private static String replaceEnclosedCurlyBraces(String str) {
        char[] chars = str.toCharArray();
        int open = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '{') {
                if (open != 0) {
                    chars[i] = 6;
                }
                ++open;
                continue;
            }
            if (chars[i] != '}' || --open == 0) continue;
            chars[i] = 7;
        }
        return new String(chars);
    }

    private static String recoverEnclosedCurlyBraces(String str) {
        return str.replace('\u0006', '{').replace('\u0007', '}');
    }

    private static final class Group {
        private String name;
        private int group;

        private Group(String name, int group) {
            this.name = name;
            this.group = group;
        }

        public String toString() {
            return "Group{name='" + this.name + '\'' + ", group=" + this.group + '}';
        }
    }
}

