/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.SpaceStorage;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceExternalInvitationDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceMemberDAO;
import org.exoplatform.social.core.jpa.storage.dao.jpa.SpaceDAO;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.cache.CacheType;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedIdentityStorage;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.storage.cache.loader.ServiceContext;
import org.exoplatform.social.core.storage.cache.model.data.IntegerData;
import org.exoplatform.social.core.storage.cache.model.data.ListIdentitiesData;
import org.exoplatform.social.core.storage.cache.model.data.ListSpacesData;
import org.exoplatform.social.core.storage.cache.model.data.SpaceData;
import org.exoplatform.social.core.storage.cache.model.key.ListIdentitiesKey;
import org.exoplatform.social.core.storage.cache.model.key.ListSpacesKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceRefKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceType;
import org.exoplatform.social.core.storage.cache.selector.IdentityCacheSelector;
import org.exoplatform.social.core.storage.cache.selector.LastAccessedSpacesCacheSelector;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.web.security.security.RemindPasswordTokenService;

public class CachedSpaceStorage
extends SpaceStorage {
    private static final SpaceKey EMPTY_SPACE_KEY = new SpaceKey(0L);
    private static final Log LOG = ExoLogger.getLogger(CachedSpaceStorage.class);
    private final ExoCache<SpaceKey, SpaceData> spaceCache;
    private final ExoCache<SpaceRefKey, SpaceKey> spaceRefCache;
    private final ExoCache<SpaceFilterKey, IntegerData> spacesCountCache;
    private final ExoCache<SpaceKey, HashMap<Long, Long>> spacesCountByTemplateCache;
    private final ExoCache<ListSpacesKey, ListSpacesData> spacesCache;
    private final ExoCache<ListIdentitiesKey, ListIdentitiesData> identitiesCache;
    private final FutureExoCache<SpaceKey, SpaceData, ServiceContext<SpaceData>> spaceFutureCache;
    private final FutureExoCache<SpaceRefKey, SpaceKey, ServiceContext<SpaceKey>> spaceRefFutureCache;
    private final FutureExoCache<SpaceFilterKey, IntegerData, ServiceContext<IntegerData>> spacesCountFutureCache;
    private final FutureExoCache<SpaceKey, HashMap<Long, Long>, ServiceContext<HashMap<Long, Long>>> spacesCountByTemplateFutureCache;
    private final FutureExoCache<ListSpacesKey, ListSpacesData, ServiceContext<ListSpacesData>> spacesFutureCache;
    private SocialStorageCacheService cacheService;
    private CachedActivityStorage cachedActivityStorage;
    private CachedIdentityStorage cachedIdentityStorage;

    public CachedSpaceStorage(SpaceDAO spaceDAO, SpaceMemberDAO spaceMemberDAO, IdentityStorage identityStorage, IdentityDAO identityDAO, ActivityDAO activityDAO, SpaceExternalInvitationDAO spaceExternalInvitationDAO, SocialStorageCacheService cacheService, FavoriteService favoriteService, RemindPasswordTokenService remindPasswordTokenService) {
        super(spaceDAO, spaceMemberDAO, identityStorage, identityDAO, activityDAO, spaceExternalInvitationDAO, favoriteService, remindPasswordTokenService);
        this.cacheService = cacheService;
        this.spaceCache = cacheService.getSpaceCache();
        this.spaceRefCache = cacheService.getSpaceRefCache();
        this.spacesCountCache = cacheService.getSpacesCountCache();
        this.spacesCache = cacheService.getSpacesCache();
        this.identitiesCache = cacheService.getIdentitiesCache();
        this.spacesCountByTemplateCache = cacheService.getSpacesCountByTemplateCache();
        this.spaceFutureCache = CacheType.SPACE.createFutureCache(this.spaceCache);
        this.spaceRefFutureCache = CacheType.SPACE_REF.createFutureCache(this.spaceRefCache);
        this.spacesCountFutureCache = CacheType.SPACES_COUNT.createFutureCache(this.spacesCountCache);
        this.spacesCountByTemplateFutureCache = CacheType.SPACES_COUNT_BY_TEMPLATE.createFutureCache(this.spacesCountByTemplateCache);
        this.spacesFutureCache = CacheType.SPACES.createFutureCache(this.spacesCache);
    }

    private List<Space> buildSpaces(ListSpacesData data) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        for (SpaceKey k : data.getIds()) {
            Space s = this.getSpaceById(k.getId());
            spaces.add(s);
        }
        return spaces;
    }

    private List<String> buildIds(ListSpacesData data) {
        if (data == null || data.getIds() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> identityIds = new ArrayList<String>();
        for (SpaceKey k : data.getIds()) {
            identityIds.add(String.valueOf(k.getId()));
        }
        return identityIds;
    }

    public CachedIdentityStorage getCachedIdentityStorage() {
        if (this.cachedIdentityStorage == null) {
            this.cachedIdentityStorage = (CachedIdentityStorage)PortalContainer.getInstance().getComponentInstanceOfType(CachedIdentityStorage.class);
        }
        return this.cachedIdentityStorage;
    }

    private ListSpacesData buildIds(List<Space> spaces) {
        ArrayList<SpaceKey> data = new ArrayList<SpaceKey>();
        for (Space s : spaces) {
            SpaceKey k = this.putSpaceInCacheIfNotExists(s);
            data.add(k);
        }
        return new ListSpacesData((List<SpaceKey>)data);
    }

    private ListSpacesData buildListIdentityIds(List<String> spaceIds) {
        ArrayList<SpaceKey> data = new ArrayList<SpaceKey>();
        for (String spaceId : spaceIds) {
            SpaceKey k = new SpaceKey(Long.parseLong(spaceId));
            data.add(k);
        }
        return new ListSpacesData((List<SpaceKey>)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Space saveSpace(Space space, boolean isNew) {
        try {
            Space space2 = super.saveSpace(space, isNew);
            return space2;
        }
        finally {
            this.spaceCache.remove((Serializable)new SpaceKey(space.getSpaceId()));
            this.clearSpaceCache();
            this.clearIdentityCache();
            this.cleanRef(space);
        }
    }

    @Override
    public void renameSpace(Space space) throws SpaceStorageException {
        Space existingSpace = this.getSpaceById(space.getSpaceId());
        String oldPrettyName = existingSpace.getPrettyName();
        super.renameSpace(space);
        this.cachedIdentityStorage = this.getCachedIdentityStorage();
        Identity identitySpace = this.cachedIdentityStorage.findIdentity("space", space.getPrettyName());
        if (identitySpace == null) {
            identitySpace = this.cachedIdentityStorage.findIdentity("space", oldPrettyName);
        }
        if (identitySpace != null) {
            this.cachedIdentityStorage.clearIdentityCached(identitySpace, oldPrettyName);
        }
        this.cachedActivityStorage = this.getCachedActivityStorage();
        this.cachedActivityStorage.clearOwnerStreamCache(oldPrettyName);
        this.spaceCache.remove((Serializable)new SpaceKey(space.getSpaceId()));
        this.clearSpaceCache();
        this.clearIdentityCache();
        this.cleanRef(space);
        this.spaceRefCache.remove((Serializable)new SpaceRefKey(oldPrettyName));
        this.spaceRefCache.remove((Serializable)new SpaceRefKey(null, space.getGroupId()));
    }

    @Override
    public void deleteSpace(String id) throws SpaceStorageException {
        Space space = this.getSpaceById(Long.parseLong(id));
        super.deleteSpace(id);
        this.spaceCache.remove((Serializable)new SpaceKey(Long.parseLong(id)));
        this.clearSpaceCache();
        this.cleanRef(space);
        this.getCachedActivityStorage().clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignoreSpace(String spaceId, String userId) {
        try {
            super.ignoreSpace(spaceId, userId);
        }
        finally {
            SpaceData spaceData = (SpaceData)this.spaceCache.remove((Serializable)new SpaceKey(Long.parseLong(spaceId)));
            if (spaceData != null) {
                Space space = spaceData.build();
                this.clearSpaceCache();
                this.clearIdentityCache();
                if (space != null) {
                    this.cleanRef(space);
                }
            }
        }
    }

    @Override
    public List<Space> getManagerSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.MANAGER);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesFutureCache.get(() -> {
            if (limit == 0L) {
                return this.buildIds(Collections.emptyList());
            }
            List got = CachedSpaceStorage.super.getManagerSpacesByFilter(userId, spaceFilter, offset, limit);
            return this.buildIds(got);
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getManagerSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.MANAGER);
        return (Integer)((IntegerData)this.spacesCountFutureCache.get(() -> new IntegerData(CachedSpaceStorage.super.getManagerSpacesByFilterCount(userId, spaceFilter)), (Object)key)).build();
    }

    @Override
    public int getMemberSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.MEMBER);
        return (Integer)((IntegerData)this.spacesCountFutureCache.get(() -> new IntegerData(CachedSpaceStorage.super.getMemberSpacesByFilterCount(userId, spaceFilter)), (Object)key)).build();
    }

    @Override
    public List<Space> getMemberSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.MEMBER);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesFutureCache.get(() -> {
            if (limit == 0L) {
                return this.buildIds(Collections.emptyList());
            }
            List got = CachedSpaceStorage.super.getMemberSpacesByFilter(userId, spaceFilter, offset, limit);
            return this.buildIds(got);
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getPendingSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.PENDING);
        return (Integer)((IntegerData)this.spacesCountFutureCache.get(() -> new IntegerData(CachedSpaceStorage.super.getPendingSpacesByFilterCount(userId, spaceFilter)), (Object)key)).build();
    }

    @Override
    public List<Space> getPendingSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.PENDING);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesFutureCache.get(() -> {
            if (limit == 0L) {
                return this.buildIds(Collections.emptyList());
            }
            List got = CachedSpaceStorage.super.getPendingSpacesByFilter(userId, spaceFilter, offset, limit);
            return this.buildIds(got);
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getInvitedSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.INVITED);
        return (Integer)((IntegerData)this.spacesCountFutureCache.get(() -> new IntegerData(CachedSpaceStorage.super.getInvitedSpacesByFilterCount(userId, spaceFilter)), (Object)key)).build();
    }

    @Override
    public List<Space> getInvitedSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.INVITED);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesFutureCache.get(() -> {
            if (limit == 0L) {
                return this.buildIds(Collections.emptyList());
            }
            List got = CachedSpaceStorage.super.getInvitedSpacesByFilter(userId, spaceFilter, offset, limit);
            return this.buildIds(got);
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getAccessibleSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.ACCESSIBLE);
        return (Integer)((IntegerData)this.spacesCountFutureCache.get(() -> new IntegerData(CachedSpaceStorage.super.getAccessibleSpacesByFilterCount(userId, spaceFilter)), (Object)key)).build();
    }

    @Override
    public int getVisibleSpacesCount(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.VISIBLE);
        return (Integer)((IntegerData)this.spacesCountFutureCache.get(() -> new IntegerData(CachedSpaceStorage.super.getVisibleSpacesCount(userId, spaceFilter)), (Object)key)).build();
    }

    @Override
    public List<Space> getAccessibleSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        SpaceFilterKey key = new SpaceFilterKey(userId, spaceFilter, SpaceType.ACCESSIBLE);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesFutureCache.get(() -> {
            if (limit == 0L) {
                return this.buildIds(Collections.emptyList());
            }
            List got = CachedSpaceStorage.super.getAccessibleSpacesByFilter(userId, spaceFilter, offset, limit);
            return this.buildIds(got);
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public int getAllSpacesByFilterCount(SpaceFilter spaceFilter) {
        SpaceFilterKey key = new SpaceFilterKey(null, spaceFilter, null);
        return (Integer)((IntegerData)this.spacesCountFutureCache.get(() -> new IntegerData(CachedSpaceStorage.super.getAllSpacesByFilterCount(spaceFilter)), (Object)key)).build();
    }

    @Override
    public List<Space> getSpacesByFilter(SpaceFilter spaceFilter, long offset, long limit) {
        SpaceFilterKey key = new SpaceFilterKey(spaceFilter == null ? null : spaceFilter.getRemoteId(), spaceFilter, null);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesFutureCache.get(() -> {
            if (limit == 0L) {
                return this.buildIds(Collections.emptyList());
            }
            List got = CachedSpaceStorage.super.getSpacesByFilter(spaceFilter, offset, limit);
            return this.buildIds(got);
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public Space getSpaceById(long id) throws SpaceStorageException {
        SpaceKey key = new SpaceKey(id);
        SpaceData data = (SpaceData)this.spaceFutureCache.get(() -> {
            Space space = CachedSpaceStorage.super.getSpaceById(id);
            if (space != null) {
                this.putSpaceInCacheIfNotExists(space);
                return new SpaceData(space);
            }
            return null;
        }, (Object)key);
        if (data != null) {
            return data.build();
        }
        return null;
    }

    @Override
    public Space getSpaceByPrettyName(String spacePrettyName) throws SpaceStorageException {
        SpaceRefKey refKey = new SpaceRefKey(spacePrettyName);
        SpaceKey key = (SpaceKey)this.spaceRefFutureCache.get(() -> {
            Space space = CachedSpaceStorage.super.getSpaceByPrettyName(spacePrettyName);
            if (space != null) {
                return this.putSpaceInCacheIfNotExists(space);
            }
            return SpaceKey.NULL_OBJECT;
        }, (Object)refKey);
        if (key != null && key != SpaceKey.NULL_OBJECT && key.getId() > 0L) {
            return this.getSpaceById(key.getId());
        }
        return null;
    }

    @Override
    public Space getSpaceByGroupId(String groupId) throws SpaceStorageException {
        SpaceRefKey refKey = new SpaceRefKey(null, groupId);
        SpaceKey key = (SpaceKey)this.spaceRefFutureCache.get(() -> {
            Space space = CachedSpaceStorage.super.getSpaceByGroupId(groupId);
            if (space != null) {
                return this.putSpaceInCacheIfNotExists(space);
            }
            return SpaceKey.NULL_OBJECT;
        }, (Object)refKey);
        if (key != null && key != SpaceKey.NULL_OBJECT && key.getId() > 0L) {
            return this.getSpaceById(key.getId());
        }
        return null;
    }

    @Override
    public void updateSpaceAccessed(String remoteId, Space space) throws SpaceStorageException {
        LastAccessedSpacesCacheSelector selector = new LastAccessedSpacesCacheSelector(remoteId, space, this.cacheService);
        try {
            if (selector.isUpdateStore()) {
                super.updateSpaceAccessed(remoteId, space);
            }
            this.spacesCache.select((CachedObjectSelector)selector);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while removing cache entries for remoteId=" + remoteId + ", space=" + space.getDisplayName() + " and type=" + SpaceType.LATEST_ACCESSED.name()), (Throwable)e);
        }
    }

    @Override
    public List<Space> getLastAccessedSpace(SpaceFilter filter, int offset, int limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(filter.getRemoteId(), filter, SpaceType.LATEST_ACCESSED);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesFutureCache.get(() -> {
            if (limit == 0) {
                return this.buildIds(Collections.emptyList());
            }
            List got = CachedSpaceStorage.super.getLastAccessedSpace(filter, offset, limit);
            return this.buildIds(got);
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<Space> getLastSpaces(int limit) {
        SpaceFilter filter = new SpaceFilter();
        filter.setSorting(new Sorting(Sorting.SortBy.DATE, Sorting.OrderBy.DESC));
        SpaceFilterKey key = new SpaceFilterKey(null, filter, null);
        ListSpacesKey listKey = new ListSpacesKey(key, 0L, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesFutureCache.get(() -> {
            if (limit == 0) {
                return this.buildIds(Collections.emptyList());
            }
            List got = CachedSpaceStorage.super.getLastSpaces(limit);
            return this.buildIds(got);
        }, (Object)listKey);
        return this.buildSpaces(keys);
    }

    @Override
    public List<String> getMemberRoleSpaceIdentityIds(String identityId, int offset, int limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(identityId, null, SpaceType.MEMBER_IDENTITY_IDS);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesFutureCache.get(() -> {
            if (limit == 0) {
                return this.buildIds(Collections.emptyList());
            }
            List got = CachedSpaceStorage.super.getMemberRoleSpaceIdentityIds(identityId, offset, limit);
            return this.buildListIdentityIds(got);
        }, (Object)listKey);
        return this.buildIds(keys);
    }

    @Override
    public List<String> getMemberRoleSpaceIds(String identityId, int offset, int limit) throws SpaceStorageException {
        SpaceFilterKey key = new SpaceFilterKey(identityId, null, SpaceType.MEMBER_IDS);
        ListSpacesKey listKey = new ListSpacesKey(key, offset, limit);
        ListSpacesData keys = (ListSpacesData)this.spacesFutureCache.get(() -> {
            if (limit == 0) {
                return this.buildIds(Collections.emptyList());
            }
            List got = CachedSpaceStorage.super.getMemberRoleSpaceIds(identityId, offset, limit);
            return this.buildListIdentityIds(got);
        }, (Object)listKey);
        return this.buildIds(keys);
    }

    @Override
    public Map<Long, Long> countSpacesByTemplate() {
        return (Map)this.spacesCountByTemplateFutureCache.get(() -> new HashMap<Long, Long>(super.countSpacesByTemplate()), (Object)EMPTY_SPACE_KEY);
    }

    public void clearSpaceCached(String spaceId) {
        SpaceKey cacheKey = new SpaceKey(Long.parseLong(spaceId));
        SpaceData cachedSpace = (SpaceData)this.spaceCache.get((Serializable)cacheKey);
        if (cachedSpace != null) {
            Space space = cachedSpace.build();
            this.spaceCache.remove((Serializable)cacheKey);
            this.cleanRef(space);
        }
        this.clearSpaceCache();
        this.clearIdentityCache();
    }

    public void clearCaches() {
        this.spaceCache.clearCache();
        this.spacesCountCache.clearCache();
        this.spacesCountByTemplateCache.clearCache();
        this.spacesCache.clearCache();
        this.spaceRefCache.clearCache();
        this.identitiesCache.clearCache();
    }

    private SpaceKey putSpaceInCacheIfNotExists(Space space) {
        SpaceRefKey refKey;
        SpaceKey key = new SpaceKey(space.getSpaceId());
        if (this.spaceCache.get((Serializable)key) == null) {
            this.spaceCache.putLocal((Serializable)key, (Object)new SpaceData(space));
        }
        if (this.spaceRefCache.get((Serializable)(refKey = new SpaceRefKey(null, space.getGroupId()))) == null) {
            this.spaceRefCache.putLocal((Serializable)refKey, (Object)key);
        }
        if (this.spaceRefCache.get((Serializable)(refKey = new SpaceRefKey(space.getPrettyName()))) == null) {
            this.spaceRefCache.putLocal((Serializable)refKey, (Object)key);
        }
        return key;
    }

    private CachedActivityStorage getCachedActivityStorage() {
        if (this.cachedActivityStorage == null) {
            this.cachedActivityStorage = (CachedActivityStorage)PortalContainer.getInstance().getComponentInstanceOfType(CachedActivityStorage.class);
        }
        return this.cachedActivityStorage;
    }

    private void cleanRef(Space removed) {
        if (removed == null) {
            return;
        }
        this.spaceRefCache.remove((Serializable)new SpaceRefKey(removed.getPrettyName()));
        this.spaceRefCache.remove((Serializable)new SpaceRefKey(null, removed.getGroupId()));
        this.spaceRefFutureCache.remove((Serializable)new SpaceRefKey(removed.getPrettyName()));
        this.spaceRefFutureCache.remove((Serializable)new SpaceRefKey(null, removed.getGroupId()));
    }

    private void clearIdentityCache() {
        try {
            this.identitiesCache.select((CachedObjectSelector)new IdentityCacheSelector("space"));
        }
        catch (Exception e) {
            LOG.error((Object)"Error deleting cache entries of provider type 'Space Identities'", (Throwable)e);
        }
    }

    private void clearSpaceCache() {
        try {
            this.spacesCache.clearCache();
            this.spacesCountCache.clearCache();
            this.spacesCountByTemplateCache.clearCache();
        }
        catch (Exception e) {
            LOG.error((Object)"Error deleting space caches", (Throwable)e);
        }
    }
}

