/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.plugin;

import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.FavoriteACLPlugin;

public class SpaceFavoriteACLPlugin
extends FavoriteACLPlugin {
    private static final String SPACE_FAVORITE_TYPE = "space";
    private final SpaceService spaceService;
    private final IdentityManager identityManager;

    public SpaceFavoriteACLPlugin(SpaceService spaceService, IdentityManager identityManager) {
        this.spaceService = spaceService;
        this.identityManager = identityManager;
    }

    public String getEntityType() {
        return SPACE_FAVORITE_TYPE;
    }

    public boolean canCreateFavorite(org.exoplatform.services.security.Identity userIdentity, String objectId) {
        String userIdentityId = userIdentity.getUserId();
        Identity identity = this.identityManager.getOrCreateUserIdentity(userIdentityId);
        if (identity == null) {
            throw new IllegalStateException("User with id " + userIdentityId + " wasn't found");
        }
        Space space = this.spaceService.getSpaceById(objectId);
        if (space == null) {
            throw new IllegalStateException("Space with id " + objectId + " wasn't found");
        }
        String userRemoteId = identity.getRemoteId();
        return this.spaceService.isMember(space, userRemoteId);
    }
}

