/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.perkstore;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"perk-store"})
@Component
public class ProductCreatedPwaNotificationPlugin
implements PwaNotificationPlugin {
    private static final String TITLE_LABEL_KEY = "pwa.notification.ProductAddedNotificationPlugin.title";
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private PermanentLinkService permanentLinkService;

    public String getId() {
        return "ProductAddedNotificationPlugin";
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        notificationMessage.setTitle(this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()));
        notificationMessage.setBody(notification.getValueOwnerParameter("PRODUCT_TITLE"));
        notificationMessage.setUrl(this.permanentLinkService.getPermanentLink(new PermanentLinkObject("perkstore", notification.getValueOwnerParameter("PRODUCT_ID"))));
        return notificationMessage;
    }
}

