/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.space;

import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.social.category.service.CategoryService;
import io.meeds.social.space.constant.SpaceRegistration;
import io.meeds.social.space.constant.SpaceVisibility;
import io.meeds.social.space.service.SpaceDirectoryService;
import io.meeds.social.space.service.SpaceLayoutService;
import io.meeds.social.util.JsonUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.deprecation.DeprecatedAPI;
import org.exoplatform.deprecation.DeprecatedAPIAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.thumbnail.ImageThumbnailService;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.rest.impl.space.SpaceRest$AjcClosure1;
import org.exoplatform.social.rest.impl.space.SpaceRest$AjcClosure3;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;

@Path(value="v1/social/spaces")
@Tag(name="v1/social/spaces", description="Operations on spaces with their activities and users")
public class SpaceRest
implements ResourceContainer {
    private static final Log LOG;
    private static final String SPACE_FILTER_TYPE_ALL = "all";
    private static final String SPACE_FILTER_TYPE_MEMBER = "member";
    private static final String SPACE_FILTER_TYPE_ACCESSIBLE = "accessible";
    private static final String SPACE_FILTER_TYPE_MANAGER = "manager";
    private static final String SPACE_FILTER_TYPE_EDITABLE = "editable";
    private static final String SPACE_FILTER_TYPE_PENDING = "pending";
    private static final String SPACE_FILTER_TYPE_INVITED = "invited";
    private static final String SPACE_FILTER_TYPE_REQUESTS = "requests";
    private static final String SPACE_FILTER_TYPE_FAVORITE = "favorite";
    private static final String LAST_VISITED_SPACES = "lastVisited";
    private static final CacheControl CACHE_CONTROL;
    private static final CacheControl CACHE_REVALIDATE_CONTROL;
    public static final String PROFILE_DEFAULT_BANNER_URL = "/skin/images/banner/DefaultSpaceBanner.png";
    private static final Date DEFAULT_IMAGES_LAST_MODIFED;
    private static final long DEFAULT_IMAGES_HASH;
    private static final int CACHE_IN_SECONDS = 604800;
    private static final int CACHE_IN_MILLI_SECONDS = 604800000;
    private final IdentityManager identityManager;
    private final UploadService uploadService;
    private final SpaceDirectoryService spaceDirectoryService;
    private final SpaceService spaceService;
    private final CategoryService categoryService;
    private final SpaceLayoutService spaceLayoutService;
    private final SecuritySettingService securitySettingService;
    private final ImageThumbnailService imageThumbnailService;
    private byte[] defaultSpaceBanner = null;
    private byte[] defaultSpaceAvatar = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public SpaceRest(SpaceService spaceService, SpaceDirectoryService spaceDirectoryService, SpaceLayoutService spaceLayoutService, CategoryService categoryService, IdentityManager identityManager, UploadService uploadService, ImageThumbnailService imageThumbnailService, SecuritySettingService securitySettingService) {
        this.spaceService = spaceService;
        this.spaceDirectoryService = spaceDirectoryService;
        this.spaceLayoutService = spaceLayoutService;
        this.categoryService = categoryService;
        this.identityManager = identityManager;
        this.uploadService = uploadService;
        this.imageThumbnailService = imageThumbnailService;
        this.securitySettingService = securitySettingService;
        CACHE_CONTROL.setMaxAge(604800);
        CACHE_REVALIDATE_CONTROL.setNoCache(true);
    }

    @GET
    @Operation(summary="Gets spaces of user", method="GET", description="This returns a list of spaces switch request parameters")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpaces(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space name search information", required=false) @QueryParam(value="q") String q, @Parameter(description="Filter by Space registration", required=false) @QueryParam(value="registration") SpaceRegistration registration, @Parameter(description="Filter by Space visibility", required=false) @QueryParam(value="visibility") SpaceVisibility visibility, @Parameter(description="Type of spaces to retrieve: all, userSpaces, invited, pending or requests", required=false) @Schema(defaultValue="all") @QueryParam(value="filterType") String filterType, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit, if equals to 0, it will not retrieve spaces", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Space Template identifier, if equals to 0, it will not be used", required=false) @QueryParam(value="templateId") List<Long> templateIds, @Parameter(description="Sort", required=false) @QueryParam(value="sort") String sort, @Parameter(description="Order", required=false) @QueryParam(value="order") String order, @Parameter(description="Returning the number of spaces found or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Returning the favorite spaces of current user not not") @Schema(defaultValue="false") @QueryParam(value="favorites") boolean favorites, @Parameter(description="Tag names used to search spaces", required=true) @QueryParam(value="tags") List<String> tagNames, @Parameter(description="Category Identifier used to filter spaces", required=false) @QueryParam(value="categoryId") List<Long> categoryIds, @Parameter(description="Excluded space ids", required=false) @QueryParam(value="excludedId") List<Long> excludedIds, @Parameter(description="Used to identify targeted Spaces Directory instance to make further ACL checks when anonymously accessed", required=false) @QueryParam(value="token") String token, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) throws Exception {
        EntityTag eTag;
        Response.ResponseBuilder builder;
        if (!RestUtils.canAccessAnonymousResources(this.spaceDirectoryService, token, categoryIds, templateIds)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        int n = limit = limit >= 0 ? limit : RestUtils.getLimit(uriInfo);
        if (StringUtils.isBlank((CharSequence)filterType)) {
            filterType = SPACE_FILTER_TYPE_ALL;
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        ListAccess listAccess = null;
        SpaceFilter spaceFilter = new SpaceFilter();
        if (StringUtils.isNotBlank((CharSequence)q)) {
            spaceFilter.setSpaceNameSearchCondition(StringUtils.trim((String)q));
        }
        spaceFilter.setTagNames(tagNames);
        spaceFilter.setTemplateIds(templateIds);
        spaceFilter.setExcludedIds(excludedIds);
        if (CollectionUtils.isNotEmpty(categoryIds)) {
            spaceFilter.setCategoryIds(categoryIds.stream().filter(id -> this.categoryService.canAccess(id.longValue(), authenticatedUser)).toList());
            if (CollectionUtils.isEmpty((Collection)spaceFilter.getCategoryIds())) {
                CollectionEntity collectionSpace = new CollectionEntity(Collections.emptyList(), "spaces", offset, limit);
                return EntityBuilder.getResponseBuilder(collectionSpace, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK).build();
            }
        }
        spaceFilter.setRegistration(registration);
        spaceFilter.setVisibility(visibility);
        if (StringUtils.isNotBlank((CharSequence)sort)) {
            Sorting.SortBy sortBy = Sorting.SortBy.valueOf((String)sort.toUpperCase());
            Sorting.OrderBy orderBy = Sorting.OrderBy.ASC;
            if (StringUtils.isNotBlank((CharSequence)order)) {
                orderBy = Sorting.OrderBy.valueOf((String)order.toUpperCase());
            }
            spaceFilter.setSorting(new Sorting(sortBy, orderBy));
        }
        spaceFilter.setFavorite(favorites);
        spaceFilter.setIdentityId(RestUtils.getCurrentUserIdentityId());
        if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_ALL, (CharSequence)filterType)) {
            listAccess = this.spaceService.getVisibleSpacesWithListAccess(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_ACCESSIBLE, (CharSequence)filterType)) {
            listAccess = this.spaceService.getAccessibleSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_EDITABLE, (CharSequence)filterType)) {
            listAccess = this.spaceService.getEditableSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_MEMBER, (CharSequence)filterType)) {
            listAccess = this.spaceService.getMemberSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_MANAGER, (CharSequence)filterType)) {
            listAccess = this.spaceService.getManagerSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_PENDING, (CharSequence)filterType)) {
            listAccess = this.spaceService.getPendingSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_INVITED, (CharSequence)filterType)) {
            listAccess = this.spaceService.getInvitedSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_REQUESTS, (CharSequence)filterType)) {
            listAccess = this.spaceService.getPendingSpaceRequestsToManage(authenticatedUser);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_FAVORITE, (CharSequence)filterType)) {
            listAccess = this.spaceService.getFavoriteSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)LAST_VISITED_SPACES, (CharSequence)filterType)) {
            listAccess = this.spaceService.getLastAccessedSpaceByFilter(authenticatedUser, spaceFilter);
        } else {
            return Response.status((int)400).entity((Object)"Unrecognized space filter type").build();
        }
        List<Space> spaces = limit > 0 ? Arrays.asList((Space[])listAccess.load(offset, limit)) : Collections.emptyList();
        CollectionEntity collectionSpace = EntityBuilder.buildEntityFromSpaces(spaces, authenticatedUser, offset, limit, expand, uriInfo);
        if (returnSize) {
            collectionSpace.setSize(listAccess.getSize());
        }
        if ((builder = request.evaluatePreconditions(eTag = new EntityTag(String.valueOf(JsonUtils.toJsonString((Object)collectionSpace).hashCode())))) == null) {
            builder = EntityBuilder.getResponseBuilder(collectionSpace, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
            builder.tag(eTag);
            builder.lastModified(new Date());
            builder.cacheControl(CACHE_REVALIDATE_CONTROL);
        }
        return builder.build();
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a space", method="POST", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response createSpace(@Context UriInfo uriInfo, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Space object to be created, ex:<br />{<br />\"displayName\": \"My space\",<br />\"description\": \"This is my space\",<br />\"groupId\": \"/spaces/my_space\",<br />\"visibility\": \"private\",<br />\"subscription\": \"validation\"<br />}", required=true) SpaceEntity model) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = new Space();
        this.fillSpaceFromModel(space, model);
        space.setEditor(authenticatedUser);
        try {
            space = this.spaceService.createSpace(space, authenticatedUser, model.getInvitedMembers());
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getCode().name()).build());
        }
        this.saveSpaceAvatar(space, model);
        this.saveSpaceBanner(model, space);
        try {
            this.inviteExternalUsers(uriInfo, model, space, authenticatedUser);
        }
        catch (Exception e) {
            LOG.warn("Error while sending external users invitations to space {}", new Object[]{space.getGroupId(), e});
        }
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{spaceId}/checkExternals")
    @RolesAllowed(value={"users"})
    @Operation(summary="Checks if a specific a space contains an external members", method="GET", description="This returns the space if it contains external members")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response isSpaceContainsExternals(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space Id", required=true) @PathParam(value="spaceId") String spaceId) {
        boolean hasExternals;
        if (spaceId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"space Id is mandatory").build();
        }
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"space not found").build();
        }
        try {
            hasExternals = this.spaceService.isSpaceContainsExternals(Long.valueOf(spaceId));
        }
        catch (Exception e) {
            LOG.error("Error while checking external members on space {}", new Object[]{space.getGroupId(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"server internal error occurred").build();
        }
        return Response.ok((Object)String.valueOf(hasExternals)).type("text/plain").build();
    }

    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific space by id", method="GET", description="This returns the space in the following cases: <br/><ul><li>the authenticated user is a member of the space</li><li>the space is \"public\"</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpaceById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) {
        Space space = this.spaceService.getSpaceById(id);
        return this.buildSpaceResponse(space, expand, uriInfo, request);
    }

    @GET
    @Path(value="countByTemplate")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Gets the spaces count by Space Template", method="GET", description="This returns the spaces count by Space template identifier")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response countSpacesByTemplate() {
        return Response.ok((Object)JsonUtils.toJsonString((Object)this.spaceService.countSpacesByTemplate())).build();
    }

    @GET
    @Path(value="byPrettyName/{prettyName}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific space by pretty name", method="GET", description="This returns the space in the following cases: <br/><ul><li>the authenticated user is a member of the space</li><li>the space is \"public\"</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpaceByPrettyName(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space id", required=true) @PathParam(value="prettyName") String prettyName, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) {
        Space space = this.spaceService.getSpaceByPrettyName(prettyName);
        return this.buildSpaceResponse(space, expand, uriInfo, request);
    }

    @GET
    @Path(value="byGroupSuffix/{groupSuffix}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific space by its group id without /spaces/ prefix", method="GET", description="This returns the space in the following cases: <br/><ul><li>the authenticated user is a member of the space</li><li>the space is \"public\"</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpaceByGroupSuffix(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space id", required=true) @PathParam(value="groupSuffix") String groupSuffix, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) {
        Space space = this.spaceService.getSpaceByGroupId("/spaces/" + groupSuffix);
        return this.buildSpaceResponse(space, expand, uriInfo, request);
    }

    @GET
    @Path(value="{id}/avatar")
    @Operation(summary="Gets a space avatar by pretty name", method="GET", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getSpaceAvatarById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @Parameter(description="Space pretty name or space id", required=true) @PathParam(value="id") String id, @Parameter(description="Whether to retrieve avatar by id or pretty name", required=false) @DefaultValue(value="false") @QueryParam(value="byId") boolean byId, @Parameter(description="Resized avatar size. Use 0x0 for original size.") @DefaultValue(value="100x100") @QueryParam(value="size") String size, @Parameter(description="A mandatory valid token that is used to authorize anonymous request", required=false) @QueryParam(value="r") String token) throws IOException {
        boolean isDefault = StringUtils.equals((CharSequence)"default-image", (CharSequence)id);
        Response.ResponseBuilder builder = null;
        Long lastUpdated = null;
        EntityTag eTag = null;
        if (!isDefault) {
            Space space;
            if (RestUtils.isAnonymous() && !LinkProvider.isAttachmentTokenValid((String)token, (String)"space", (String)id, (String)"avatar", (String)lastModified)) {
                LOG.warn("An anonymous user attempts to access avatar of space {} without a valid access token", new Object[]{id});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String authenticatedUser = RestUtils.getCurrentUser();
            Space space2 = space = byId ? this.spaceService.getSpaceById(id) : this.spaceService.getSpaceByPrettyName(id);
            if (space == null || "hidden".equals(space.getVisibility()) && !this.spaceService.canViewSpace(space, authenticatedUser) && !Arrays.asList(space.getInvitedUsers()).contains(authenticatedUser)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Identity identity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            Profile profile = identity.getProfile();
            if (profile != null) {
                lastUpdated = profile.getAvatarLastUpdated();
            }
            if (lastUpdated != null) {
                eTag = new EntityTag(lastUpdated.hashCode() + "-" + size);
            }
            Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
            if (builder == null) {
                int[] dimension = Utils.parseDimension((String)size);
                try {
                    byte[] avatarContent = null;
                    FileItem avatarFile = this.identityManager.getAvatarFile(identity);
                    if (this.identityManager.getAvatarFile(identity) != null) {
                        if (dimension[0] == 0 || dimension[1] == 0) {
                            avatarContent = avatarFile.getAsByte();
                        } else {
                            FileInfo fileInfo = avatarFile.getFileInfo();
                            FileItem file = this.imageThumbnailService.getOrCreateThumbnail("file", Long.toString(fileInfo.getId()), fileInfo.getUpdater(), dimension[0], dimension[1]);
                            byte[] byArray = avatarContent = file != null ? file.getAsByte() : avatarFile.getAsByte();
                        }
                    }
                    if (avatarContent != null) {
                        builder = Response.ok(avatarContent, (String)"image/png");
                    }
                }
                catch (Exception e) {
                    LOG.error("Error while resizing avatar of space identity with Id {}, original Image will be returned", new Object[]{identity.getId(), e});
                }
            }
        }
        if (builder == null) {
            builder = this.getDefaultAvatarBuilder();
        }
        builder.cacheControl(CACHE_CONTROL);
        builder.lastModified(lastUpdated == null ? DEFAULT_IMAGES_LAST_MODIFED : new Date(lastUpdated));
        if (eTag != null) {
            builder.tag(eTag);
        }
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 604800000L));
        }
        return builder.build();
    }

    @GET
    @Path(value="{id}/banner")
    @Operation(summary="Gets a space banner by id", method="GET", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getSpaceBannerById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="Whether to retrieve banner by id or pretty name", required=false) @DefaultValue(value="false") @QueryParam(value="byId") boolean byId, @Parameter(description="A mandatory valid token that is used to authorize anonymous request", required=false) @QueryParam(value="r") String token) throws IOException {
        Response.ResponseBuilder builder;
        boolean isDefault = StringUtils.equals((CharSequence)"default-image", (CharSequence)id);
        Identity identity = null;
        Long lastUpdated = null;
        if (!isDefault && RestUtils.isAnonymous() && !LinkProvider.isAttachmentTokenValid((String)token, (String)"space", (String)id, (String)"banner", (String)lastModified)) {
            LOG.warn("An anonymous user attempts to access banner of space {} without a valid access token", new Object[]{id});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!isDefault) {
            Space space;
            String authenticatedUser = RestUtils.getCurrentUser();
            Space space2 = space = byId ? this.spaceService.getSpaceById(id) : this.spaceService.getSpaceByPrettyName(id);
            if (space == null || "hidden".equals(space.getVisibility()) && !this.spaceService.canViewSpace(space, authenticatedUser)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            identity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            Profile profile = identity.getProfile();
            if (profile != null) {
                lastUpdated = profile.getBannerLastUpdated();
            }
        }
        EntityTag eTag = null;
        if (isDefault) {
            eTag = new EntityTag(String.valueOf(DEFAULT_IMAGES_HASH));
        } else if (lastUpdated != null) {
            eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
        }
        Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
        if (builder == null) {
            if (isDefault) {
                builder = this.getDefaultBannerBuilder();
            } else {
                InputStream stream = this.identityManager.getBannerInputStream(identity);
                if (stream == null) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
                builder = Response.ok((Object)stream, (String)"image/png");
                builder.tag(eTag);
            }
        }
        builder.cacheControl(CACHE_CONTROL);
        builder.lastModified(lastUpdated == null ? DEFAULT_IMAGES_LAST_MODIFED : new Date(lastUpdated));
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 604800000L));
        }
        return builder.build();
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific space by id", method="PUT", description="This updates the space in the following cases: <br/><ul><li>the authenticated user is a manager of the space</li><li>the authenticated user is the owner of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateSpaceById(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Space object to be updated", required=true) SpaceEntity model) throws Exception {
        if (model == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(id);
        if (!this.spaceService.canManageSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (model.getDisplayName() != null && (model.getDisplayName().length() < 3 || model.getDisplayName().length() > 200)) {
            throw new SpaceException(SpaceException.Code.INVALID_SPACE_NAME);
        }
        if (StringUtils.isNotBlank((CharSequence)model.getPublicSiteVisibility())) {
            this.spaceLayoutService.saveSpacePublicSite(id, model.getPublicSiteVisibility(), authenticatedUser);
            space = this.spaceService.getSpaceById(id);
        }
        if (StringUtils.isNotBlank((CharSequence)model.getDisplayName()) && !StringUtils.equals((CharSequence)space.getDisplayName(), (CharSequence)model.getDisplayName())) {
            this.spaceService.renameSpace(space, model.getDisplayName(), authenticatedUser);
        }
        this.inviteExternalUsers(uriInfo, model, space, authenticatedUser);
        this.fillSpaceFromModel(space, model);
        space.setEditor(authenticatedUser);
        space = this.spaceService.updateSpace(space, model.getInvitedMembers());
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a specific space by id", method="DELETE", description="This deletes the space in the following cases: <br/><ul><li>the authenticated user is a manager of the space</li><li>the authenticated user is the owner of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response deleteSpaceById(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(id);
        if (!this.spaceService.canDeleteSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        space.setEditor(authenticatedUser);
        try {
            this.spaceService.deleteSpace(space);
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getCode().name()).build());
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="{id}/users")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets users of a specific space", method="GET", description="This returns a list of users if the authenticated user is a member or manager of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    @Deprecated(forRemoval=true, since="7.0")
    @DeprecatedAPI(value="Use SpaceMembershipRest.getSpacesMemberships instead", insist=true)
    public Response getSpaceMembers(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="User name search information", required=false) @QueryParam(value="q") String q, @Parameter(description="Role of the target user in this space: manager, member, invited and pending", required=false) @Schema(defaultValue="member") @QueryParam(value="role") String role, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of users or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        UriInfo uriInfo2 = uriInfo;
        Request request2 = request;
        String string = id;
        String string2 = q;
        String string3 = role;
        int n = offset;
        int n2 = limit;
        boolean bl = returnSize;
        String string4 = expand;
        Object[] objectArray = new Object[]{uriInfo2, request2, string, string2, string3, Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.booleanObject((boolean)bl), string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, request2, string, string2, string3, Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.booleanObject((boolean)bl), string4, joinPoint};
        SpaceRest$AjcClosure1 spaceRest$AjcClosure1 = new SpaceRest$AjcClosure1(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRest$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}/users/{userId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Checks if the given user is a member of a specific space or not", method="GET", description="This Checks if user is a member of a specific spacer o not.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    @Deprecated(forRemoval=true, since="7.0")
    @DeprecatedAPI(value="Use SpaceMembershipRest.getSpacesMemberships instead", insist=true)
    public Response isSpaceMember(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="User id", required=true) @PathParam(value="userId") String userId) {
        UriInfo uriInfo2 = uriInfo;
        String string = id;
        String string2 = userId;
        Object[] objectArray = new Object[]{uriInfo2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, joinPoint};
        SpaceRest$AjcClosure3 spaceRest$AjcClosure3 = new SpaceRest$AjcClosure3(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRest$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @GET
    @Path(value="{id}/externalInvitations")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets external invitations of a specific space", method="GET", description="This returns a list of external invitations if the authenticated user is a member or manager of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpaceExternalInvitations(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @PathParam(value="id") String id) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(id);
        if (!this.spaceService.canManageSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List spaceExternalInvitations = this.spaceService.findSpaceExternalInvitationsBySpaceId(id);
        return EntityBuilder.getResponseBuilder(spaceExternalInvitations, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK).build();
    }

    @DELETE
    @Path(value="externalInvitations/{invitationId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete a specific external invitation from a specific space", method="DELETE", description="This Delete a specific external invitation from a specific space if the authenticated user is a member or manager of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response declineExternalInvitations(@Context UriInfo uriInfo, @Parameter(description="invitation id", required=true) @PathParam(value="invitationId") String invitationId) {
        SpaceExternalInvitation spaceExternalInvitation = this.spaceService.getSpaceExternalInvitationById(invitationId);
        if (spaceExternalInvitation == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Space space = this.spaceService.getSpaceById(spaceExternalInvitation.getSpaceId());
        if (space == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.spaceService.canManageSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        try {
            this.spaceService.deleteSpaceExternalInvitation(invitationId);
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting invitation", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    private void fillSpaceFromModel(Space space, SpaceEntity model) {
        if (StringUtils.isNotBlank((CharSequence)model.getDisplayName())) {
            space.setDisplayName(model.getDisplayName());
            space.setDescription(model.getDescription());
            if (StringUtils.isBlank((CharSequence)space.getPrettyName())) {
                space.setPrettyName(model.getDisplayName());
            }
        } else if (StringUtils.isNotBlank((CharSequence)model.getPrettyName())) {
            space.setPrettyName(model.getPrettyName());
            space.setDescription(model.getDescription());
            if (StringUtils.isBlank((CharSequence)space.getDisplayName())) {
                space.setDisplayName(model.getPrettyName());
            }
        }
        if (space.getSpaceId() == 0L && model.getTemplateId() > 0L) {
            space.setTemplateId(model.getTemplateId());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getId()) && StringUtils.isNotBlank((CharSequence)model.getBannerId())) {
            this.updateProfileField(space, "banner", model.getBannerId());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getId()) && StringUtils.isNotBlank((CharSequence)model.getAvatarId())) {
            this.updateProfileField(space, "avatar", model.getAvatarId());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"hidden", (CharSequence)model.getVisibility())) {
            space.setVisibility("hidden");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"private", (CharSequence)model.getVisibility())) {
            space.setVisibility("private");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"public", (CharSequence)model.getVisibility())) {
            space.setVisibility("public");
        } else if (StringUtils.isBlank((CharSequence)model.getVisibility()) && space.getId() == null) {
            space.setVisibility("private");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"open", (CharSequence)model.getSubscription())) {
            space.setRegistration("open");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"closed", (CharSequence)model.getSubscription())) {
            space.setRegistration("closed");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"validation", (CharSequence)model.getSubscription())) {
            space.setRegistration("validation");
        } else if (StringUtils.isBlank((CharSequence)model.getSubscription()) && space.getId() == null) {
            space.setRegistration("validation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProfileField(Space space, String name, String value) throws IOException {
        if ("banner".equals(name) && StringUtils.equals((CharSequence)value, (CharSequence)"DEFAULT_BANNER")) {
            space.setBannerAttachment(null);
            this.spaceService.updateSpaceBanner(space, RestUtils.getCurrentUser());
        } else if ("avatar".equals(name) || "banner".equals(name)) {
            UploadResource uploadResource = this.uploadService.getUploadResource(value);
            if (uploadResource == null) {
                throw new IllegalStateException("No uploaded resource found with uploadId = " + value);
            }
            String storeLocation = uploadResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(storeLocation);){
                if ("avatar".equals(name)) {
                    AvatarAttachment attachment = new AvatarAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    space.setAvatarAttachment(attachment);
                    this.spaceService.updateSpaceAvatar(space, RestUtils.getCurrentUser());
                } else {
                    BannerAttachment attachment = new BannerAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    space.setBannerAttachment(attachment);
                    this.spaceService.updateSpaceBanner(space, RestUtils.getCurrentUser());
                }
            }
            finally {
                this.uploadService.removeUploadResource(value);
            }
        }
    }

    private Response.ResponseBuilder getDefaultAvatarBuilder() throws IOException {
        if (this.defaultSpaceAvatar == null) {
            InputStream is = PortalContainer.getInstance().getPortalContext().getResourceAsStream("/skin/images/avatar/DefaultSpaceAvatar.png");
            this.defaultSpaceAvatar = is == null ? new byte[0] : IOUtil.getStreamContentAsBytes((InputStream)is);
        }
        return Response.ok((Object)new ByteArrayInputStream(this.defaultSpaceAvatar), (String)"image/png");
    }

    private Response buildSpaceResponse(Space space, String expand, UriInfo uriInfo, Request request) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (space == null || "hidden".equals(space.getVisibility()) && !this.spaceService.canViewSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        SpaceEntity spaceEntity = EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand);
        EntityBuilder.buildSpaceUnread(spaceEntity, authenticatedUser, expand);
        EntityTag eTag = new EntityTag(String.valueOf(spaceEntity.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            builder = Response.ok((Object)spaceEntity.getDataEntity(), (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date());
            builder.cacheControl(CACHE_REVALIDATE_CONTROL);
        }
        return builder.build();
    }

    private Response.ResponseBuilder getDefaultBannerBuilder() throws IOException {
        if (this.defaultSpaceBanner == null) {
            InputStream is = PortalContainer.getInstance().getPortalContext().getResourceAsStream(PROFILE_DEFAULT_BANNER_URL);
            if (is == null) {
                LOG.warn("Can't find default user banner file in location {}", new Object[]{PROFILE_DEFAULT_BANNER_URL});
                this.defaultSpaceBanner = new byte[0];
            } else {
                this.defaultSpaceBanner = IOUtil.getStreamContentAsBytes((InputStream)is);
            }
        }
        Response.ResponseBuilder builder = Response.ok((Object)new ByteArrayInputStream(this.defaultSpaceBanner), (String)"image/png");
        builder.lastModified(DEFAULT_IMAGES_LAST_MODIFED);
        EntityTag eTag = new EntityTag(String.valueOf(DEFAULT_IMAGES_HASH));
        builder.tag(eTag);
        return builder;
    }

    private void saveSpaceAvatar(Space space, SpaceEntity model) {
        if (StringUtils.isNotBlank((CharSequence)model.getAvatarId())) {
            try {
                this.updateProfileField(space, "avatar", model.getAvatarId());
            }
            catch (IOException e) {
                LOG.warn((Object)"Error adding Space Avatar. Avoid stopping space creation process and continue", (Throwable)e);
            }
        }
    }

    private void saveSpaceBanner(SpaceEntity model, Space space) {
        if (StringUtils.isNotBlank((CharSequence)model.getBannerId())) {
            try {
                this.updateProfileField(space, "banner", model.getBannerId());
            }
            catch (IOException e) {
                LOG.warn((Object)"Error adding Space Banner. Avoid stopping space creation process and continue", (Throwable)e);
            }
        }
    }

    private boolean inviteExternalUsers(UriInfo uriInfo, SpaceEntity model, Space space, String authenticatedUser) throws Exception {
        int errorsCount = 0;
        if (model.getExternalInvitedUsers() != null && (this.securitySettingService.getRegistrationType() == UserRegistrationType.OPEN || this.securitySettingService.isRegistrationExternalUser())) {
            String uri = uriInfo.getBaseUri().toString().substring(0, uriInfo.getBaseUri().toString().lastIndexOf("/"));
            StringBuilder url = new StringBuilder(uri);
            PasswordRecoveryService passwordRecoveryService = (PasswordRecoveryService)CommonsUtils.getService(PasswordRecoveryService.class);
            LocaleConfigService localeConfigService = (LocaleConfigService)CommonsUtils.getService(LocaleConfigService.class);
            Locale locale = null;
            try {
                String defaultLanguage = localeConfigService.getDefaultLocaleConfig().getLocale().toLanguageTag();
                locale = LocaleUtils.toLocale((String)defaultLanguage);
            }
            catch (Exception e) {
                LOG.error((Object)"Failure to retrieve portal config", (Throwable)e);
            }
            for (String externalInvitedUser : model.getExternalInvitedUsers()) {
                try {
                    String tokenId = passwordRecoveryService.sendExternalRegisterEmail(authenticatedUser, externalInvitedUser, locale, space.getDisplayName(), url);
                    this.spaceService.saveSpaceExternalInvitation(space.getId(), externalInvitedUser, tokenId);
                }
                catch (Exception e) {
                    LOG.warn("Error while sending external invitation to user {}", new Object[]{externalInvitedUser, e});
                    ++errorsCount;
                }
            }
        }
        return errorsCount == 0;
    }

    static {
        SpaceRest.ajc$preClinit();
        LOG = ExoLogger.getLogger(SpaceRest.class);
        CACHE_CONTROL = new CacheControl();
        CACHE_REVALIDATE_CONTROL = new CacheControl();
        DEFAULT_IMAGES_LAST_MODIFED = new Date();
        DEFAULT_IMAGES_HASH = DEFAULT_IMAGES_LAST_MODIFED.getTime();
    }

    static final /* synthetic */ Response getSpaceMembers_aroundBody0(SpaceRest ajc$this, UriInfo uriInfo, Request request, String id, String q, String role, int offset, int limit, boolean returnSize, String expand, JoinPoint joinPoint) {
        EntityTag eTag;
        Response.ResponseBuilder builder;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = ajc$this.spaceService.getSpaceById(id);
        if (!ajc$this.spaceService.canViewSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (StringUtils.isBlank((CharSequence)role)) {
            role = SpaceMemberFilterListAccess.Type.MEMBER.name();
        }
        SpaceMemberFilterListAccess.Type type = SpaceMemberFilterListAccess.Type.valueOf((String)role.toUpperCase());
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setName(q);
        ListAccess spaceIdentitiesListAccess = ajc$this.identityManager.getSpaceIdentityByProfileFilter(space, profileFilter, type, true);
        Identity[] spaceIdentities = (Identity[])spaceIdentitiesListAccess.load(offset, limit);
        List<Object> profileInfos = null;
        profileInfos = spaceIdentities == null || spaceIdentities.length == 0 ? Collections.emptyList() : Arrays.stream(spaceIdentities).map(identity -> EntityBuilder.buildEntityProfile(space, identity.getProfile(), uriInfo.getPath(), expand).getDataEntity()).toList();
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (returnSize) {
            collectionUser.setSize(spaceIdentitiesListAccess.getSize());
        }
        if ((builder = request.evaluatePreconditions(eTag = new EntityTag(String.valueOf(JsonUtils.toJsonString((Object)collectionUser).hashCode())))) == null) {
            builder = Response.ok((Object)collectionUser, (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date());
            builder.expires(Date.from(Instant.now().plus(7L, ChronoUnit.DAYS)));
        }
        return builder.build();
    }

    static final /* synthetic */ Response isSpaceMember_aroundBody2(SpaceRest ajc$this, UriInfo uriInfo, String id, String userId, JoinPoint joinPoint) {
        Space space = ajc$this.spaceService.getSpaceById(id);
        if (space == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        boolean isMember = ajc$this.spaceService.isMember(space, userId);
        return Response.ok().entity((Object)("{\"isMember\":\"" + isMember + "\"}")).build();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceRest.java", SpaceRest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceMembers", "org.exoplatform.social.rest.impl.space.SpaceRest", "javax.ws.rs.core.UriInfo:javax.ws.rs.core.Request:java.lang.String:java.lang.String:java.lang.String:int:int:boolean:java.lang.String", "uriInfo:request:id:q:role:offset:limit:returnSize:expand", "java.lang.Exception", "javax.ws.rs.core.Response"), 851);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSpaceMember", "org.exoplatform.social.rest.impl.space.SpaceRest", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String", "uriInfo:id:userId", "", "javax.ws.rs.core.Response"), 924);
    }
}

