/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.CompletionContext;
import org.springframework.data.elasticsearch.annotations.CompletionField;
import org.springframework.data.elasticsearch.annotations.Dynamic;
import org.springframework.data.elasticsearch.annotations.DynamicTemplates;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;
import org.springframework.data.elasticsearch.annotations.GeoShapeField;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.JoinTypeRelation;
import org.springframework.data.elasticsearch.annotations.JoinTypeRelations;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.MappingAlias;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.core.ResourceUtil;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.GeoShapeMappingParameters;
import org.springframework.data.elasticsearch.core.index.MappingParameters;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class MappingBuilder {
    private static final Log LOGGER = LogFactory.getLog(MappingBuilder.class);
    private static final String FIELD_INDEX = "index";
    private static final String FIELD_PROPERTIES = "properties";
    private static final String FIELD_CONTEXT_NAME = "name";
    private static final String FIELD_CONTEXT_TYPE = "type";
    private static final String FIELD_CONTEXT_PATH = "path";
    private static final String FIELD_CONTEXT_PRECISION = "precision";
    private static final String FIELD_DYNAMIC_TEMPLATES = "dynamic_templates";
    private static final String FIELD_INCLUDE_IN_PARENT = "include_in_parent";
    private static final String COMPLETION_PRESERVE_SEPARATORS = "preserve_separators";
    private static final String COMPLETION_PRESERVE_POSITION_INCREMENTS = "preserve_position_increments";
    private static final String COMPLETION_MAX_INPUT_LENGTH = "max_input_length";
    private static final String COMPLETION_CONTEXTS = "contexts";
    private static final String TYPEHINT_PROPERTY = "_class";
    private static final String TYPE_DYNAMIC = "dynamic";
    private static final String TYPE_VALUE_KEYWORD = "keyword";
    private static final String TYPE_VALUE_GEO_POINT = "geo_point";
    private static final String TYPE_VALUE_GEO_SHAPE = "geo_shape";
    private static final String TYPE_VALUE_JOIN = "join";
    private static final String TYPE_VALUE_COMPLETION = "completion";
    private static final String JOIN_TYPE_RELATIONS = "relations";
    private static final String MAPPING_ENABLED = "enabled";
    private static final String DATE_DETECTION = "date_detection";
    private static final String NUMERIC_DETECTION = "numeric_detection";
    private static final String DYNAMIC_DATE_FORMATS = "dynamic_date_formats";
    private static final String RUNTIME = "runtime";
    private static final String SOURCE = "_source";
    private static final String SOURCE_EXCLUDES = "excludes";
    protected final ElasticsearchConverter elasticsearchConverter;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public MappingBuilder(ElasticsearchConverter elasticsearchConverter) {
        this.elasticsearchConverter = elasticsearchConverter;
    }

    public String buildPropertyMapping(Class<?> clazz) throws MappingException {
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
        return this.buildPropertyMapping(entity, this.getRuntimeFields(entity));
    }

    protected String buildPropertyMapping(ElasticsearchPersistentEntity<?> entity, @Nullable Document runtimeFields) {
        InternalBuilder internalBuilder = new InternalBuilder();
        return internalBuilder.buildPropertyMapping(entity, runtimeFields);
    }

    @Nullable
    private Document getRuntimeFields(@Nullable ElasticsearchPersistentEntity<?> entity) {
        String runtimeFieldsPath;
        Mapping mappingAnnotation;
        if (entity != null && (mappingAnnotation = (Mapping)entity.findAnnotation(Mapping.class)) != null && StringUtils.hasText((String)(runtimeFieldsPath = mappingAnnotation.runtimeFieldsPath()))) {
            String jsonString = ResourceUtil.readFileFromClasspath(runtimeFieldsPath);
            return Document.parse(jsonString);
        }
        return null;
    }

    private class InternalBuilder {
        private boolean writeTypeHints = true;
        private final List<String> excludeFromSource = new ArrayList<String>();
        private String nestedPropertyPrefix = "";

        private InternalBuilder() {
        }

        protected String buildPropertyMapping(ElasticsearchPersistentEntity<?> entity, @Nullable Document runtimeFields) {
            try {
                this.writeTypeHints = entity.writeTypeHints();
                ObjectNode objectNode = MappingBuilder.this.objectMapper.createObjectNode();
                this.addDynamicTemplatesMapping(objectNode, entity);
                org.springframework.data.elasticsearch.annotations.Document docAnnotation = (org.springframework.data.elasticsearch.annotations.Document)entity.findAnnotation(org.springframework.data.elasticsearch.annotations.Document.class);
                Dynamic dynamicMapping = docAnnotation != null ? docAnnotation.dynamic() : null;
                this.mapEntity(objectNode, entity, true, "", false, FieldType.Auto, null, dynamicMapping, runtimeFields);
                if (!this.excludeFromSource.isEmpty()) {
                    ObjectNode sourceNode = objectNode.putObject(MappingBuilder.SOURCE);
                    ArrayNode excludes = sourceNode.putArray(MappingBuilder.SOURCE_EXCLUDES);
                    this.excludeFromSource.stream().map(TextNode::new).forEach(arg_0 -> ((ArrayNode)excludes).add(arg_0));
                }
                return MappingBuilder.this.objectMapper.writer().writeValueAsString((Object)objectNode);
            }
            catch (IOException e) {
                throw new MappingException("could not build mapping", (Throwable)e);
            }
        }

        private void writeTypeHintMapping(ObjectNode propertiesNode) throws IOException {
            if (this.writeTypeHints) {
                String typeHintProperty = null;
                ElasticsearchConverter elasticsearchConverter = MappingBuilder.this.elasticsearchConverter;
                if (elasticsearchConverter instanceof MappingElasticsearchConverter) {
                    MappingElasticsearchConverter mappingElasticsearchConverter = (MappingElasticsearchConverter)elasticsearchConverter;
                    typeHintProperty = mappingElasticsearchConverter.getTypeMapper().getTypeKey();
                }
                if (typeHintProperty == null) {
                    typeHintProperty = MappingBuilder.TYPEHINT_PROPERTY;
                }
                propertiesNode.set(typeHintProperty, (JsonNode)MappingBuilder.this.objectMapper.createObjectNode().put(MappingBuilder.FIELD_CONTEXT_TYPE, MappingBuilder.TYPE_VALUE_KEYWORD).put(MappingBuilder.FIELD_INDEX, false).put("doc_values", false));
            }
        }

        private void mapEntity(ObjectNode objectNode, @Nullable ElasticsearchPersistentEntity<?> entity, boolean isRootObject, String nestedObjectFieldName, boolean nestedOrObjectField, FieldType fieldType, @Nullable Field parentFieldAnnotation, @Nullable Dynamic dynamicMapping, @Nullable Document runtimeFields) throws IOException {
            boolean writeNestedProperties;
            Mapping mappingAnnotation;
            Mapping mapping = mappingAnnotation = entity != null ? (Mapping)entity.findAnnotation(Mapping.class) : null;
            if (mappingAnnotation != null) {
                if (!mappingAnnotation.enabled()) {
                    objectNode.put(MappingBuilder.MAPPING_ENABLED, false);
                    return;
                }
                if (mappingAnnotation.dateDetection() != Mapping.Detection.DEFAULT) {
                    objectNode.put(MappingBuilder.DATE_DETECTION, Boolean.parseBoolean(mappingAnnotation.dateDetection().name()));
                }
                if (mappingAnnotation.numericDetection() != Mapping.Detection.DEFAULT) {
                    objectNode.put(MappingBuilder.NUMERIC_DETECTION, Boolean.parseBoolean(mappingAnnotation.numericDetection().name()));
                }
                if (mappingAnnotation.dynamicDateFormats().length > 0) {
                    objectNode.putArray(MappingBuilder.DYNAMIC_DATE_FORMATS).addAll((Collection)Arrays.stream(mappingAnnotation.dynamicDateFormats()).map(TextNode::valueOf).collect(Collectors.toList()));
                }
                if (runtimeFields != null) {
                    objectNode.set(MappingBuilder.RUNTIME, (JsonNode)MappingBuilder.this.objectMapper.convertValue((Object)runtimeFields, JsonNode.class));
                }
            }
            boolean bl = writeNestedProperties = !isRootObject && (this.isAnyPropertyAnnotatedWithField(entity) || nestedOrObjectField);
            if (writeNestedProperties) {
                String type = nestedOrObjectField ? fieldType.getMappedName() : FieldType.Object.getMappedName();
                ObjectNode nestedObjectNode = MappingBuilder.this.objectMapper.createObjectNode();
                nestedObjectNode.put(MappingBuilder.FIELD_CONTEXT_TYPE, type);
                if (nestedOrObjectField && FieldType.Nested == fieldType && parentFieldAnnotation != null && parentFieldAnnotation.includeInParent()) {
                    nestedObjectNode.put(MappingBuilder.FIELD_INCLUDE_IN_PARENT, true);
                }
                objectNode.set(nestedObjectFieldName, (JsonNode)nestedObjectNode);
                objectNode = nestedObjectNode;
            }
            if (entity != null && entity.dynamic() != Dynamic.INHERIT) {
                objectNode.put(MappingBuilder.TYPE_DYNAMIC, entity.dynamic().getMappedName());
            } else if (dynamicMapping != null && dynamicMapping != Dynamic.INHERIT) {
                objectNode.put(MappingBuilder.TYPE_DYNAMIC, dynamicMapping.getMappedName());
            }
            ObjectNode propertiesNode = objectNode.putObject(MappingBuilder.FIELD_PROPERTIES);
            this.writeTypeHintMapping(propertiesNode);
            if (entity != null) {
                entity.doWithProperties(property -> {
                    try {
                        if (property.isAnnotationPresent(Transient.class) || this.isInIgnoreFields((ElasticsearchPersistentProperty)property, parentFieldAnnotation)) {
                            return;
                        }
                        if (property.isSeqNoPrimaryTermProperty()) {
                            if (property.isAnnotationPresent(Field.class)) {
                                LOGGER.warn((Object)String.format("Property %s of %s is annotated for inclusion in mapping, but its type is SeqNoPrimaryTerm that is never mapped, so it is skipped", property.getFieldName(), entity.getType()));
                            }
                            return;
                        }
                        this.buildPropertyMapping(propertiesNode, isRootObject, (ElasticsearchPersistentProperty)property);
                    }
                    catch (IOException e) {
                        LOGGER.warn((Object)String.format("error mapping property with name %s", property.getName()), (Throwable)e);
                    }
                });
            }
            if (mappingAnnotation != null) {
                for (MappingAlias mappingAlias : mappingAnnotation.aliases()) {
                    ObjectNode aliasNode = propertiesNode.putObject(mappingAlias.name());
                    aliasNode.put(MappingBuilder.FIELD_CONTEXT_TYPE, "alias");
                    aliasNode.put(MappingBuilder.FIELD_CONTEXT_PATH, mappingAlias.path());
                }
            }
        }

        private void buildPropertyMapping(ObjectNode propertiesNode, boolean isRootObject, ElasticsearchPersistentProperty property) throws IOException {
            Dynamic dynamicMapping;
            if (property.isAnnotationPresent(Mapping.class)) {
                Mapping mapping = (Mapping)property.getRequiredAnnotation(Mapping.class);
                if (mapping.enabled()) {
                    ClassPathResource mappings;
                    String mappingPath = mapping.mappingPath();
                    if (StringUtils.hasText((String)mappingPath) && (mappings = new ClassPathResource(mappingPath)).exists()) {
                        propertiesNode.putRawValue(property.getFieldName(), new RawValue(StreamUtils.copyToString((InputStream)mappings.getInputStream(), (Charset)Charset.defaultCharset())));
                        return;
                    }
                } else {
                    this.applyDisabledPropertyMapping(propertiesNode, property);
                    return;
                }
            }
            if (property.isGeoPointProperty()) {
                this.applyGeoPointFieldMapping(propertiesNode, property);
                return;
            }
            if (property.isGeoShapeProperty()) {
                this.applyGeoShapeMapping(propertiesNode, property);
            }
            if (property.isJoinFieldProperty()) {
                this.addJoinFieldMapping(propertiesNode, property);
            }
            String nestedPropertyPath = this.nestedPropertyPrefix.isEmpty() ? property.getFieldName() : this.nestedPropertyPrefix + "." + property.getFieldName();
            Field fieldAnnotation = (Field)property.findAnnotation(Field.class);
            MultiField multiFieldAnnotation = (MultiField)property.findAnnotation(MultiField.class);
            if (fieldAnnotation != null && fieldAnnotation.excludeFromSource() || multiFieldAnnotation != null && multiFieldAnnotation.mainField().excludeFromSource()) {
                this.excludeFromSource.add(nestedPropertyPath);
            }
            boolean isCompletionProperty = property.isCompletionProperty();
            boolean isNestedOrObjectProperty = this.isNestedOrObjectProperty(property);
            Dynamic dynamic = dynamicMapping = fieldAnnotation != null ? fieldAnnotation.dynamic() : null;
            if (!isCompletionProperty && property.isEntity() && this.hasRelevantAnnotation(property)) {
                if (fieldAnnotation == null) {
                    return;
                }
                if (isNestedOrObjectProperty) {
                    Iterator iterator = property.getPersistentEntityTypeInformation().iterator();
                    ElasticsearchPersistentEntity persistentEntity = iterator.hasNext() ? (ElasticsearchPersistentEntity)MappingBuilder.this.elasticsearchConverter.getMappingContext().getPersistentEntity((TypeInformation)iterator.next()) : null;
                    String currentNestedPropertyPrefix = this.nestedPropertyPrefix;
                    this.nestedPropertyPrefix = nestedPropertyPath;
                    this.mapEntity(propertiesNode, persistentEntity, false, property.getFieldName(), true, fieldAnnotation.type(), fieldAnnotation, dynamicMapping, null);
                    this.nestedPropertyPrefix = currentNestedPropertyPrefix;
                    return;
                }
            }
            if (isCompletionProperty) {
                CompletionField completionField = (CompletionField)property.findAnnotation(CompletionField.class);
                this.applyCompletionFieldMapping(propertiesNode, property, completionField);
            }
            if (isRootObject && fieldAnnotation != null && property.isIdProperty()) {
                this.applyDefaultIdFieldMapping(propertiesNode, property);
            } else if (multiFieldAnnotation != null) {
                this.addMultiFieldMapping(propertiesNode, property, multiFieldAnnotation, isNestedOrObjectProperty, dynamicMapping);
            } else if (fieldAnnotation != null) {
                this.addSingleFieldMapping(propertiesNode, property, fieldAnnotation, isNestedOrObjectProperty, dynamicMapping);
            }
        }

        private boolean hasRelevantAnnotation(ElasticsearchPersistentProperty property) {
            return property.findAnnotation(Field.class) != null || property.findAnnotation(MultiField.class) != null || property.findAnnotation(GeoPointField.class) != null || property.findAnnotation(CompletionField.class) != null;
        }

        private void applyGeoPointFieldMapping(ObjectNode propertiesNode, ElasticsearchPersistentProperty property) throws IOException {
            propertiesNode.set(property.getFieldName(), (JsonNode)MappingBuilder.this.objectMapper.createObjectNode().put(MappingBuilder.FIELD_CONTEXT_TYPE, MappingBuilder.TYPE_VALUE_GEO_POINT));
        }

        private void applyGeoShapeMapping(ObjectNode propertiesNode, ElasticsearchPersistentProperty property) throws IOException {
            ObjectNode shapeNode = propertiesNode.putObject(property.getFieldName());
            GeoShapeMappingParameters mappingParameters = GeoShapeMappingParameters.from((GeoShapeField)property.findAnnotation(GeoShapeField.class));
            mappingParameters.writeTypeAndParametersTo(shapeNode);
        }

        private void applyCompletionFieldMapping(ObjectNode propertyNode, ElasticsearchPersistentProperty property, @Nullable CompletionField annotation) throws IOException {
            ObjectNode completionNode = propertyNode.putObject(property.getFieldName());
            completionNode.put(MappingBuilder.FIELD_CONTEXT_TYPE, MappingBuilder.TYPE_VALUE_COMPLETION);
            if (annotation != null) {
                completionNode.put(MappingBuilder.COMPLETION_MAX_INPUT_LENGTH, annotation.maxInputLength());
                completionNode.put(MappingBuilder.COMPLETION_PRESERVE_POSITION_INCREMENTS, annotation.preservePositionIncrements());
                completionNode.put(MappingBuilder.COMPLETION_PRESERVE_SEPARATORS, annotation.preserveSeparators());
                if (StringUtils.hasLength((String)annotation.searchAnalyzer())) {
                    completionNode.put("search_analyzer", annotation.searchAnalyzer());
                }
                if (StringUtils.hasLength((String)annotation.analyzer())) {
                    completionNode.put("analyzer", annotation.analyzer());
                }
                if (annotation.contexts().length > 0) {
                    ArrayNode contextsNode = completionNode.putArray(MappingBuilder.COMPLETION_CONTEXTS);
                    for (CompletionContext context : annotation.contexts()) {
                        ObjectNode contextNode = contextsNode.addObject();
                        contextNode.put(MappingBuilder.FIELD_CONTEXT_NAME, context.name());
                        contextNode.put(MappingBuilder.FIELD_CONTEXT_TYPE, context.type().getMappedName());
                        if (!context.precision().isEmpty()) {
                            contextNode.put(MappingBuilder.FIELD_CONTEXT_PRECISION, context.precision());
                        }
                        if (!StringUtils.hasText((String)context.path())) continue;
                        contextNode.put(MappingBuilder.FIELD_CONTEXT_PATH, context.path());
                    }
                }
            }
        }

        private void applyDefaultIdFieldMapping(ObjectNode propertyNode, ElasticsearchPersistentProperty property) throws IOException {
            propertyNode.set(property.getFieldName(), (JsonNode)MappingBuilder.this.objectMapper.createObjectNode().put(MappingBuilder.FIELD_CONTEXT_TYPE, MappingBuilder.TYPE_VALUE_KEYWORD).put(MappingBuilder.FIELD_INDEX, true));
        }

        private void applyDisabledPropertyMapping(ObjectNode propertiesNode, ElasticsearchPersistentProperty property) {
            try {
                Field field = (Field)property.getRequiredAnnotation(Field.class);
                if (field.type() != FieldType.Object) {
                    throw new IllegalArgumentException("Field type must be 'object");
                }
                propertiesNode.set(property.getFieldName(), (JsonNode)MappingBuilder.this.objectMapper.createObjectNode().put(MappingBuilder.FIELD_CONTEXT_TYPE, field.type().getMappedName()).put(MappingBuilder.MAPPING_ENABLED, false));
            }
            catch (Exception e) {
                throw new MappingException("Could not write enabled: false mapping for " + property.getFieldName(), (Throwable)e);
            }
        }

        private void addSingleFieldMapping(ObjectNode propertiesNode, ElasticsearchPersistentProperty property, Field annotation, boolean nestedOrObjectField, @Nullable Dynamic dynamicMapping) throws IOException {
            ObjectNode fieldNode = MappingBuilder.this.objectMapper.createObjectNode();
            this.addFieldMappingParameters(fieldNode, annotation, nestedOrObjectField);
            if (fieldNode.isEmpty()) {
                return;
            }
            propertiesNode.set(property.getFieldName(), (JsonNode)fieldNode);
            if (nestedOrObjectField) {
                if (annotation.dynamic() != Dynamic.INHERIT) {
                    fieldNode.put(MappingBuilder.TYPE_DYNAMIC, annotation.dynamic().getMappedName());
                } else if (dynamicMapping != null && dynamicMapping != Dynamic.INHERIT) {
                    fieldNode.put(MappingBuilder.TYPE_DYNAMIC, dynamicMapping.getMappedName());
                }
            }
        }

        private void addJoinFieldMapping(ObjectNode propertiesNode, ElasticsearchPersistentProperty property) throws IOException {
            JoinTypeRelation[] joinTypeRelations = ((JoinTypeRelations)property.getRequiredAnnotation(JoinTypeRelations.class)).relations();
            if (joinTypeRelations.length == 0) {
                LOGGER.warn((Object)String.format("Property %s's type is JoinField but its annotation JoinTypeRelation is not properly maintained", property.getFieldName()));
                return;
            }
            ObjectNode propertyNode = propertiesNode.putObject(property.getFieldName());
            propertyNode.put(MappingBuilder.FIELD_CONTEXT_TYPE, MappingBuilder.TYPE_VALUE_JOIN);
            ObjectNode relationsNode = propertyNode.putObject(MappingBuilder.JOIN_TYPE_RELATIONS);
            for (JoinTypeRelation joinTypeRelation : joinTypeRelations) {
                String parent = joinTypeRelation.parent();
                String[] children = joinTypeRelation.children();
                if (children.length > 1) {
                    relationsNode.putArray(parent).addAll((Collection)Arrays.stream(children).map(TextNode::valueOf).collect(Collectors.toList()));
                    continue;
                }
                if (children.length != 1) continue;
                relationsNode.put(parent, children[0]);
            }
        }

        private void addMultiFieldMapping(ObjectNode propertyNode, ElasticsearchPersistentProperty property, MultiField annotation, boolean nestedOrObjectField, @Nullable Dynamic dynamicMapping) throws IOException {
            ObjectNode mainFieldNode = MappingBuilder.this.objectMapper.createObjectNode();
            propertyNode.set(property.getFieldName(), (JsonNode)mainFieldNode);
            if (nestedOrObjectField) {
                if (annotation.mainField().dynamic() != Dynamic.INHERIT) {
                    mainFieldNode.put(MappingBuilder.TYPE_DYNAMIC, annotation.mainField().dynamic().getMappedName());
                } else if (dynamicMapping != null && dynamicMapping != Dynamic.INHERIT) {
                    mainFieldNode.put(MappingBuilder.TYPE_DYNAMIC, dynamicMapping.getMappedName());
                }
            }
            this.addFieldMappingParameters(mainFieldNode, annotation.mainField(), nestedOrObjectField);
            ObjectNode innerFieldsNode = mainFieldNode.putObject("fields");
            for (InnerField innerField : annotation.otherFields()) {
                ObjectNode innerFieldNode = innerFieldsNode.putObject(innerField.suffix());
                this.addFieldMappingParameters(innerFieldNode, innerField, false);
            }
        }

        private void addFieldMappingParameters(ObjectNode fieldNode, Annotation annotation, boolean nestedOrObjectField) throws IOException {
            MappingParameters mappingParameters = MappingParameters.from(annotation);
            if (!nestedOrObjectField && mappingParameters.isStore()) {
                fieldNode.put("store", true);
            }
            mappingParameters.writeTypeAndParametersTo(fieldNode);
        }

        private void addDynamicTemplatesMapping(ObjectNode objectNode, ElasticsearchPersistentEntity<?> entity) throws IOException {
            JsonNode jsonNode;
            String jsonString;
            String mappingPath;
            if (entity.isAnnotationPresent(DynamicTemplates.class) && StringUtils.hasText((String)(mappingPath = ((DynamicTemplates)entity.getRequiredAnnotation(DynamicTemplates.class)).mappingPath())) && StringUtils.hasText((String)(jsonString = ResourceUtil.readFileFromClasspath(mappingPath))) && (jsonNode = MappingBuilder.this.objectMapper.readTree(jsonString).get(MappingBuilder.FIELD_DYNAMIC_TEMPLATES)) != null && jsonNode.isArray()) {
                objectNode.set(MappingBuilder.FIELD_DYNAMIC_TEMPLATES, jsonNode);
            }
        }

        private boolean isAnyPropertyAnnotatedWithField(@Nullable ElasticsearchPersistentEntity<?> entity) {
            return entity != null && entity.getPersistentProperty(Field.class) != null;
        }

        private boolean isInIgnoreFields(ElasticsearchPersistentProperty property, @Nullable Field parentFieldAnnotation) {
            if (null != parentFieldAnnotation) {
                String[] ignoreFields = parentFieldAnnotation.ignoreFields();
                return Arrays.asList(ignoreFields).contains(property.getFieldName());
            }
            return false;
        }

        private boolean isNestedOrObjectProperty(ElasticsearchPersistentProperty property) {
            Field fieldAnnotation = (Field)property.findAnnotation(Field.class);
            return fieldAnnotation != null && (FieldType.Nested == fieldAnnotation.type() || FieldType.Object == fieldAnnotation.type());
        }
    }
}

