/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TermsPartition
implements JsonpSerializable {
    private final long numPartitions;
    private final long partition;
    public static final JsonpDeserializer<TermsPartition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsPartition::setupTermsPartitionDeserializer);

    private TermsPartition(Builder builder) {
        this.numPartitions = ApiTypeHelper.requireNonNull(builder.numPartitions, this, "numPartitions");
        this.partition = ApiTypeHelper.requireNonNull(builder.partition, this, "partition");
    }

    public static TermsPartition of(Function<Builder, ObjectBuilder<TermsPartition>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long numPartitions() {
        return this.numPartitions;
    }

    public final long partition() {
        return this.partition;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("num_partitions");
        generator.write(this.numPartitions);
        generator.writeKey("partition");
        generator.write(this.partition);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTermsPartitionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numPartitions, JsonpDeserializer.longDeserializer(), "num_partitions");
        op.add(Builder::partition, JsonpDeserializer.longDeserializer(), "partition");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TermsPartition> {
        private Long numPartitions;
        private Long partition;

        public final Builder numPartitions(long value) {
            this.numPartitions = value;
            return this;
        }

        public final Builder partition(long value) {
            this.partition = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermsPartition build() {
            this._checkSingleUse();
            return new TermsPartition(this);
        }
    }
}

