/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.plugin;

import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.service.ApplicationCenterService;
import io.meeds.social.category.plugin.CategoryPlugin;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApplicationCategoryPlugin
implements CategoryPlugin {
    public static final String OBJECT_TYPE = "appCenter";
    @Autowired
    private PortalContainer portalContainer;
    private ApplicationCenterService applicationCenterService;

    public String getType() {
        return OBJECT_TYPE;
    }

    public boolean canAccess(String applicationId, String username) {
        Application application = this.getApplicationCenterService().getApplication(Long.parseLong(applicationId));
        return application != null && (application.isActive() && this.getApplicationCenterService().canAccess(application, username) || this.canEdit(applicationId, username));
    }

    public boolean canEdit(String applicationId, String username) {
        return this.getApplicationCenterService().canEdit(username);
    }

    public List<Long> getCategoryIds() {
        return this.getApplicationCenterService().getCategoryIds();
    }

    private ApplicationCenterService getApplicationCenterService() {
        if (this.applicationCenterService == null) {
            this.applicationCenterService = (ApplicationCenterService)this.portalContainer.getComponentInstanceOfType(ApplicationCenterService.class);
        }
        return this.applicationCenterService;
    }
}

