/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.synonyms;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.synonyms.PutSynonymResponse;
import co.elastic.clients.elasticsearch.synonyms.SynonymRule;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class PutSynonymRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    private final List<SynonymRule> synonymsSet;
    public static final JsonpDeserializer<PutSynonymRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutSynonymRequest::setupPutSynonymRequestDeserializer);
    public static final Endpoint<PutSynonymRequest, PutSynonymResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutSynonymRequest, PutSynonymResponse>("es/synonyms.put_synonym", request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_synonyms");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("id", request.id);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutSynonymResponse._DESERIALIZER);

    private PutSynonymRequest(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.synonymsSet = ApiTypeHelper.unmodifiableRequired(builder.synonymsSet, (Object)this, "synonymsSet");
    }

    public static PutSynonymRequest of(Function<Builder, ObjectBuilder<PutSynonymRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final List<SynonymRule> synonymsSet() {
        return this.synonymsSet;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.synonymsSet)) {
            generator.writeKey("synonyms_set");
            generator.writeStartArray();
            for (SynonymRule item0 : this.synonymsSet) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutSynonymRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::synonymsSet, JsonpDeserializer.arrayDeserializer(SynonymRule._DESERIALIZER), "synonyms_set");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutSynonymRequest> {
        private String id;
        private List<SynonymRule> synonymsSet;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder synonymsSet(List<SynonymRule> list) {
            this.synonymsSet = Builder._listAddAll(this.synonymsSet, list);
            return this;
        }

        public final Builder synonymsSet(SynonymRule value, SynonymRule ... values) {
            this.synonymsSet = Builder._listAdd(this.synonymsSet, value, values);
            return this;
        }

        public final Builder synonymsSet(Function<SynonymRule.Builder, ObjectBuilder<SynonymRule>> fn) {
            return this.synonymsSet(fn.apply(new SynonymRule.Builder()).build(), new SynonymRule[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutSynonymRequest build() {
            this._checkSingleUse();
            return new PutSynonymRequest(this);
        }
    }
}

