/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.service;

import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.reward.service.RewardSettingsService;
import io.meeds.wallet.utils.RewardUtils;
import io.meeds.wallet.utils.WalletUtils;
import java.util.Objects;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WalletRewardSettingsService
implements RewardSettingsService {
    public static final String REWARD_SETTINGS_UPDATED = "reward.settings.updated";
    @Autowired
    private SettingService settingService;
    @Autowired
    private ListenerService listenerService;
    private RewardSettings configuredRewardSettings;

    public RewardSettings getSettings() {
        RewardSettings rewardSettings;
        String settingsValueString;
        if (this.configuredRewardSettings != null) {
            return this.configuredRewardSettings.clone();
        }
        SettingValue settingsValue = this.settingService.get(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_SETTINGS");
        String string = settingsValueString = settingsValue == null || settingsValue.getValue() == null ? null : settingsValue.getValue().toString();
        if (settingsValueString == null) {
            rewardSettings = new RewardSettings();
            rewardSettings.setStoredSetting(false);
        } else {
            rewardSettings = (RewardSettings)WalletUtils.fromJsonString((String)settingsValueString, RewardSettings.class);
            Objects.requireNonNull(rewardSettings).setStoredSetting(true);
        }
        this.configuredRewardSettings = rewardSettings;
        return this.configuredRewardSettings;
    }

    public void saveSettings(RewardSettings rewardSettingsToStore) {
        if (rewardSettingsToStore == null) {
            throw new IllegalArgumentException("Empty settings to save");
        }
        String settingsString = WalletUtils.toJsonString((Object)rewardSettingsToStore);
        this.settingService.set(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_SETTINGS", SettingValue.create((String)settingsString));
        this.configuredRewardSettings = null;
        this.listenerService.broadcast(REWARD_SETTINGS_UPDATED, (Object)this, null);
    }

    public void deleteSettings() {
        this.settingService.remove(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_SETTINGS");
        this.configuredRewardSettings = null;
        this.listenerService.broadcast(REWARD_SETTINGS_UPDATED, (Object)this, null);
    }
}

