/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.basic;

import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicResultAssembler<J>
implements DomainResultAssembler<J> {
    protected final int valuesArrayPosition;
    protected final JavaType<J> assembledJavaType;
    private final BasicValueConverter<J, ?> valueConverter;
    private final boolean unwrapRowProcessingState;

    public static <X> BasicResultAssembler<X> from(SqlSelection selection, JavaType<X> javaType) {
        return new BasicResultAssembler<X>(selection.getValuesArrayPosition(), javaType);
    }

    public BasicResultAssembler(int valuesArrayPosition, JavaType<J> assembledJavaType) {
        this(valuesArrayPosition, assembledJavaType, null, false);
    }

    public BasicResultAssembler(int valuesArrayPosition, JavaType<J> assembledJavaType, BasicValueConverter<J, ?> valueConverter, boolean unwrapRowProcessingState) {
        this.valuesArrayPosition = valuesArrayPosition;
        this.assembledJavaType = assembledJavaType;
        this.valueConverter = valueConverter;
        this.unwrapRowProcessingState = unwrapRowProcessingState;
    }

    public Object extractRawValue(RowProcessingState rowProcessingState) {
        if (this.unwrapRowProcessingState) {
            rowProcessingState = rowProcessingState.unwrap();
        }
        return rowProcessingState.getJdbcValue(this.valuesArrayPosition);
    }

    @Override
    public J assemble(RowProcessingState rowProcessingState) {
        Object jdbcValue = this.extractRawValue(rowProcessingState);
        if (this.valueConverter != null) {
            if (jdbcValue != null && !this.valueConverter.getRelationalJavaType().getJavaTypeClass().isInstance(jdbcValue)) {
                throw new HibernateException(String.format(Locale.ROOT, "Expecting raw JDBC value of type `%s`, but found `%s` : [%s]", this.valueConverter.getRelationalJavaType().getTypeName(), jdbcValue.getClass().getName(), jdbcValue));
            }
            return this.valueConverter.toDomainValue(jdbcValue);
        }
        return (J)jdbcValue;
    }

    @Override
    public void resolveState(RowProcessingState rowProcessingState) {
        this.extractRawValue(rowProcessingState);
    }

    @Override
    public JavaType<J> getAssembledJavaType() {
        if (this.valueConverter != null) {
            return this.valueConverter.getDomainJavaType();
        }
        return this.assembledJavaType;
    }

    @Internal
    public BasicValueConverter<J, ?> getValueConverter() {
        return this.valueConverter;
    }
}

