/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.ott;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ott.InMemoryOneTimeTokenService;
import org.springframework.security.authentication.ott.OneTimeTokenAuthenticationProvider;
import org.springframework.security.authentication.ott.OneTimeTokenService;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.RequestMatcherFactory;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.ott.DefaultGenerateOneTimeTokenRequestResolver;
import org.springframework.security.web.authentication.ott.GenerateOneTimeTokenFilter;
import org.springframework.security.web.authentication.ott.GenerateOneTimeTokenRequestResolver;
import org.springframework.security.web.authentication.ott.OneTimeTokenAuthenticationFilter;
import org.springframework.security.web.authentication.ott.OneTimeTokenGenerationSuccessHandler;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.ui.DefaultOneTimeTokenSubmitPageGeneratingFilter;
import org.springframework.security.web.authentication.ui.DefaultResourcesFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OneTimeTokenLoginConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractAuthenticationFilterConfigurer<H, OneTimeTokenLoginConfigurer<H>, OneTimeTokenAuthenticationFilter> {
    private final ApplicationContext context;
    private OneTimeTokenService oneTimeTokenService;
    private String defaultSubmitPageUrl = "/login/ott";
    private boolean submitPageEnabled = true;
    private String loginProcessingUrl = "/login/ott";
    private String tokenGeneratingUrl = "/ott/generate";
    private OneTimeTokenGenerationSuccessHandler oneTimeTokenGenerationSuccessHandler;
    private AuthenticationProvider authenticationProvider;
    private GenerateOneTimeTokenRequestResolver requestResolver;

    public OneTimeTokenLoginConfigurer(ApplicationContext context) {
        super(new OneTimeTokenAuthenticationFilter(), "/login/ott");
        this.context = context;
    }

    @Override
    public void init(H http) throws Exception {
        super.init(http);
        AuthenticationProvider authenticationProvider = this.getAuthenticationProvider();
        http.authenticationProvider(this.postProcess(authenticationProvider));
        this.intiDefaultLoginFilter(http);
    }

    private void intiDefaultLoginFilter(H http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter == null || this.isCustomLoginPage()) {
            return;
        }
        loginPageGeneratingFilter.setOneTimeTokenEnabled(true);
        loginPageGeneratingFilter.setOneTimeTokenGenerationUrl(this.tokenGeneratingUrl);
        if (!StringUtils.hasText((String)loginPageGeneratingFilter.getLoginPageUrl())) {
            loginPageGeneratingFilter.setLoginPageUrl("/login");
            loginPageGeneratingFilter.setFailureUrl("/login?error");
            loginPageGeneratingFilter.setLogoutSuccessUrl("/login?logout");
        }
    }

    @Override
    public void configure(H http) throws Exception {
        super.configure(http);
        this.configureSubmitPage(http);
        this.configureOttGenerateFilter(http);
    }

    private void configureOttGenerateFilter(H http) {
        GenerateOneTimeTokenFilter generateFilter = new GenerateOneTimeTokenFilter(this.getOneTimeTokenService(), this.getOneTimeTokenGenerationSuccessHandler());
        generateFilter.setRequestMatcher(RequestMatcherFactory.matcher(HttpMethod.POST, this.tokenGeneratingUrl));
        generateFilter.setRequestResolver(this.getGenerateRequestResolver());
        http.addFilter((Filter)this.postProcess(generateFilter));
        http.addFilter((Filter)DefaultResourcesFilter.css());
    }

    private OneTimeTokenGenerationSuccessHandler getOneTimeTokenGenerationSuccessHandler() {
        if (this.oneTimeTokenGenerationSuccessHandler == null) {
            this.oneTimeTokenGenerationSuccessHandler = (OneTimeTokenGenerationSuccessHandler)this.context.getBeanProvider(OneTimeTokenGenerationSuccessHandler.class).getIfUnique();
        }
        if (this.oneTimeTokenGenerationSuccessHandler == null) {
            throw new IllegalStateException("A OneTimeTokenGenerationSuccessHandler is required to enable oneTimeTokenLogin().\nPlease provide it as a bean or pass it to the oneTimeTokenLogin() DSL.\n");
        }
        return this.oneTimeTokenGenerationSuccessHandler;
    }

    private void configureSubmitPage(H http) {
        if (!this.submitPageEnabled) {
            return;
        }
        DefaultOneTimeTokenSubmitPageGeneratingFilter submitPage = new DefaultOneTimeTokenSubmitPageGeneratingFilter();
        submitPage.setResolveHiddenInputs(this::hiddenInputs);
        submitPage.setRequestMatcher(RequestMatcherFactory.matcher(HttpMethod.GET, this.defaultSubmitPageUrl));
        submitPage.setLoginProcessingUrl(this.getLoginProcessingUrl());
        http.addFilter((Filter)this.postProcess(submitPage));
    }

    private AuthenticationProvider getAuthenticationProvider() {
        if (this.authenticationProvider != null) {
            return this.authenticationProvider;
        }
        UserDetailsService userDetailsService = (UserDetailsService)this.context.getBean(UserDetailsService.class);
        this.authenticationProvider = new OneTimeTokenAuthenticationProvider(this.getOneTimeTokenService(), userDetailsService);
        return this.authenticationProvider;
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return RequestMatcherFactory.matcher(HttpMethod.POST, loginProcessingUrl);
    }

    public OneTimeTokenLoginConfigurer<H> authenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"authenticationProvider cannot be null");
        this.authenticationProvider = authenticationProvider;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> tokenGeneratingUrl(String tokenGeneratingUrl) {
        Assert.hasText((String)tokenGeneratingUrl, (String)"tokenGeneratingUrl cannot be null or empty");
        this.tokenGeneratingUrl = tokenGeneratingUrl;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> tokenGenerationSuccessHandler(OneTimeTokenGenerationSuccessHandler oneTimeTokenGenerationSuccessHandler) {
        Assert.notNull((Object)oneTimeTokenGenerationSuccessHandler, (String)"oneTimeTokenGenerationSuccessHandler cannot be null");
        this.oneTimeTokenGenerationSuccessHandler = oneTimeTokenGenerationSuccessHandler;
        return this;
    }

    @Override
    public OneTimeTokenLoginConfigurer<H> loginProcessingUrl(String loginProcessingUrl) {
        Assert.hasText((String)loginProcessingUrl, (String)"loginProcessingUrl cannot be null or empty");
        super.loginProcessingUrl(loginProcessingUrl);
        return this;
    }

    @Override
    public OneTimeTokenLoginConfigurer<H> loginPage(String loginPage) {
        return (OneTimeTokenLoginConfigurer)super.loginPage(loginPage);
    }

    public OneTimeTokenLoginConfigurer<H> showDefaultSubmitPage(boolean show) {
        this.submitPageEnabled = show;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> defaultSubmitPageUrl(String submitPageUrl) {
        Assert.hasText((String)submitPageUrl, (String)"submitPageUrl cannot be null or empty");
        this.defaultSubmitPageUrl = submitPageUrl;
        this.showDefaultSubmitPage(true);
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> tokenService(OneTimeTokenService oneTimeTokenService) {
        Assert.notNull((Object)oneTimeTokenService, (String)"oneTimeTokenService cannot be null");
        this.oneTimeTokenService = oneTimeTokenService;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> authenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        ((OneTimeTokenAuthenticationFilter)this.getAuthenticationFilter()).setAuthenticationConverter(authenticationConverter);
        return this;
    }

    @Deprecated(since="6.5")
    public OneTimeTokenLoginConfigurer<H> authenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        super.failureHandler(authenticationFailureHandler);
        return this;
    }

    @Deprecated(since="6.5")
    public OneTimeTokenLoginConfigurer<H> authenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
        super.successHandler(authenticationSuccessHandler);
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> generateRequestResolver(GenerateOneTimeTokenRequestResolver requestResolver) {
        Assert.notNull((Object)requestResolver, (String)"requestResolver cannot be null");
        this.requestResolver = requestResolver;
        return this;
    }

    private GenerateOneTimeTokenRequestResolver getGenerateRequestResolver() {
        if (this.requestResolver != null) {
            return this.requestResolver;
        }
        this.requestResolver = (GenerateOneTimeTokenRequestResolver)this.context.getBeanProvider(GenerateOneTimeTokenRequestResolver.class).getIfUnique(DefaultGenerateOneTimeTokenRequestResolver::new);
        return this.requestResolver;
    }

    private OneTimeTokenService getOneTimeTokenService() {
        if (this.oneTimeTokenService != null) {
            return this.oneTimeTokenService;
        }
        this.oneTimeTokenService = (OneTimeTokenService)this.context.getBeanProvider(OneTimeTokenService.class).getIfUnique(InMemoryOneTimeTokenService::new);
        return this.oneTimeTokenService;
    }

    private Map<String, String> hiddenInputs(HttpServletRequest request) {
        CsrfToken token = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
        return token != null ? Collections.singletonMap(token.getParameterName(), token.getToken()) : Collections.emptyMap();
    }

    @Deprecated
    public ApplicationContext getContext() {
        return this.context;
    }
}

