/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DenseVectorElementType;
import co.elastic.clients.elasticsearch._types.mapping.DenseVectorIndexOptions;
import co.elastic.clients.elasticsearch._types.mapping.DenseVectorSimilarity;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DenseVectorProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final Integer dims;
    @Nullable
    private final DenseVectorElementType elementType;
    @Nullable
    private final Boolean index;
    @Nullable
    private final DenseVectorIndexOptions indexOptions;
    @Nullable
    private final DenseVectorSimilarity similarity;
    public static final JsonpDeserializer<DenseVectorProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DenseVectorProperty::setupDenseVectorPropertyDeserializer);

    private DenseVectorProperty(Builder builder) {
        super(builder);
        this.dims = builder.dims;
        this.elementType = builder.elementType;
        this.index = builder.index;
        this.indexOptions = builder.indexOptions;
        this.similarity = builder.similarity;
    }

    public static DenseVectorProperty of(Function<Builder, ObjectBuilder<DenseVectorProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.DenseVector;
    }

    @Nullable
    public final Integer dims() {
        return this.dims;
    }

    @Nullable
    public final DenseVectorElementType elementType() {
        return this.elementType;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final DenseVectorIndexOptions indexOptions() {
        return this.indexOptions;
    }

    @Nullable
    public final DenseVectorSimilarity similarity() {
        return this.similarity;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "dense_vector");
        super.serializeInternal(generator, mapper);
        if (this.dims != null) {
            generator.writeKey("dims");
            generator.write(this.dims.intValue());
        }
        if (this.elementType != null) {
            generator.writeKey("element_type");
            this.elementType.serialize(generator, mapper);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.indexOptions != null) {
            generator.writeKey("index_options");
            this.indexOptions.serialize(generator, mapper);
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            this.similarity.serialize(generator, mapper);
        }
    }

    protected static void setupDenseVectorPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::dims, JsonpDeserializer.integerDeserializer(), "dims");
        op.add(Builder::elementType, DenseVectorElementType._DESERIALIZER, "element_type");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::indexOptions, DenseVectorIndexOptions._DESERIALIZER, "index_options");
        op.add(Builder::similarity, DenseVectorSimilarity._DESERIALIZER, "similarity");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DenseVectorProperty> {
        @Nullable
        private Integer dims;
        @Nullable
        private DenseVectorElementType elementType;
        @Nullable
        private Boolean index;
        @Nullable
        private DenseVectorIndexOptions indexOptions;
        @Nullable
        private DenseVectorSimilarity similarity;

        public final Builder dims(@Nullable Integer value) {
            this.dims = value;
            return this;
        }

        public final Builder elementType(@Nullable DenseVectorElementType value) {
            this.elementType = value;
            return this;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder indexOptions(@Nullable DenseVectorIndexOptions value) {
            this.indexOptions = value;
            return this;
        }

        public final Builder indexOptions(Function<DenseVectorIndexOptions.Builder, ObjectBuilder<DenseVectorIndexOptions>> fn) {
            return this.indexOptions(fn.apply(new DenseVectorIndexOptions.Builder()).build());
        }

        public final Builder similarity(@Nullable DenseVectorSimilarity value) {
            this.similarity = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DenseVectorProperty build() {
            this._checkSingleUse();
            return new DenseVectorProperty(this);
        }
    }
}

