/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterNodeCount
implements JsonpSerializable {
    private final int total;
    @Nullable
    private final Integer coordinatingOnly;
    @Nullable
    private final Integer data;
    @Nullable
    private final Integer dataCold;
    @Nullable
    private final Integer dataContent;
    @Nullable
    private final Integer dataFrozen;
    @Nullable
    private final Integer dataHot;
    @Nullable
    private final Integer dataWarm;
    @Nullable
    private final Integer index;
    @Nullable
    private final Integer ingest;
    @Nullable
    private final Integer master;
    @Nullable
    private final Integer ml;
    @Nullable
    private final Integer remoteClusterClient;
    @Nullable
    private final Integer search;
    @Nullable
    private final Integer transform;
    @Nullable
    private final Integer votingOnly;
    public static final JsonpDeserializer<ClusterNodeCount> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterNodeCount::setupClusterNodeCountDeserializer);

    private ClusterNodeCount(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0);
        this.coordinatingOnly = builder.coordinatingOnly;
        this.data = builder.data;
        this.dataCold = builder.dataCold;
        this.dataContent = builder.dataContent;
        this.dataFrozen = builder.dataFrozen;
        this.dataHot = builder.dataHot;
        this.dataWarm = builder.dataWarm;
        this.index = builder.index;
        this.ingest = builder.ingest;
        this.master = builder.master;
        this.ml = builder.ml;
        this.remoteClusterClient = builder.remoteClusterClient;
        this.search = builder.search;
        this.transform = builder.transform;
        this.votingOnly = builder.votingOnly;
    }

    public static ClusterNodeCount of(Function<Builder, ObjectBuilder<ClusterNodeCount>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int total() {
        return this.total;
    }

    @Nullable
    public final Integer coordinatingOnly() {
        return this.coordinatingOnly;
    }

    @Nullable
    public final Integer data() {
        return this.data;
    }

    @Nullable
    public final Integer dataCold() {
        return this.dataCold;
    }

    @Nullable
    public final Integer dataContent() {
        return this.dataContent;
    }

    @Nullable
    public final Integer dataFrozen() {
        return this.dataFrozen;
    }

    @Nullable
    public final Integer dataHot() {
        return this.dataHot;
    }

    @Nullable
    public final Integer dataWarm() {
        return this.dataWarm;
    }

    @Nullable
    public final Integer index() {
        return this.index;
    }

    @Nullable
    public final Integer ingest() {
        return this.ingest;
    }

    @Nullable
    public final Integer master() {
        return this.master;
    }

    @Nullable
    public final Integer ml() {
        return this.ml;
    }

    @Nullable
    public final Integer remoteClusterClient() {
        return this.remoteClusterClient;
    }

    @Nullable
    public final Integer search() {
        return this.search;
    }

    @Nullable
    public final Integer transform() {
        return this.transform;
    }

    @Nullable
    public final Integer votingOnly() {
        return this.votingOnly;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        if (this.coordinatingOnly != null) {
            generator.writeKey("coordinating_only");
            generator.write(this.coordinatingOnly.intValue());
        }
        if (this.data != null) {
            generator.writeKey("data");
            generator.write(this.data.intValue());
        }
        if (this.dataCold != null) {
            generator.writeKey("data_cold");
            generator.write(this.dataCold.intValue());
        }
        if (this.dataContent != null) {
            generator.writeKey("data_content");
            generator.write(this.dataContent.intValue());
        }
        if (this.dataFrozen != null) {
            generator.writeKey("data_frozen");
            generator.write(this.dataFrozen.intValue());
        }
        if (this.dataHot != null) {
            generator.writeKey("data_hot");
            generator.write(this.dataHot.intValue());
        }
        if (this.dataWarm != null) {
            generator.writeKey("data_warm");
            generator.write(this.dataWarm.intValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.intValue());
        }
        if (this.ingest != null) {
            generator.writeKey("ingest");
            generator.write(this.ingest.intValue());
        }
        if (this.master != null) {
            generator.writeKey("master");
            generator.write(this.master.intValue());
        }
        if (this.ml != null) {
            generator.writeKey("ml");
            generator.write(this.ml.intValue());
        }
        if (this.remoteClusterClient != null) {
            generator.writeKey("remote_cluster_client");
            generator.write(this.remoteClusterClient.intValue());
        }
        if (this.search != null) {
            generator.writeKey("search");
            generator.write(this.search.intValue());
        }
        if (this.transform != null) {
            generator.writeKey("transform");
            generator.write(this.transform.intValue());
        }
        if (this.votingOnly != null) {
            generator.writeKey("voting_only");
            generator.write(this.votingOnly.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupClusterNodeCountDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::coordinatingOnly, JsonpDeserializer.integerDeserializer(), "coordinating_only");
        op.add(Builder::data, JsonpDeserializer.integerDeserializer(), "data");
        op.add(Builder::dataCold, JsonpDeserializer.integerDeserializer(), "data_cold");
        op.add(Builder::dataContent, JsonpDeserializer.integerDeserializer(), "data_content");
        op.add(Builder::dataFrozen, JsonpDeserializer.integerDeserializer(), "data_frozen");
        op.add(Builder::dataHot, JsonpDeserializer.integerDeserializer(), "data_hot");
        op.add(Builder::dataWarm, JsonpDeserializer.integerDeserializer(), "data_warm");
        op.add(Builder::index, JsonpDeserializer.integerDeserializer(), "index");
        op.add(Builder::ingest, JsonpDeserializer.integerDeserializer(), "ingest");
        op.add(Builder::master, JsonpDeserializer.integerDeserializer(), "master");
        op.add(Builder::ml, JsonpDeserializer.integerDeserializer(), "ml");
        op.add(Builder::remoteClusterClient, JsonpDeserializer.integerDeserializer(), "remote_cluster_client");
        op.add(Builder::search, JsonpDeserializer.integerDeserializer(), "search");
        op.add(Builder::transform, JsonpDeserializer.integerDeserializer(), "transform");
        op.add(Builder::votingOnly, JsonpDeserializer.integerDeserializer(), "voting_only");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterNodeCount> {
        private Integer total;
        @Nullable
        private Integer coordinatingOnly;
        @Nullable
        private Integer data;
        @Nullable
        private Integer dataCold;
        @Nullable
        private Integer dataContent;
        @Nullable
        private Integer dataFrozen;
        @Nullable
        private Integer dataHot;
        @Nullable
        private Integer dataWarm;
        @Nullable
        private Integer index;
        @Nullable
        private Integer ingest;
        @Nullable
        private Integer master;
        @Nullable
        private Integer ml;
        @Nullable
        private Integer remoteClusterClient;
        @Nullable
        private Integer search;
        @Nullable
        private Integer transform;
        @Nullable
        private Integer votingOnly;

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder coordinatingOnly(@Nullable Integer value) {
            this.coordinatingOnly = value;
            return this;
        }

        public final Builder data(@Nullable Integer value) {
            this.data = value;
            return this;
        }

        public final Builder dataCold(@Nullable Integer value) {
            this.dataCold = value;
            return this;
        }

        public final Builder dataContent(@Nullable Integer value) {
            this.dataContent = value;
            return this;
        }

        public final Builder dataFrozen(@Nullable Integer value) {
            this.dataFrozen = value;
            return this;
        }

        public final Builder dataHot(@Nullable Integer value) {
            this.dataHot = value;
            return this;
        }

        public final Builder dataWarm(@Nullable Integer value) {
            this.dataWarm = value;
            return this;
        }

        public final Builder index(@Nullable Integer value) {
            this.index = value;
            return this;
        }

        public final Builder ingest(@Nullable Integer value) {
            this.ingest = value;
            return this;
        }

        public final Builder master(@Nullable Integer value) {
            this.master = value;
            return this;
        }

        public final Builder ml(@Nullable Integer value) {
            this.ml = value;
            return this;
        }

        public final Builder remoteClusterClient(@Nullable Integer value) {
            this.remoteClusterClient = value;
            return this;
        }

        public final Builder search(@Nullable Integer value) {
            this.search = value;
            return this;
        }

        public final Builder transform(@Nullable Integer value) {
            this.transform = value;
            return this;
        }

        public final Builder votingOnly(@Nullable Integer value) {
            this.votingOnly = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterNodeCount build() {
            this._checkSingleUse();
            return new ClusterNodeCount(this);
        }
    }
}

