/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.internal.JtaSynchronizationStrategy;
import org.hibernate.engine.transaction.jta.platform.internal.TransactionManagerAccess;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformException;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public abstract class AbstractJtaPlatform
implements JtaPlatform,
Configurable,
ServiceRegistryAwareService,
TransactionManagerAccess {
    private @UnknownKeyFor @NonNull @Initialized boolean cacheTransactionManager;
    private @UnknownKeyFor @NonNull @Initialized boolean cacheUserTransaction;
    private @UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor serviceRegistry;
    private final @UnknownKeyFor @NonNull @Initialized JtaSynchronizationStrategy tmSynchronizationStrategy = new TransactionManagerBasedSynchronizationStrategy();
    private @UnknownKeyFor @NonNull @Initialized TransactionManager transactionManager;
    private @UnknownKeyFor @NonNull @Initialized UserTransaction userTransaction;

    @Override
    public void injectServices(@UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected @UnknownKeyFor @NonNull @Initialized ServiceRegistry serviceRegistry() {
        return this.serviceRegistry;
    }

    protected @UnknownKeyFor @NonNull @Initialized JndiService jndiService() {
        return this.serviceRegistry().requireService(JndiService.class);
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized TransactionManager locateTransactionManager();

    protected abstract @UnknownKeyFor @NonNull @Initialized UserTransaction locateUserTransaction();

    @Override
    public void configure(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> configValues) {
        this.cacheTransactionManager = ConfigurationHelper.getBoolean("hibernate.jta.cacheTransactionManager", configValues, this.canCacheTransactionManagerByDefault());
        this.cacheUserTransaction = ConfigurationHelper.getBoolean("hibernate.jta.cacheUserTransaction", configValues, this.canCacheUserTransactionByDefault());
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean canCacheTransactionManagerByDefault() {
        return true;
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean canCacheUserTransactionByDefault() {
        return false;
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean canCacheTransactionManager() {
        return this.cacheTransactionManager;
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean canCacheUserTransaction() {
        return this.cacheUserTransaction;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TransactionManager retrieveTransactionManager() {
        if (this.canCacheTransactionManager()) {
            if (this.transactionManager == null) {
                this.transactionManager = this.locateTransactionManager();
            }
            return this.transactionManager;
        }
        return this.locateTransactionManager();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TransactionManager getTransactionManager() {
        return this.retrieveTransactionManager();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized UserTransaction retrieveUserTransaction() {
        if (this.canCacheUserTransaction()) {
            if (this.userTransaction == null) {
                this.userTransaction = this.locateUserTransaction();
            }
            return this.userTransaction;
        }
        return this.locateUserTransaction();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object getTransactionIdentifier(@UnknownKeyFor @NonNull @Initialized Transaction transaction) {
        return transaction;
    }

    protected @UnknownKeyFor @NonNull @Initialized JtaSynchronizationStrategy getSynchronizationStrategy() {
        return this.tmSynchronizationStrategy;
    }

    @Override
    public void registerSynchronization(@UnknownKeyFor @NonNull @Initialized Synchronization synchronization) {
        this.getSynchronizationStrategy().registerSynchronization(synchronization);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean canRegisterSynchronization() {
        return this.getSynchronizationStrategy().canRegisterSynchronization();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int getCurrentStatus() throws @UnknownKeyFor @NonNull @Initialized SystemException {
        return this.retrieveTransactionManager().getStatus();
    }

    private final class TransactionManagerBasedSynchronizationStrategy
    implements JtaSynchronizationStrategy {
        private TransactionManagerBasedSynchronizationStrategy() {
        }

        @Override
        public void registerSynchronization(@UnknownKeyFor @NonNull @Initialized Synchronization synchronization) {
            try {
                AbstractJtaPlatform.this.getTransactionManager().getTransaction().registerSynchronization(synchronization);
            }
            catch (Exception e) {
                throw new JtaPlatformException("Could not access JTA Transaction to register synchronization", e);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean canRegisterSynchronization() {
            return JtaStatusHelper.isActive(AbstractJtaPlatform.this.getTransactionManager());
        }
    }
}

