/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.List;
import org.hibernate.procedure.internal.AbstractStandardCallableStatementSupport;
import org.hibernate.procedure.spi.FunctionReturnImplementor;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.ProcedureParameterMetadataImplementor;
import org.hibernate.sql.exec.internal.JdbcCallImpl;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcOperationQueryCall;

public class DB2CallableStatementSupport
extends AbstractStandardCallableStatementSupport {
    public static final DB2CallableStatementSupport INSTANCE = new DB2CallableStatementSupport();
    private static final String FUNCTION_SYNTAX_START = "select ";
    private static final String FUNCTION_SYNTAX_END = ") from sysibm.dual";
    private static final String TABLE_FUNCTION_SYNTAX_START = "select * from table(";
    private static final String TABLE_FUNCTION_SYNTAX_END = "))";
    private static final String CALL_SYNTAX_START = "{call ";
    private static final String CALL_SYNTAX_END = ")}";

    @Override
    public JdbcOperationQueryCall interpretCall(ProcedureCallImplementor<?> procedureCall) {
        StringBuilder buffer;
        int offset;
        String procedureName = procedureCall.getProcedureName();
        FunctionReturnImplementor functionReturn = procedureCall.getFunctionReturn();
        ProcedureParameterMetadataImplementor parameterMetadata = procedureCall.getParameterMetadata();
        List<ProcedureParameterImplementor<?>> registrations = parameterMetadata.getRegistrationsAsList();
        int paramStringSizeEstimate = functionReturn == null && parameterMetadata.hasNamedParameters() ? registrations.size() * 10 : registrations.size() * 2;
        JdbcCallImpl.Builder builder = new JdbcCallImpl.Builder();
        if (functionReturn != null) {
            offset = 1;
            buffer = functionReturn.getJdbcTypeCode() == 2012 ? new StringBuilder(TABLE_FUNCTION_SYNTAX_START.length() + TABLE_FUNCTION_SYNTAX_END.length() + procedureName.length() + paramStringSizeEstimate).append(TABLE_FUNCTION_SYNTAX_START) : new StringBuilder(FUNCTION_SYNTAX_START.length() + FUNCTION_SYNTAX_END.length() + procedureName.length() + paramStringSizeEstimate).append(FUNCTION_SYNTAX_START);
        } else {
            offset = 1;
            buffer = new StringBuilder(CALL_SYNTAX_START.length() + CALL_SYNTAX_END.length() + procedureName.length() + paramStringSizeEstimate).append(CALL_SYNTAX_START);
        }
        buffer.append(procedureName);
        if (registrations.isEmpty()) {
            buffer.append('(');
        } else {
            int sep = 40;
            for (int i = 0; i < registrations.size(); ++i) {
                ProcedureParameterImplementor<?> parameter = registrations.get(i);
                buffer.append((char)sep);
                JdbcCallParameterRegistration registration = parameter.toJdbcParameterRegistration(i + offset, procedureCall);
                if (registration.getName() != null) {
                    buffer.append(':').append(registration.getName());
                } else {
                    buffer.append("?");
                }
                sep = 44;
                builder.addParameterRegistration(registration);
            }
        }
        if (functionReturn != null) {
            if (functionReturn.getJdbcTypeCode() == 2012) {
                buffer.append(TABLE_FUNCTION_SYNTAX_END);
            } else {
                buffer.append(FUNCTION_SYNTAX_END);
            }
        } else {
            buffer.append(CALL_SYNTAX_END);
        }
        builder.setCallableName(buffer.toString());
        return builder.buildJdbcCall();
    }
}

