/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.util.BitSet;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.map.BitMap;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public final class BitType
extends BinaryType {
    static final long maxBitPrecision = 1024L;

    public BitType(int n, long l) {
        super(n, l);
    }

    @Override
    public int displaySize() {
        return (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return -7;
    }

    @Override
    public Class getJDBCClass() {
        return byte[].class;
    }

    @Override
    public String getJDBCClassName() {
        return "[B";
    }

    @Override
    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    @Override
    public String getNameString() {
        return this.typeCode == 14 ? "BIT" : "BIT VARYING";
    }

    @Override
    public String getDefinition() {
        if (this.precision == 0L) {
            return this.getNameString();
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.getNameString()).append('(').append(this.precision).append(')');
        return stringBuilder.toString();
    }

    @Override
    public boolean isBitType() {
        return true;
    }

    @Override
    public long getMaxPrecision() {
        return 1024L;
    }

    @Override
    public boolean requiresPrecision() {
        return this.typeCode == 15;
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == type.typeCode) {
            return this.precision >= type.precision ? this : type;
        }
        switch (type.typeCode) {
            case 14: {
                return this.precision >= type.precision ? this : BitType.getBitType(this.typeCode, type.precision);
            }
            case 15: {
                return type.precision >= this.precision ? type : BitType.getBitType(type.typeCode, this.precision);
            }
            case 30: 
            case 60: 
            case 61: {
                return type;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n) {
        Type type2;
        if (n != 36) {
            return this.getAggregateType(type);
        }
        long l = this.precision + type.precision;
        switch (type.typeCode) {
            case 0: {
                return this;
            }
            case 14: {
                type2 = this;
                break;
            }
            case 15: {
                type2 = type;
                break;
            }
            case 30: 
            case 60: 
            case 61: {
                return type.getCombinedType(session, this, n);
            }
            default: {
                throw Error.error(5562);
            }
        }
        if (l > 1024L) {
            if (this.typeCode == 14) {
                throw Error.error(5570);
            }
            l = 1024L;
        }
        return BitType.getBitType(type2.typeCode, l);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        int n = super.compare(session, object, object2);
        if (n == 0 && object != null) {
            if (((BinaryData)object).bitLength(null) == ((BinaryData)object2).bitLength(null)) {
                return 0;
            }
            return ((BinaryData)object).bitLength(null) > ((BinaryData)object2).bitLength(null) ? 1 : -1;
        }
        return n;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        return this.castOrConvertToType(null, object, this, false);
    }

    @Override
    public Object castToType(SessionInterface sessionInterface, Object object, Type type) {
        return this.castOrConvertToType(sessionInterface, object, type, true);
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        return this.castOrConvertToType(sessionInterface, object, type, false);
    }

    @Override
    Object castOrConvertToType(SessionInterface sessionInterface, Object object, Type type, boolean bl) {
        byte[] byArray;
        BlobData blobData;
        if (object == null) {
            return null;
        }
        switch (type.typeCode) {
            case 1: 
            case 12: {
                blobData = sessionInterface.getScanner().convertToBit((String)object);
                type = BitType.getBitType(15, blobData.length(sessionInterface));
                break;
            }
            case 14: 
            case 15: 
            case 30: 
            case 60: 
            case 61: {
                blobData = (BlobData)object;
                break;
            }
            case 16: {
                if (this.precision != 1L) {
                    throw Error.error(3471);
                }
                if (((Boolean)object).booleanValue()) {
                    return BinaryData.singleBitOne;
                }
                return BinaryData.singleBitZero;
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                if (this.precision != 1L) {
                    throw Error.error(3471);
                }
                if (((NumberType)type).compareToZero(object) == 0) {
                    return BinaryData.singleBitZero;
                }
                return BinaryData.singleBitOne;
            }
            default: {
                throw Error.error(3471);
            }
        }
        if (blobData.bitLength(sessionInterface) > this.precision) {
            if (!bl) {
                throw Error.error(3401);
            }
            sessionInterface.addWarning(Error.error(1004));
        }
        int n = (int)((this.precision + 7L) / 8L);
        if (type.typeCode == 30) {
            byArray = blobData.getBytes(sessionInterface, 0L, n);
            blobData = new BinaryData(byArray, this.precision);
        }
        switch (this.typeCode) {
            case 14: {
                if (blobData.bitLength(sessionInterface) == this.precision) {
                    return blobData;
                }
                if (blobData.length(sessionInterface) > (long)n) {
                    byArray = blobData.getBytes(sessionInterface, 0L, n);
                    blobData = new BinaryData(byArray, this.precision);
                    break;
                }
                if (blobData.length(sessionInterface) > (long)n) break;
                byArray = (byte[])ArrayUtil.resizeArray(blobData.getBytes(), n);
                blobData = new BinaryData(byArray, this.precision);
                break;
            }
            case 15: {
                if (blobData.bitLength(sessionInterface) <= this.precision) {
                    return blobData;
                }
                if (blobData.length(sessionInterface) <= (long)n) break;
                byArray = blobData.getBytes(sessionInterface, 0L, n);
                blobData = new BinaryData(byArray, this.precision);
                break;
            }
            default: {
                throw Error.error(3471);
            }
        }
        byArray = blobData.getBytes();
        int n2 = (int)this.precision;
        while ((long)n2 < blobData.length(sessionInterface) * 8L) {
            BitMap.unset(byArray, n2);
            ++n2;
        }
        return blobData;
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            BinaryData binaryData = new BinaryData((byte[])object, ((byte[])object).length);
            return this.convertToTypeLimits(sessionInterface, binaryData);
        }
        if (object instanceof BinaryData) {
            return this.convertToTypeLimits(sessionInterface, object);
        }
        if (object instanceof String) {
            return this.convertToType(sessionInterface, object, Type.SQL_VARCHAR);
        }
        if (object instanceof Boolean) {
            return this.convertToType(sessionInterface, object, Type.SQL_BOOLEAN);
        }
        if (object instanceof Integer) {
            return this.convertToType(sessionInterface, object, Type.SQL_INTEGER);
        }
        if (object instanceof Long) {
            return this.convertToType(sessionInterface, object, Type.SQL_BIGINT);
        }
        if (object instanceof BitSet) {
            BitSet bitSet = (BitSet)object;
            byte[] byArray = new byte[((int)this.precision + 8 - 1) / 8];
            if ((long)bitSet.length() > this.precision) {
                throw Error.error(3471);
            }
            for (int i = 0; i < bitSet.length(); ++i) {
                boolean bl = bitSet.get(i);
                if (!bl) continue;
                BitMap.set(byArray, i);
            }
            return new BinaryData(byArray, this.precision);
        }
        throw Error.error(3471);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        return this.convertToDefaultType(sessionInterface, object);
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return StringConverter.byteArrayToBitString(((BinaryData)object).getBytes(), (int)((BinaryData)object).bitLength(null));
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        return StringConverter.byteArrayToSQLBitString(((BinaryData)object).getBytes(), (int)((BinaryData)object).bitLength(null));
    }

    @Override
    public void convertToJSON(Object object, StringBuilder stringBuilder) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('\"');
        stringBuilder.append(this.convertToString(object));
        stringBuilder.append('\"');
    }

    @Override
    public boolean canConvertFrom(Type type) {
        return type.typeCode == 0 || type.isBinaryType() || this.precision == 1L && (type.isIntegralType() || type.isBooleanType()) || type.isCharacterType();
    }

    @Override
    public int canMoveFrom(Type type) {
        switch (this.typeCode) {
            case 14: {
                if (type.typeCode == this.typeCode) {
                    return this.precision == type.precision ? 0 : -1;
                }
                return -1;
            }
            case 15: {
                return type.isBitType() && this.precision >= type.precision ? 0 : -1;
            }
        }
        return -1;
    }

    @Override
    public long position(SessionInterface sessionInterface, BlobData blobData, BlobData blobData2, Type type, long l) {
        if (blobData == null || blobData2 == null) {
            return -1L;
        }
        long l2 = blobData.bitLength(sessionInterface);
        if (l + l2 > blobData.bitLength(sessionInterface)) {
            return -1L;
        }
        throw Error.runtimeError(201, "BitType");
    }

    @Override
    public BlobData substring(SessionInterface sessionInterface, BlobData blobData, long l, long l2, boolean bl) {
        long l3;
        long l4 = blobData.bitLength(sessionInterface);
        if (bl) {
            l3 = l + l2;
        } else {
            long l5 = l3 = l4 > l ? l4 : l;
        }
        if (l3 < l) {
            throw Error.error(3431);
        }
        if (l3 < 0L) {
            l = 0L;
            l3 = 0L;
        }
        if (l < 0L) {
            l = 0L;
        }
        if (l3 > l4) {
            l3 = l4;
        }
        l2 = l3 - l;
        byte[] byArray = blobData.getBytes();
        byte[] byArray2 = new byte[(int)(l2 + 7L) / 8];
        int n = (int)l;
        while ((long)n < l3) {
            if (BitMap.isSet(byArray, n)) {
                BitMap.set(byArray2, n - (int)l);
            }
            ++n;
        }
        return new BinaryData(byArray2, l2);
    }

    int getRightTrimSize(BinaryData binaryData) {
        int n;
        byte[] byArray = binaryData.getBytes();
        for (n = (int)binaryData.bitLength(null) - 1; n >= 0 && !BitMap.isSet(byArray, n); --n) {
        }
        return n + 1;
    }

    @Override
    public BlobData overlay(Session session, BlobData blobData, BlobData blobData2, long l, long l2, boolean bl) {
        if (blobData == null || blobData2 == null) {
            return null;
        }
        if (!bl) {
            l2 = blobData2.bitLength(session);
        }
        switch (this.typeCode) {
            case 14: 
            case 15: {
                byte[] byArray = (byte[])ArrayUtil.duplicateArray(blobData.getBytes());
                byte[] byArray2 = blobData2.getBytes();
                int n = 0;
                int n2 = (int)l;
                while ((long)n < l2) {
                    int n3 = 8;
                    if (l2 - (long)n2 < 8L) {
                        n3 = (int)l2 - n2;
                    }
                    BitMap.overlay(byArray, n2, byArray2[n], n3);
                    n2 += 8;
                    ++n;
                }
                BinaryData binaryData = new BinaryData(byArray, blobData.bitLength(session));
                return binaryData;
            }
        }
        throw Error.runtimeError(201, "BitType");
    }

    @Override
    public Object concat(Session session, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        long l = ((BlobData)object).bitLength(session) + ((BlobData)object2).bitLength(session);
        if (l > Integer.MAX_VALUE) {
            throw Error.error(1000);
        }
        byte[] byArray = ((BlobData)object).getBytes();
        byte[] byArray2 = ((BlobData)object2).getBytes();
        int n = (int)((BlobData)object).bitLength(session);
        int n2 = (int)((BlobData)object2).bitLength(session);
        byte[] byArray3 = new byte[(int)(l + 7L) / 8];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        for (int i = 0; i < n2; ++i) {
            if (!BitMap.isSet(byArray2, i)) continue;
            BitMap.set(byArray3, n + i);
        }
        return new BinaryData(byArray3, l);
    }

    public static BinaryType getBitType(int n, long l) {
        switch (n) {
            case 14: 
            case 15: {
                return new BitType(n, l);
            }
        }
        throw Error.runtimeError(201, "BitType");
    }

    public static BitSet getJavaBitSet(BinaryData binaryData) {
        int n = (int)binaryData.bitLength(null);
        BitSet bitSet = new BitSet(n);
        byte[] byArray = binaryData.getBytes();
        for (int i = 0; i < n; ++i) {
            boolean bl = BitMap.isSet(byArray, i);
            if (!bl) continue;
            bitSet.set(i);
        }
        return bitSet;
    }
}

