/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.page;

import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;

public class PageKey
implements Serializable {
    private static final long serialVersionUID = -5005776237959733435L;
    final SiteKey site;
    final String name;
    private String ref;

    public static PageKey parse(String pageKey) {
        if (StringUtils.isBlank((CharSequence)pageKey)) {
            throw new IllegalArgumentException("No null string argument allowed");
        }
        String[] pageKeyParts = StringUtils.split((String)pageKey, (String)"::");
        if (pageKeyParts.length != 3) {
            throw new IllegalArgumentException("Format should be SITE_TYPE::SITE_NAME::PAGE_NAME");
        }
        return SiteType.valueOf(pageKeyParts[0].toUpperCase()).key(pageKeyParts[1]).page(pageKeyParts[2]);
    }

    public PageKey(String siteType, String siteName, String name) {
        this(SiteType.valueOf(siteType.toUpperCase()).key(siteName), name);
    }

    public PageKey(SiteType siteType, String siteName, String name) {
        this(siteType.key(siteName), name);
    }

    public PageKey(SiteKey site, String name) {
        this.site = site;
        this.name = name;
    }

    public PageKey sibling(String name) {
        return new PageKey(this.site, name);
    }

    public String format() {
        if (this.ref == null) {
            this.ref = String.format("%s::%s::%s", this.site == null ? "" : this.site.getType().getName(), this.site == null ? "" : this.site.getName(), this.name);
        }
        return this.ref;
    }

    public org.exoplatform.portal.pom.data.PageKey toPomPageKey() {
        return new org.exoplatform.portal.pom.data.PageKey(this.site.getType().getName(), this.site.getName(), this.name);
    }

    public String toString() {
        return this.format();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageKey other = (PageKey)obj;
        return Objects.equals(this.format(), other.format());
    }

    public int hashCode() {
        return Objects.hash(this.format());
    }

    @Generated
    public SiteKey getSite() {
        return this.site;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getRef() {
        return this.ref;
    }

    @Generated
    public void setRef(String ref) {
        this.ref = ref;
    }
}

