/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.PressureMemory;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexingPressureMemory
implements JsonpSerializable {
    @Nullable
    private final String limit;
    @Nullable
    private final Long limitInBytes;
    @Nullable
    private final PressureMemory current;
    @Nullable
    private final PressureMemory total;
    public static final JsonpDeserializer<IndexingPressureMemory> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexingPressureMemory::setupIndexingPressureMemoryDeserializer);

    private IndexingPressureMemory(Builder builder) {
        this.limit = builder.limit;
        this.limitInBytes = builder.limitInBytes;
        this.current = builder.current;
        this.total = builder.total;
    }

    public static IndexingPressureMemory of(Function<Builder, ObjectBuilder<IndexingPressureMemory>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String limit() {
        return this.limit;
    }

    @Nullable
    public final Long limitInBytes() {
        return this.limitInBytes;
    }

    @Nullable
    public final PressureMemory current() {
        return this.current;
    }

    @Nullable
    public final PressureMemory total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.limit != null) {
            generator.writeKey("limit");
            generator.write(this.limit);
        }
        if (this.limitInBytes != null) {
            generator.writeKey("limit_in_bytes");
            generator.write(this.limitInBytes.longValue());
        }
        if (this.current != null) {
            generator.writeKey("current");
            this.current.serialize(generator, mapper);
        }
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIndexingPressureMemoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::limit, JsonpDeserializer.stringDeserializer(), "limit");
        op.add(Builder::limitInBytes, JsonpDeserializer.longDeserializer(), "limit_in_bytes");
        op.add(Builder::current, PressureMemory._DESERIALIZER, "current");
        op.add(Builder::total, PressureMemory._DESERIALIZER, "total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexingPressureMemory> {
        @Nullable
        private String limit;
        @Nullable
        private Long limitInBytes;
        @Nullable
        private PressureMemory current;
        @Nullable
        private PressureMemory total;

        public final Builder limit(@Nullable String value) {
            this.limit = value;
            return this;
        }

        public final Builder limitInBytes(@Nullable Long value) {
            this.limitInBytes = value;
            return this;
        }

        public final Builder current(@Nullable PressureMemory value) {
            this.current = value;
            return this;
        }

        public final Builder current(Function<PressureMemory.Builder, ObjectBuilder<PressureMemory>> fn) {
            return this.current(fn.apply(new PressureMemory.Builder()).build());
        }

        public final Builder total(@Nullable PressureMemory value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<PressureMemory.Builder, ObjectBuilder<PressureMemory>> fn) {
            return this.total(fn.apply(new PressureMemory.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexingPressureMemory build() {
            this._checkSingleUse();
            return new IndexingPressureMemory(this);
        }
    }
}

